/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Resource;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.RequestDTO;
import org.broadleafcommerce.common.TimeDTO;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.rule.MvelHelper;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.domain.OfferRule;
import org.broadleafcommerce.core.offer.service.OfferServiceExtensionManager;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetail;
import org.broadleafcommerce.core.offer.service.processor.BaseProcessor;
import org.broadleafcommerce.core.offer.service.processor.OfferTimeZoneProcessor;
import org.broadleafcommerce.core.offer.service.type.OfferRuleType;
import org.broadleafcommerce.core.offer.service.type.OfferType;
import org.broadleafcommerce.core.order.service.type.FulfillmentType;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.hibernate.tool.hbm2x.StringUtils;
import org.joda.time.LocalDateTime;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public abstract class AbstractBaseProcessor
implements BaseProcessor {
    private static final Log LOG = LogFactory.getLog(AbstractBaseProcessor.class);
    private static final Map EXPRESSION_CACHE = new LRUMap(1000);
    @Resource(name="blOfferTimeZoneProcessor")
    protected OfferTimeZoneProcessor offerTimeZoneProcessor;
    @Resource(name="blOfferServiceExtensionManager")
    protected OfferServiceExtensionManager extensionManager;

    protected CandidatePromotionItems couldOfferApplyToOrderItems(Offer offer, List<PromotableOrderItem> promotableOrderItems) {
        CandidatePromotionItems candidates = new CandidatePromotionItems();
        if (offer.getQualifyingItemCriteria() == null || offer.getQualifyingItemCriteria().size() == 0) {
            candidates.setMatchedQualifier(true);
        } else {
            for (OfferItemCriteria criteria : offer.getQualifyingItemCriteria()) {
                this.checkForItemRequirements(offer, candidates, criteria, promotableOrderItems, true);
                if (candidates.isMatchedQualifier()) continue;
                break;
            }
        }
        if (offer.getType().equals(OfferType.ORDER_ITEM) && offer.getTargetItemCriteria() != null) {
            for (OfferItemCriteria criteria : offer.getTargetItemCriteria()) {
                this.checkForItemRequirements(offer, candidates, criteria, promotableOrderItems, false);
                if (candidates.isMatchedTarget()) continue;
                break;
            }
        }
        if (candidates.isMatchedQualifier() && !this.meetsItemQualifierSubtotal(offer, candidates)) {
            candidates.setMatchedQualifier(false);
        }
        return candidates;
    }

    private boolean isEmpty(Collection<? extends Object> collection) {
        return collection == null || collection.size() == 0;
    }

    private boolean hasPositiveValue(Money money) {
        return money != null && money.greaterThan(Money.ZERO);
    }

    protected boolean meetsItemQualifierSubtotal(Offer offer, CandidatePromotionItems candidateItem) {
        Money qualifyingSubtotal = offer.getQualifyingItemSubTotal();
        if (!this.hasPositiveValue(qualifyingSubtotal)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Offer " + offer.getName() + " does not have an item subtotal requirement."));
            }
            return true;
        }
        if (this.isEmpty(offer.getQualifyingItemCriteria())) {
            if (OfferType.ORDER_ITEM.equals(offer.getType())) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Offer " + offer.getName() + " has a subtotal item requirement but no item qualification criteria."));
                }
                return false;
            }
            Money accumulatedTotal = null;
            for (PromotableOrderItem orderItem : candidateItem.getAllCandidateTargets()) {
                Money itemPrice = orderItem.getCurrentBasePrice().multiply(orderItem.getQuantity());
                if (!(accumulatedTotal = accumulatedTotal == null ? itemPrice : accumulatedTotal.add(itemPrice)).greaterThan(qualifyingSubtotal)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Offer " + offer.getName() + " meets qualifying item subtotal."));
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Offer " + offer.getName() + " does not meet qualifying item subtotal."));
            }
        } else if (candidateItem.getCandidateQualifiersMap() != null) {
            Money accumulatedTotal = null;
            HashSet<PromotableOrderItem> usedItems = new HashSet<PromotableOrderItem>();
            for (OfferItemCriteria criteria : candidateItem.getCandidateQualifiersMap().keySet()) {
                List<PromotableOrderItem> promotableItems = candidateItem.getCandidateQualifiersMap().get(criteria);
                if (promotableItems == null) continue;
                for (PromotableOrderItem item : promotableItems) {
                    if (usedItems.contains(item)) continue;
                    usedItems.add(item);
                    Money itemPrice = item.getCurrentBasePrice().multiply(item.getQuantity());
                    if (!(accumulatedTotal = accumulatedTotal == null ? itemPrice : accumulatedTotal.add(itemPrice)).greaterThan(qualifyingSubtotal)) continue;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Offer " + offer.getName() + " meets the item subtotal requirement."));
                    }
                    return true;
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Offer " + offer.getName() + " does not meet the item subtotal qualifications."));
        }
        return false;
    }

    protected void checkForItemRequirements(Offer offer, CandidatePromotionItems candidates, OfferItemCriteria criteria, List<PromotableOrderItem> promotableOrderItems, boolean isQualifier) {
        boolean matchFound = false;
        int criteriaQuantity = criteria.getQuantity();
        if (criteriaQuantity > 0) {
            for (PromotableOrderItem item : promotableOrderItems) {
                if (!this.couldOrderItemMeetOfferRequirement(criteria, item)) continue;
                if (isQualifier) {
                    candidates.addQualifier(criteria, item);
                } else {
                    candidates.addTarget(criteria, item);
                }
                matchFound = true;
            }
        }
        if (isQualifier) {
            candidates.setMatchedQualifier(matchFound);
        } else {
            candidates.setMatchedTarget(matchFound);
        }
    }

    protected boolean couldOrderItemMeetOfferRequirement(OfferItemCriteria criteria, PromotableOrderItem orderItem) {
        boolean appliesToItem = false;
        if (criteria.getMatchRule() != null && criteria.getMatchRule().trim().length() != 0) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            orderItem.updateRuleVariables(vars);
            Boolean expressionOutcome = this.executeExpression(criteria.getMatchRule(), vars);
            if (expressionOutcome != null && expressionOutcome.booleanValue()) {
                appliesToItem = true;
            }
        } else {
            appliesToItem = true;
        }
        return appliesToItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean executeExpression(String expression, Map<String, Object> vars) {
        try {
            Serializable exp;
            Map map = EXPRESSION_CACHE;
            synchronized (map) {
                exp = (Serializable)EXPRESSION_CACHE.get(expression);
                if (exp == null) {
                    ParserContext context = new ParserContext();
                    context.addImport("OfferType", OfferType.class);
                    context.addImport("FulfillmentType", FulfillmentType.class);
                    context.addImport("MVEL", MVEL.class);
                    context.addImport("MvelHelper", MvelHelper.class);
                    exp = MVEL.compileExpression((String)expression, (ParserContext)context);
                    EXPRESSION_CACHE.put(expression, exp);
                }
            }
            Object test = MVEL.executeExpression((Object)exp, vars);
            return (Boolean)test;
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to parse and/or execute an mvel expression. Reporting to the logs and returning false for the match expression:" + expression), (Throwable)e);
            return false;
        }
    }

    protected void clearAllNonFinalizedQuantities(List<PromotableOrderItemPriceDetail> priceDetails) {
        for (PromotableOrderItemPriceDetail priceDetail : priceDetails) {
            priceDetail.clearAllNonFinalizedQuantities();
        }
    }

    protected void finalizeQuantities(List<PromotableOrderItemPriceDetail> priceDetails) {
        for (PromotableOrderItemPriceDetail priceDetail : priceDetails) {
            priceDetail.finalizeQuantities();
        }
    }

    protected void splitDetailsIfNecessary(List<PromotableOrderItemPriceDetail> priceDetails) {
        for (PromotableOrderItemPriceDetail priceDetail : priceDetails) {
            PromotableOrderItemPriceDetail splitDetail = priceDetail.splitIfNecessary();
            if (splitDetail == null) continue;
            priceDetail.getPromotableOrderItem().getPromotableOrderItemPriceDetails().add(splitDetail);
        }
    }

    @Override
    public List<Offer> filterOffers(List<Offer> offers, Customer customer) {
        List<Offer> filteredOffers = new ArrayList<Offer>();
        if (offers != null && !offers.isEmpty()) {
            filteredOffers = this.removeOutOfDateOffers(offers);
            filteredOffers = this.removeTimePeriodOffers(filteredOffers);
            filteredOffers = this.removeInvalidRequestOffers(filteredOffers);
            filteredOffers = this.removeInvalidCustomerOffers(filteredOffers, customer);
        }
        return filteredOffers;
    }

    protected List<Offer> removeInvalidRequestOffers(List<Offer> offers) {
        RequestDTO requestDTO = null;
        if (BroadleafRequestContext.getBroadleafRequestContext() != null) {
            requestDTO = BroadleafRequestContext.getBroadleafRequestContext().getRequestDTO();
        }
        ArrayList<Offer> offersToRemove = new ArrayList<Offer>();
        for (Offer offer : offers) {
            if (this.couldOfferApplyToRequestDTO(offer, requestDTO)) continue;
            offersToRemove.add(offer);
        }
        for (Offer offer : offersToRemove) {
            offers.remove(offer);
        }
        return offers;
    }

    protected boolean couldOfferApplyToRequestDTO(Offer offer, RequestDTO requestDTO) {
        boolean appliesToRequestRule = false;
        String rule = null;
        OfferRule customerRule = offer.getOfferMatchRules().get(OfferRuleType.REQUEST.getType());
        if (customerRule != null) {
            rule = customerRule.getMatchRule();
        }
        if (rule != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("request", requestDTO);
            Boolean expressionOutcome = this.executeExpression(rule, vars);
            if (expressionOutcome != null && expressionOutcome.booleanValue()) {
                appliesToRequestRule = true;
            }
        } else {
            appliesToRequestRule = true;
        }
        return appliesToRequestRule;
    }

    protected List<Offer> removeTimePeriodOffers(List<Offer> offers) {
        ArrayList<Offer> offersToRemove = new ArrayList<Offer>();
        for (Offer offer : offers) {
            if (this.couldOfferApplyToTimePeriod(offer)) continue;
            offersToRemove.add(offer);
        }
        for (Offer offer : offersToRemove) {
            offers.remove(offer);
        }
        return offers;
    }

    protected boolean couldOfferApplyToTimePeriod(Offer offer) {
        boolean appliesToTimePeriod = false;
        String rule = null;
        OfferRule timeRule = offer.getOfferMatchRules().get(OfferRuleType.TIME.getType());
        if (timeRule != null) {
            rule = timeRule.getMatchRule();
        }
        if (rule != null) {
            TimeZone timeZone = this.getOfferTimeZoneProcessor().getTimeZone(offer);
            TimeDTO timeDto = new TimeDTO(SystemTime.asCalendar((TimeZone)timeZone));
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("time", timeDto);
            Boolean expressionOutcome = this.executeExpression(rule, vars);
            if (expressionOutcome != null && expressionOutcome.booleanValue()) {
                appliesToTimePeriod = true;
            }
        } else {
            appliesToTimePeriod = true;
        }
        return appliesToTimePeriod;
    }

    protected List<Offer> removeOutOfDateOffers(List<Offer> offers) {
        ArrayList<Offer> offersToRemove = new ArrayList<Offer>();
        for (Offer offer : offers) {
            TimeZone timeZone = this.getOfferTimeZoneProcessor().getTimeZone(offer);
            Calendar current = timeZone == null ? SystemTime.asCalendar() : SystemTime.asCalendar((TimeZone)timeZone);
            Calendar start = null;
            if (offer.getStartDate() != null) {
                LocalDateTime startDate = new LocalDateTime((Object)offer.getStartDate());
                start = timeZone == null ? new GregorianCalendar() : new GregorianCalendar(timeZone);
                start.set(1, startDate.getYear());
                start.set(2, startDate.getMonthOfYear() - 1);
                start.set(5, startDate.getDayOfMonth());
                start.set(11, startDate.getHourOfDay());
                start.set(12, startDate.getMinuteOfHour());
                start.set(13, startDate.getSecondOfMinute());
                start.get(11);
                start.get(12);
                if (LOG.isTraceEnabled()) {
                    LOG.debug((Object)("Offer: " + offer.getName() + " timeZone:" + timeZone + " startTime:" + start.getTime() + " currentTime:" + current.getTime()));
                }
            }
            GregorianCalendar end = null;
            if (offer.getEndDate() != null) {
                LocalDateTime endDate = new LocalDateTime((Object)offer.getEndDate());
                end = timeZone == null ? new GregorianCalendar() : new GregorianCalendar(timeZone);
                end.set(1, endDate.getYear());
                end.set(2, endDate.getMonthOfYear() - 1);
                end.set(5, endDate.getDayOfMonth());
                end.set(11, endDate.getHourOfDay());
                end.set(12, endDate.getMinuteOfHour());
                end.set(13, endDate.getSecondOfMinute());
                end.get(11);
                end.get(12);
                if (LOG.isTraceEnabled()) {
                    LOG.debug((Object)("Offer: " + offer.getName() + " endTime:" + start.getTime()));
                }
            }
            if (offer.getStartDate() == null || start.after(current)) {
                offersToRemove.add(offer);
                continue;
            }
            if (offer.getEndDate() == null || !end.before(current)) continue;
            offersToRemove.add(offer);
        }
        for (Offer offer : offersToRemove) {
            offers.remove(offer);
        }
        return offers;
    }

    protected List<Offer> removeInvalidCustomerOffers(List<Offer> offers, Customer customer) {
        ArrayList<Offer> offersToRemove = new ArrayList<Offer>();
        for (Offer offer : offers) {
            if (this.couldOfferApplyToCustomer(offer, customer)) continue;
            offersToRemove.add(offer);
        }
        for (Offer offer : offersToRemove) {
            offers.remove(offer);
        }
        return offers;
    }

    protected boolean couldOfferApplyToCustomer(Offer offer, Customer customer) {
        boolean appliesToCustomer = false;
        String rule = null;
        if (!StringUtils.isEmpty((String)offer.getAppliesToCustomerRules())) {
            rule = offer.getAppliesToCustomerRules();
        } else {
            OfferRule customerRule = offer.getOfferMatchRules().get(OfferRuleType.CUSTOMER.getType());
            if (customerRule != null) {
                rule = customerRule.getMatchRule();
            }
        }
        if (rule != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("customer", customer);
            Boolean expressionOutcome = this.executeExpression(rule, vars);
            if (expressionOutcome != null && expressionOutcome.booleanValue()) {
                appliesToCustomer = true;
            }
        } else {
            appliesToCustomer = true;
        }
        return appliesToCustomer;
    }

    public OfferTimeZoneProcessor getOfferTimeZoneProcessor() {
        return this.offerTimeZoneProcessor;
    }

    public void setOfferTimeZoneProcessor(OfferTimeZoneProcessor offerTimeZoneProcessor) {
        this.offerTimeZoneProcessor = offerTimeZoneProcessor;
    }
}

