/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.inventory.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.inventory.service.InventoryService;
import org.broadleafcommerce.core.inventory.service.InventoryUnavailableException;
import org.broadleafcommerce.core.inventory.service.type.InventoryType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="blInventoryService")
public class InventoryServiceImpl
implements InventoryService {
    private static final Log LOG = LogFactory.getLog(InventoryServiceImpl.class);
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;

    protected boolean checkBasicAvailablility(Sku sku) {
        Boolean available = sku.isAvailable();
        if (available == null) {
            available = true;
        }
        return sku != null && available != false && sku.isActive() && !InventoryType.UNAVAILABLE.equals(sku.getInventoryType());
    }

    @Override
    public Integer retrieveQuantityAvailable(Sku sku) {
        if (this.checkBasicAvailablility(sku)) {
            if (InventoryType.CHECK_QUANTITY.equals(sku.getInventoryType())) {
                return sku.getQuantityAvailable();
            }
            if (InventoryType.ALWAYS_AVAILABLE.equals(sku.getInventoryType()) || sku.getInventoryType() == null) {
                return null;
            }
        }
        return 0;
    }

    @Override
    public Map<Sku, Integer> retrieveQuantitiesAvailable(Set<Sku> skus) {
        HashMap<Sku, Integer> inventories = new HashMap<Sku, Integer>();
        for (Sku sku : skus) {
            if (this.checkBasicAvailablility(sku)) {
                if (InventoryType.CHECK_QUANTITY.equals(sku.getInventoryType())) {
                    inventories.put(sku, sku.getQuantityAvailable());
                    continue;
                }
                if (sku.getInventoryType() == null || InventoryType.ALWAYS_AVAILABLE.equals(sku.getInventoryType())) {
                    inventories.put(sku, Integer.MAX_VALUE);
                    continue;
                }
                inventories.put(sku, 0);
                continue;
            }
            inventories.put(sku, 0);
        }
        return inventories;
    }

    @Override
    public boolean isAvailable(Sku sku, int quantity) {
        if (quantity < 1) {
            throw new IllegalArgumentException("Quantity " + quantity + " is not valid. Must be greater than zero.");
        }
        if (this.checkBasicAvailablility(sku) && InventoryType.CHECK_QUANTITY.equals(sku.getInventoryType())) {
            Integer quantityAvailable = this.retrieveQuantityAvailable(sku);
            return quantityAvailable != null && quantity <= quantityAvailable;
        }
        return false;
    }

    @Override
    @Transactional(value="blTransactionManager", rollbackFor={InventoryUnavailableException.class})
    public void decrementInventory(Sku sku, int quantity) throws InventoryUnavailableException {
        if (quantity < 1) {
            throw new IllegalArgumentException("Quantity " + quantity + " is not valid. Must be greater than zero.");
        }
        if (this.checkBasicAvailablility(sku)) {
            if (InventoryType.CHECK_QUANTITY.equals(sku.getInventoryType())) {
                Integer inventoryAvailable = this.retrieveQuantityAvailable(sku);
                if (inventoryAvailable == null) {
                    return;
                }
                if (inventoryAvailable < quantity) {
                    throw new InventoryUnavailableException("There was not enough inventory to fulfill this request.", sku.getId(), quantity, inventoryAvailable);
                }
                int newInventory = inventoryAvailable - quantity;
                sku.setQuantityAvailable(newInventory);
                this.catalogService.saveSku(sku);
            } else {
                LOG.info((Object)"Not decrementing inventory as the Sku has been marked as always available");
            }
        } else {
            throw new InventoryUnavailableException("The Sku has been marked as unavailable", sku.getId(), quantity, 0);
        }
    }

    @Override
    @Transactional(value="blTransactionManager", rollbackFor={InventoryUnavailableException.class})
    public void decrementInventory(Map<Sku, Integer> skuQuantities) throws InventoryUnavailableException {
        for (Map.Entry<Sku, Integer> entry : skuQuantities.entrySet()) {
            Sku sku = entry.getKey();
            Integer quantity = entry.getValue();
            if (quantity == null) {
                throw new IllegalArgumentException("Quantity was null for skuId " + sku.getId());
            }
            this.decrementInventory(entry.getKey(), quantity);
        }
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void incrementInventory(Sku sku, int quantity) {
        if (quantity < 1) {
            throw new IllegalArgumentException("Quantity " + quantity + " is not valid. Must be greater than zero.");
        }
        if (InventoryType.CHECK_QUANTITY.equals(sku.getInventoryType())) {
            int inventoryAvailable = this.retrieveQuantityAvailable(sku);
            int newInventory = inventoryAvailable + quantity;
            sku.setQuantityAvailable(newInventory);
            this.catalogService.saveSku(sku);
        } else {
            LOG.info((Object)"Not incrementing inventory as the Sku has been marked as always available");
        }
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void incrementInventory(Map<Sku, Integer> skuQuantities) {
        for (Map.Entry<Sku, Integer> entry : skuQuantities.entrySet()) {
            Sku sku = entry.getKey();
            Integer quantity = entry.getValue();
            if (quantity == null) {
                throw new IllegalArgumentException("Quantity was null for skuId " + sku.getId());
            }
            this.incrementInventory(entry.getKey(), quantity);
        }
    }

    public void setCatalogService(CatalogService catalogService) {
        this.catalogService = catalogService;
    }
}

