/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.checkout.service.workflow;

import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.inventory.service.InventoryService;
import org.broadleafcommerce.core.inventory.service.InventoryUnavailableException;
import org.broadleafcommerce.core.order.service.workflow.WorkflowInventoryExtensionHandler;
import org.broadleafcommerce.core.order.service.workflow.WorkflowInventoryExtensionManager;
import org.broadleafcommerce.core.workflow.Activity;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.state.RollbackFailureException;
import org.broadleafcommerce.core.workflow.state.RollbackHandler;
import org.springframework.stereotype.Component;

@Component(value="blDecrementInventoryRollbackHandler")
public class DecrementInventoryRollbackHandler
implements RollbackHandler<CheckoutSeed> {
    private static final Log LOG = LogFactory.getLog(DecrementInventoryRollbackHandler.class);
    public static final String ROLLBACK_BLC_INVENTORY_DECREMENTED = "ROLLBACK_BLC_INVENTORY_DECREMENTED";
    public static final String ROLLBACK_BLC_INVENTORY_INCREMENTED = "ROLLBACK_BLC_INVENTORY_INCREMENTED";
    public static final String ROLLBACK_BLC_ORDER_ID = "ROLLBACK_BLC_ORDER_ID";
    @Resource(name="blInventoryService")
    protected InventoryService inventoryService;
    @Resource(name="blWorkflowInventoryExtensionManager")
    protected WorkflowInventoryExtensionManager extensionManager;

    @Override
    public void rollbackState(Activity<? extends ProcessContext<CheckoutSeed>> activity, ProcessContext<CheckoutSeed> processContext, Map<String, Object> stateConfiguration) throws RollbackFailureException {
        ExtensionResultStatusType extensionResult = ((WorkflowInventoryExtensionHandler)this.extensionManager.getProxy()).rollbackInventoryOperation(processContext, stateConfiguration);
        if (ExtensionResultStatusType.NOT_HANDLED.equals((Object)extensionResult)) {
            if (stateConfiguration == null || stateConfiguration.get(ROLLBACK_BLC_INVENTORY_DECREMENTED) == null && stateConfiguration.get(ROLLBACK_BLC_INVENTORY_INCREMENTED) == null) {
                return;
            }
            String orderId = "(Not Known)";
            if (stateConfiguration.get(ROLLBACK_BLC_ORDER_ID) != null) {
                orderId = String.valueOf(stateConfiguration.get(ROLLBACK_BLC_ORDER_ID));
            }
            Map inventoryToIncrement = (Map)stateConfiguration.get(ROLLBACK_BLC_INVENTORY_DECREMENTED);
            Map inventoryToDecrement = (Map)stateConfiguration.get(ROLLBACK_BLC_INVENTORY_INCREMENTED);
            if (inventoryToIncrement != null && !inventoryToIncrement.isEmpty()) {
                try {
                    this.inventoryService.incrementInventory(inventoryToIncrement);
                }
                catch (Exception ex) {
                    RollbackFailureException rfe = new RollbackFailureException("An unexpected error occured in the error handler of the checkout workflow trying to compensate for inventory. This happend for order ID: " + orderId + ". This should be corrected manually!", ex);
                    rfe.setActivity(activity);
                    rfe.setProcessContext(processContext);
                    rfe.setStateItems(stateConfiguration);
                    throw rfe;
                }
            }
            if (inventoryToDecrement != null && !inventoryToDecrement.isEmpty()) {
                try {
                    this.inventoryService.decrementInventory(inventoryToDecrement);
                }
                catch (InventoryUnavailableException e) {
                    RollbackFailureException rfe = new RollbackFailureException("While trying roll back (decrement) inventory, we found that there was none left decrement.", e);
                    rfe.setActivity(activity);
                    rfe.setProcessContext(processContext);
                    rfe.setStateItems(stateConfiguration);
                    throw rfe;
                }
                catch (RuntimeException ex) {
                    LOG.error((Object)("An unexpected error occured in the error handler of the checkout workflow trying to compensate for inventory. This happend for order ID: " + orderId + ". This should be corrected manually!"), (Throwable)ex);
                    RollbackFailureException rfe = new RollbackFailureException("An unexpected error occured in the error handler of the checkout workflow trying to compensate for inventory. This happend for order ID: " + orderId + ". This should be corrected manually!", ex);
                    rfe.setActivity(activity);
                    rfe.setProcessContext(processContext);
                    rfe.setStateItems(stateConfiguration);
                    throw rfe;
                }
            }
        }
    }

    public void setInventoryService(InventoryService service) {
        this.inventoryService = service;
    }
}

