/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.checkout.service.workflow;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.inventory.service.InventoryService;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.workflow.WorkflowInventoryExtensionHandler;
import org.broadleafcommerce.core.order.service.workflow.WorkflowInventoryExtensionManager;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.state.ActivityStateManagerImpl;

public class DecrementInventoryActivity
extends BaseActivity<ProcessContext<CheckoutSeed>> {
    @Resource(name="blInventoryService")
    protected InventoryService inventoryService;
    @Resource(name="blWorkflowInventoryExtensionManager")
    protected WorkflowInventoryExtensionManager extensionManager;

    public DecrementInventoryActivity() {
        super.setAutomaticallyRegisterRollbackHandler(false);
    }

    @Override
    public ProcessContext<CheckoutSeed> execute(ProcessContext<CheckoutSeed> context) throws Exception {
        ExtensionResultStatusType extensionResult;
        CheckoutSeed seed = context.getSeedData();
        List<OrderItem> orderItems = seed.getOrder().getOrderItems();
        HashMap<Sku, Integer> skuInventoryMap = new HashMap<Sku, Integer>();
        for (OrderItem orderItem : orderItems) {
            if (orderItem instanceof DiscreteOrderItem) {
                Sku sku = ((DiscreteOrderItem)orderItem).getSku();
                Integer quantity = (Integer)skuInventoryMap.get(sku);
                quantity = quantity == null ? Integer.valueOf(orderItem.getQuantity()) : Integer.valueOf(quantity + orderItem.getQuantity());
                skuInventoryMap.put(sku, quantity);
                continue;
            }
            if (!(orderItem instanceof BundleOrderItem)) continue;
            BundleOrderItem bundleItem = (BundleOrderItem)orderItem;
            skuInventoryMap.put(bundleItem.getSku(), bundleItem.getQuantity());
            List<DiscreteOrderItem> discreteItems = bundleItem.getDiscreteOrderItems();
            for (DiscreteOrderItem discreteItem : discreteItems) {
                Integer quantity = skuInventoryMap.get(discreteItem.getSku().getId());
                quantity = quantity == null ? Integer.valueOf(discreteItem.getQuantity() * bundleItem.getQuantity()) : Integer.valueOf(quantity + discreteItem.getQuantity() * bundleItem.getQuantity());
                skuInventoryMap.put(discreteItem.getSku(), quantity);
            }
        }
        HashMap<String, Object> rollbackState = new HashMap<String, Object>();
        if (this.getRollbackHandler() != null && !this.getAutomaticallyRegisterRollbackHandler()) {
            if (this.getStateConfiguration() != null && !this.getStateConfiguration().isEmpty()) {
                rollbackState.putAll(this.getStateConfiguration());
            }
            ActivityStateManagerImpl.getStateManager().registerState(this, context, this.getRollbackRegion(), this.getRollbackHandler(), rollbackState);
        }
        if (!skuInventoryMap.isEmpty() && ExtensionResultStatusType.NOT_HANDLED.equals((Object)(extensionResult = ((WorkflowInventoryExtensionHandler)this.extensionManager.getProxy()).decrementInventory(skuInventoryMap, context, rollbackState)))) {
            this.inventoryService.decrementInventory(skuInventoryMap);
            if (this.getRollbackHandler() != null && !this.getAutomaticallyRegisterRollbackHandler()) {
                rollbackState.put("ROLLBACK_BLC_INVENTORY_DECREMENTED", skuInventoryMap);
                rollbackState.put("ROLLBACK_BLC_ORDER_ID", seed.getOrder().getId());
            }
        }
        return context;
    }

    public void setInventoryService(InventoryService service) {
        this.inventoryService = service;
    }
}

