/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.i18n.service.DynamicTranslationProvider;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.core.catalog.domain.ProductOption;
import org.broadleafcommerce.core.catalog.domain.ProductOptionImpl;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValue;
import org.broadleafcommerce.core.catalog.service.dynamic.DynamicSkuPrices;
import org.broadleafcommerce.core.catalog.service.dynamic.SkuPricingConsiderationContext;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PRODUCT_OPTION_VALUE")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
@AdminPresentationClass(friendlyName="Product Option Value")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"})})
public class ProductOptionValueImpl
implements ProductOptionValue {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="ProductOptionValueId")
    @GenericGenerator(name="ProductOptionValueId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="ProductOptionValueImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.ProductOptionValueImpl")})
    @Column(name="PRODUCT_OPTION_VALUE_ID")
    protected Long id;
    @Column(name="ATTRIBUTE_VALUE")
    @AdminPresentation(friendlyName="productOptionValue_attributeValue", prominent=true, order=1000, translatable=true, gridOrder=1000)
    protected String attributeValue;
    @Column(name="DISPLAY_ORDER")
    @AdminPresentation(friendlyName="productOptionValue_displayOrder", prominent=true, gridOrder=3000, order=3000)
    protected Long displayOrder;
    @Column(name="PRICE_ADJUSTMENT", precision=19, scale=5)
    @AdminPresentation(friendlyName="productOptionValue_adjustment", fieldType=SupportedFieldType.MONEY, prominent=true, gridOrder=2000, order=2000)
    protected BigDecimal priceAdjustment;
    @ManyToOne(targetEntity=ProductOptionImpl.class)
    @JoinColumn(name="PRODUCT_OPTION_ID")
    protected ProductOption productOption;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getAttributeValue() {
        return DynamicTranslationProvider.getValue((Object)this, (String)"attributeValue", (String)this.attributeValue);
    }

    @Override
    public void setAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    @Override
    public Long getDisplayOrder() {
        return this.displayOrder;
    }

    @Override
    public void setDisplayOrder(Long displayOrder) {
        this.displayOrder = displayOrder;
    }

    @Override
    public Money getPriceAdjustment() {
        Money returnPrice = null;
        if (SkuPricingConsiderationContext.hasDynamicPricing()) {
            DynamicSkuPrices dynamicPrices = SkuPricingConsiderationContext.getSkuPricingService().getPriceAdjustment(this, this.priceAdjustment == null ? null : new Money(this.priceAdjustment), SkuPricingConsiderationContext.getSkuPricingConsiderationContext());
            returnPrice = dynamicPrices.getPriceAdjustment();
        } else if (this.priceAdjustment != null) {
            returnPrice = new Money(this.priceAdjustment, Money.defaultCurrency());
        }
        return returnPrice;
    }

    @Override
    public void setPriceAdjustment(Money priceAdjustment) {
        this.priceAdjustment = Money.toAmount((Money)priceAdjustment);
    }

    @Override
    public ProductOption getProductOption() {
        return this.productOption;
    }

    @Override
    public void setProductOption(ProductOption productOption) {
        this.productOption = productOption;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductOptionValueImpl other = (ProductOptionValueImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.getAttributeValue() == null ? other.getAttributeValue() != null : !this.getAttributeValue().equals(other.getAttributeValue()));
    }

    public static class Presentation {

        public static class FieldOrder {
            public static final int ATTRIBUTE_VALUE = 1000;
            public static final int DISPLAY_ORDER = 3000;
            public static final int PRICE_ADJUSTMENT = 2000;
        }
    }
}

