/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.admin.domain.AdminMainEntity;
import org.broadleafcommerce.common.cache.Hydrated;
import org.broadleafcommerce.common.cache.HydratedSetup;
import org.broadleafcommerce.common.cache.engine.CacheFactoryException;
import org.broadleafcommerce.common.extensibility.jpa.clone.ClonePolicyAdornedTargetCollection;
import org.broadleafcommerce.common.extensibility.jpa.clone.ClonePolicyMap;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.i18n.service.DynamicTranslationProvider;
import org.broadleafcommerce.common.media.domain.Media;
import org.broadleafcommerce.common.media.domain.MediaImpl;
import org.broadleafcommerce.common.persistence.ArchiveStatus;
import org.broadleafcommerce.common.persistence.Status;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationAdornedTargetCollection;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationDataDrivenEnumeration;
import org.broadleafcommerce.common.presentation.AdminPresentationMap;
import org.broadleafcommerce.common.presentation.AdminPresentationMapKey;
import org.broadleafcommerce.common.presentation.AdminPresentationToOneLookup;
import org.broadleafcommerce.common.presentation.OptionFilterParam;
import org.broadleafcommerce.common.presentation.OptionFilterParamType;
import org.broadleafcommerce.common.presentation.ValidationConfiguration;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.common.util.DateUtil;
import org.broadleafcommerce.common.util.UrlUtil;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.common.web.Locatable;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryAttribute;
import org.broadleafcommerce.core.catalog.domain.CategoryAttributeImpl;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXref;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXrefImpl;
import org.broadleafcommerce.core.catalog.domain.CategoryXref;
import org.broadleafcommerce.core.catalog.domain.CategoryXrefImpl;
import org.broadleafcommerce.core.catalog.domain.CrossSaleProductImpl;
import org.broadleafcommerce.core.catalog.domain.FeaturedProduct;
import org.broadleafcommerce.core.catalog.domain.FeaturedProductImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.RelatedProduct;
import org.broadleafcommerce.core.catalog.domain.UpSaleProductImpl;
import org.broadleafcommerce.core.catalog.extension.CategoryEntityExtensionHandler;
import org.broadleafcommerce.core.catalog.extension.CategoryEntityExtensionManager;
import org.broadleafcommerce.core.inventory.service.type.InventoryType;
import org.broadleafcommerce.core.order.service.type.FulfillmentType;
import org.broadleafcommerce.core.search.domain.CategorySearchFacet;
import org.broadleafcommerce.core.search.domain.CategorySearchFacetImpl;
import org.broadleafcommerce.core.search.domain.SearchFacet;
import org.broadleafcommerce.core.search.domain.SearchFacetImpl;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Type;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CATEGORY")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCategories")
@AdminPresentationClass(friendlyName="CategoryImpl_baseCategory")
@SQLDelete(sql="UPDATE BLC_CATEGORY SET ARCHIVED = 'Y' WHERE CATEGORY_ID = ?")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"sandboxPreCloneInformation"}), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"})})
public class CategoryImpl
implements Category,
Status,
AdminMainEntity,
Locatable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(CategoryImpl.class);
    @Id
    @GeneratedValue(generator="CategoryId")
    @GenericGenerator(name="CategoryId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="CategoryImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.CategoryImpl")})
    @Column(name="CATEGORY_ID")
    @AdminPresentation(friendlyName="CategoryImpl_Category_ID", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @Column(name="NAME", nullable=false)
    @Index(name="CATEGORY_NAME_INDEX", columnNames={"NAME"})
    @AdminPresentation(friendlyName="CategoryImpl_Category_Name", order=1000, group="CategoryImpl_Category_Description", groupOrder=1000, prominent=true, gridOrder=1, columnWidth="300px", translatable=true)
    protected String name;
    @Column(name="URL")
    @AdminPresentation(friendlyName="CategoryImpl_Category_Url", order=2000, group="CategoryImpl_Category_Description", groupOrder=1000, prominent=true, gridOrder=2, columnWidth="300px", validationConfigurations={@ValidationConfiguration(validationImplementation="blUriPropertyValidator")})
    @Index(name="CATEGORY_URL_INDEX", columnNames={"URL"})
    protected String url;
    @Column(name="URL_KEY")
    @Index(name="CATEGORY_URLKEY_INDEX", columnNames={"URL_KEY"})
    @AdminPresentation(friendlyName="CategoryImpl_Category_Url_Key", tab="CategoryImpl_Advanced_Tab", tabOrder=4000, group="CategoryImpl_Advanced", groupOrder=1000, excluded=true)
    protected String urlKey;
    @Column(name="DESCRIPTION")
    @AdminPresentation(friendlyName="CategoryImpl_Category_Description", group="CategoryImpl_Category_Description", groupOrder=1000, largeEntry=true, excluded=true, translatable=true)
    protected String description;
    @Column(name="TAX_CODE")
    @AdminPresentation(friendlyName="CategoryImpl_Category_TaxCode", order=4000, group="CategoryImpl_Advanced")
    @AdminPresentationDataDrivenEnumeration(optionCanEditValues=true, optionFilterParams={@OptionFilterParam(param="type.key", value="TAX_CODE", paramType=OptionFilterParamType.STRING)})
    protected String taxCode;
    @Column(name="ACTIVE_START_DATE")
    @AdminPresentation(friendlyName="CategoryImpl_Category_Active_Start_Date", order=1000, group="CategoryImpl_Active_Date_Range", groupOrder=2000)
    protected Date activeStartDate;
    @Column(name="ACTIVE_END_DATE")
    @AdminPresentation(friendlyName="CategoryImpl_Category_Active_End_Date", order=2000, group="CategoryImpl_Active_Date_Range", groupOrder=2000)
    protected Date activeEndDate;
    @Column(name="DISPLAY_TEMPLATE")
    @AdminPresentation(friendlyName="CategoryImpl_Category_Display_Template", order=1000, tab="CategoryImpl_Advanced_Tab", tabOrder=4000, group="CategoryImpl_Advanced", groupOrder=1000)
    protected String displayTemplate;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="LONG_DESCRIPTION", length=0x7FFFFFFE)
    @AdminPresentation(friendlyName="CategoryImpl_Category_Long_Description", order=3000, group="CategoryImpl_Category_Description", groupOrder=1000, largeEntry=true, fieldType=SupportedFieldType.HTML_BASIC, translatable=true)
    protected String longDescription;
    @ManyToOne(targetEntity=CategoryImpl.class)
    @JoinColumn(name="DEFAULT_PARENT_CATEGORY_ID")
    @Index(name="CATEGORY_PARENT_INDEX", columnNames={"DEFAULT_PARENT_CATEGORY_ID"})
    @AdminPresentation(friendlyName="CategoryImpl_defaultParentCategory", order=4000, group="CategoryImpl_Category_Description", groupOrder=1000)
    @AdminPresentationToOneLookup
    protected Category defaultParentCategory;
    @OneToMany(targetEntity=CategoryXrefImpl.class, mappedBy="category", orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    @OrderBy(value="displayOrder")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCategories")
    @BatchSize(size=50)
    @AdminPresentationAdornedTargetCollection(targetObjectProperty="subCategory", parentObjectProperty="category", friendlyName="allChildCategoriesTitle", sortProperty="displayOrder", tab="CategoryImpl_Advanced_Tab", tabOrder=4000, gridVisibleFields={"name"})
    @ClonePolicyAdornedTargetCollection(unowned=true)
    protected List<CategoryXref> allChildCategoryXrefs = new ArrayList<CategoryXref>(10);
    @OneToMany(targetEntity=CategoryXrefImpl.class, mappedBy="subCategory", orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    @OrderBy(value="displayOrder")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCategories")
    @BatchSize(size=50)
    @AdminPresentationAdornedTargetCollection(targetObjectProperty="category", parentObjectProperty="subCategory", friendlyName="allParentCategoriesTitle", sortProperty="displayOrder", tab="CategoryImpl_Advanced_Tab", tabOrder=4000, gridVisibleFields={"name"})
    @ClonePolicyAdornedTargetCollection(unowned=true)
    protected List<CategoryXref> allParentCategoryXrefs = new ArrayList<CategoryXref>(10);
    @OneToMany(targetEntity=CategoryProductXrefImpl.class, mappedBy="category", orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    @OrderBy(value="displayOrder")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCategories")
    @BatchSize(size=50)
    @AdminPresentationAdornedTargetCollection(targetObjectProperty="product", parentObjectProperty="category", friendlyName="allProductsTitle", sortProperty="displayOrder", tab="CategoryImpl_Products_Tab", tabOrder=5000, gridVisibleFields={"defaultSku.name"})
    @ClonePolicyAdornedTargetCollection(unowned=true)
    protected List<CategoryProductXref> allProductXrefs = new ArrayList<CategoryProductXref>(10);
    @ElementCollection
    @MapKeyColumn(name="NAME")
    @Column(name="URL")
    @CollectionTable(name="BLC_CATEGORY_IMAGE", joinColumns={@JoinColumn(name="CATEGORY_ID")})
    @BatchSize(size=50)
    @Deprecated
    protected Map<String, String> categoryImages = new HashMap<String, String>(10);
    @ManyToMany(targetEntity=MediaImpl.class)
    @JoinTable(name="BLC_CATEGORY_MEDIA_MAP", inverseJoinColumns={@JoinColumn(name="MEDIA_ID", referencedColumnName="MEDIA_ID")})
    @MapKeyColumn(name="MAP_KEY")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCategories")
    @BatchSize(size=50)
    @AdminPresentationMap(friendlyName="SkuImpl_Sku_Media", tab="CategoryImpl_Media_Tab", tabOrder=3000, keyPropertyFriendlyName="SkuImpl_Sku_Media_Key", deleteEntityUponRemove=true, mediaField="url", keys={@AdminPresentationMapKey(keyName="primary", friendlyKeyName="mediaPrimary"), @AdminPresentationMapKey(keyName="alt1", friendlyKeyName="mediaAlternate1"), @AdminPresentationMapKey(keyName="alt2", friendlyKeyName="mediaAlternate2"), @AdminPresentationMapKey(keyName="alt3", friendlyKeyName="mediaAlternate3"), @AdminPresentationMapKey(keyName="alt4", friendlyKeyName="mediaAlternate4"), @AdminPresentationMapKey(keyName="alt5", friendlyKeyName="mediaAlternate5"), @AdminPresentationMapKey(keyName="alt6", friendlyKeyName="mediaAlternate6")})
    @ClonePolicyMap
    protected Map<String, Media> categoryMedia = new HashMap<String, Media>(10);
    @OneToMany(mappedBy="category", targetEntity=FeaturedProductImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCategories")
    @OrderBy(value="sequence")
    @BatchSize(size=50)
    @AdminPresentationAdornedTargetCollection(friendlyName="featuredProductsTitle", order=1000, tab="CategoryImpl_Marketing_Tab", tabOrder=2000, targetObjectProperty="product", sortProperty="sequence", maintainedAdornedTargetFields={"promotionMessage"}, gridVisibleFields={"defaultSku.name", "promotionMessage"})
    @ClonePolicyAdornedTargetCollection
    protected List<FeaturedProduct> featuredProducts = new ArrayList<FeaturedProduct>(10);
    @OneToMany(mappedBy="category", targetEntity=CrossSaleProductImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCategories")
    @OrderBy(value="sequence")
    @AdminPresentationAdornedTargetCollection(friendlyName="crossSaleProductsTitle", order=2000, tab="CategoryImpl_Marketing_Tab", tabOrder=2000, targetObjectProperty="relatedSaleProduct", sortProperty="sequence", maintainedAdornedTargetFields={"promotionMessage"}, gridVisibleFields={"defaultSku.name", "promotionMessage"})
    @ClonePolicyAdornedTargetCollection
    protected List<RelatedProduct> crossSaleProducts = new ArrayList<RelatedProduct>();
    @OneToMany(mappedBy="category", targetEntity=UpSaleProductImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCategories")
    @OrderBy(value="sequence")
    @AdminPresentationAdornedTargetCollection(friendlyName="upsaleProductsTitle", order=3000, tab="CategoryImpl_Marketing_Tab", tabOrder=2000, targetObjectProperty="relatedSaleProduct", sortProperty="sequence", maintainedAdornedTargetFields={"promotionMessage"}, gridVisibleFields={"defaultSku.name", "promotionMessage"})
    @ClonePolicyAdornedTargetCollection
    protected List<RelatedProduct> upSaleProducts = new ArrayList<RelatedProduct>();
    @OneToMany(mappedBy="category", targetEntity=CategorySearchFacetImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCategories")
    @OrderBy(value="sequence")
    @AdminPresentationAdornedTargetCollection(friendlyName="categoryFacetsTitle", order=1000, tab="CategoryImpl_categoryFacetsTab", tabOrder=3500, targetObjectProperty="searchFacet", sortProperty="sequence", gridVisibleFields={"field", "label", "searchDisplayPriority"})
    @BatchSize(size=50)
    @ClonePolicyAdornedTargetCollection
    protected List<CategorySearchFacet> searchFacets = new ArrayList<CategorySearchFacet>();
    @ManyToMany(targetEntity=SearchFacetImpl.class)
    @JoinTable(name="BLC_CAT_SEARCH_FACET_EXCL_XREF", joinColumns={@JoinColumn(name="CATEGORY_ID")}, inverseJoinColumns={@JoinColumn(name="SEARCH_FACET_ID", nullable=true)})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    @AdminPresentationAdornedTargetCollection(order=2000, joinEntityClass="org.broadleafcommerce.core.search.domain.CategoryExcludedSearchFacetImpl", targetObjectProperty="searchFacet", parentObjectProperty="category", friendlyName="excludedFacetsTitle", tab="CategoryImpl_categoryFacetsTab", tabOrder=3500, gridVisibleFields={"field", "label", "searchDisplayPriority"})
    @ClonePolicyAdornedTargetCollection
    protected List<SearchFacet> excludedSearchFacets = new ArrayList<SearchFacet>(10);
    @OneToMany(mappedBy="category", targetEntity=CategoryAttributeImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCategories")
    @MapKey(name="name")
    @BatchSize(size=50)
    @AdminPresentationMap(friendlyName="categoryAttributesTitle", tab="CategoryImpl_Advanced_Tab", tabOrder=4000, deleteEntityUponRemove=true, forceFreeFormKeys=true, keyPropertyFriendlyName="ProductAttributeImpl_Attribute_Name")
    @ClonePolicyMap
    protected Map<String, CategoryAttribute> categoryAttributes = new HashMap<String, CategoryAttribute>();
    @Column(name="INVENTORY_TYPE")
    @AdminPresentation(friendlyName="CategoryImpl_Category_InventoryType", order=2000, helpText="inventoryTypeHelpText", tab="CategoryImpl_Advanced_Tab", tabOrder=4000, group="CategoryImpl_Advanced", groupOrder=1000, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.inventory.service.type.InventoryType")
    protected String inventoryType;
    @Column(name="FULFILLMENT_TYPE")
    @AdminPresentation(friendlyName="CategoryImpl_Category_FulfillmentType", order=3000, tab="CategoryImpl_Advanced_Tab", tabOrder=4000, group="CategoryImpl_Advanced", groupOrder=1000, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.order.service.type.FulfillmentType")
    protected String fulfillmentType;
    @Embedded
    protected ArchiveStatus archiveStatus = new ArchiveStatus();
    @Transient
    @Deprecated
    protected Map<String, List<Long>> childCategoryURLMap;
    @Transient
    @Hydrated(factoryMethod="createChildCategoryIds")
    protected List<Long> childCategoryIds;
    @Transient
    protected List<CategoryXref> childCategoryXrefs = new ArrayList<CategoryXref>(50);
    @Transient
    protected List<Category> legacyChildCategories = new ArrayList<Category>(50);
    @Transient
    protected List<Category> allLegacyChildCategories = new ArrayList<Category>(50);
    @Transient
    protected List<FeaturedProduct> filteredFeaturedProducts = null;
    @Transient
    protected List<RelatedProduct> filteredCrossSales = null;
    @Transient
    protected List<RelatedProduct> filteredUpSales = null;
    protected static Comparator<CategorySearchFacet> facetPositionComparator = new Comparator<CategorySearchFacet>(){

        @Override
        public int compare(CategorySearchFacet o1, CategorySearchFacet o2) {
            return o1.getSequence().compareTo(o2.getSequence());
        }
    };

    private static String buildLink(Category category, boolean ignoreTopLevel) {
        StringBuilder linkBuffer = new StringBuilder(50);
        for (Category myCategory = category; myCategory != null; myCategory = myCategory.getDefaultParentCategory()) {
            if (ignoreTopLevel && myCategory.getDefaultParentCategory() == null) continue;
            if (linkBuffer.length() == 0) {
                linkBuffer.append(myCategory.getUrlKey());
                continue;
            }
            if (myCategory.getUrlKey() == null || "/".equals(myCategory.getUrlKey())) continue;
            linkBuffer.insert(0, myCategory.getUrlKey() + '/');
        }
        return linkBuffer.toString();
    }

    private static void fillInURLMapForCategory(Map<String, List<Long>> categoryUrlMap, Category category, String startingPath, List<Long> startingCategoryList) throws CacheFactoryException {
        String urlKey = category.getUrlKey();
        if (urlKey == null) {
            throw new CacheFactoryException("Cannot create childCategoryURLMap - the urlKey for a category(" + category.getId() + ") was null");
        }
        String currentPath = "";
        if (!"/".equals(category.getUrlKey())) {
            currentPath = startingPath + "/" + category.getUrlKey();
        }
        ArrayList<Long> newCategoryList = new ArrayList<Long>(startingCategoryList);
        newCategoryList.add(category.getId());
        categoryUrlMap.put(currentPath, newCategoryList);
        for (CategoryXref currentCategory : category.getChildCategoryXrefs()) {
            CategoryImpl.fillInURLMapForCategory(categoryUrlMap, currentCategory.getSubCategory(), currentPath, newCategoryList);
        }
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return DynamicTranslationProvider.getValue((Object)this, (String)"name", (String)this.name);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getUrl() {
        if (this.url == null || this.url.equals("") || this.url.startsWith("/")) {
            return this.url;
        }
        if (this.url.contains(":") && !this.url.contains("?") || this.url.indexOf(63, this.url.indexOf(58)) != -1) {
            return this.url;
        }
        return "/" + this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUrlKey() {
        if ((this.urlKey == null || "".equals(this.urlKey.trim())) && this.name != null) {
            return UrlUtil.generateUrlKey((String)this.name);
        }
        return this.urlKey;
    }

    @Override
    public String getGeneratedUrl() {
        return CategoryImpl.buildLink(this, false);
    }

    @Override
    public void setUrlKey(String urlKey) {
        this.urlKey = urlKey;
    }

    @Override
    public String getDescription() {
        return DynamicTranslationProvider.getValue((Object)this, (String)"description", (String)this.description);
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Date getActiveStartDate() {
        if ('Y' == this.getArchived().charValue()) {
            return null;
        }
        return this.activeStartDate;
    }

    @Override
    public void setActiveStartDate(Date activeStartDate) {
        this.activeStartDate = activeStartDate == null ? null : new Date(activeStartDate.getTime());
    }

    @Override
    public Date getActiveEndDate() {
        return this.activeEndDate;
    }

    @Override
    public void setActiveEndDate(Date activeEndDate) {
        this.activeEndDate = activeEndDate == null ? null : new Date(activeEndDate.getTime());
    }

    @Override
    public boolean isActive() {
        if (LOG.isDebugEnabled()) {
            if (!DateUtil.isActive((Date)this.activeStartDate, (Date)this.activeEndDate, (boolean)true)) {
                LOG.debug((Object)("category, " + this.id + ", inactive due to date"));
            }
            if ('Y' == this.getArchived().charValue()) {
                LOG.debug((Object)("category, " + this.id + ", inactive due to archived status"));
            }
        }
        return DateUtil.isActive((Date)this.activeStartDate, (Date)this.activeEndDate, (boolean)true) && 'Y' != this.getArchived().charValue();
    }

    @Override
    public String getDisplayTemplate() {
        return this.displayTemplate;
    }

    @Override
    public void setDisplayTemplate(String displayTemplate) {
        this.displayTemplate = displayTemplate;
    }

    @Override
    public String getLongDescription() {
        return DynamicTranslationProvider.getValue((Object)this, (String)"longDescription", (String)this.longDescription);
    }

    @Override
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Override
    public Category getDefaultParentCategory() {
        return this.defaultParentCategory;
    }

    @Override
    public void setDefaultParentCategory(Category defaultParentCategory) {
        this.defaultParentCategory = defaultParentCategory;
    }

    @Override
    public List<CategoryXref> getAllChildCategoryXrefs() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).getAllChildCategoryXrefs(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        return this.allChildCategoryXrefs;
    }

    @Override
    public List<CategoryXref> getChildCategoryXrefs() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).getChildCategoryXrefs(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        if (this.childCategoryXrefs.isEmpty()) {
            for (CategoryXref category : this.allChildCategoryXrefs) {
                if (!category.getSubCategory().isActive()) continue;
                this.childCategoryXrefs.add(category);
            }
        }
        return Collections.unmodifiableList(this.childCategoryXrefs);
    }

    @Override
    public void setChildCategoryXrefs(List<CategoryXref> childCategories) {
        this.childCategoryXrefs.clear();
        for (CategoryXref category : childCategories) {
            this.childCategoryXrefs.add(category);
        }
    }

    @Override
    public void setAllChildCategoryXrefs(List<CategoryXref> childCategories) {
        this.allChildCategoryXrefs.clear();
        for (CategoryXref category : childCategories) {
            this.allChildCategoryXrefs.add(category);
        }
    }

    @Override
    @Deprecated
    public List<Category> getAllChildCategories() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).getAllChildCategories(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        if (this.allLegacyChildCategories.isEmpty()) {
            for (CategoryXref category : this.allChildCategoryXrefs) {
                this.allLegacyChildCategories.add(category.getSubCategory());
            }
        }
        return Collections.unmodifiableList(this.allLegacyChildCategories);
    }

    @Override
    public boolean hasAllChildCategories() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).hasAllChildCategories(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (Boolean)holder.getResult();
            }
        }
        return !this.allChildCategoryXrefs.isEmpty();
    }

    @Override
    @Deprecated
    public void setAllChildCategories(List<Category> childCategories) {
        throw new UnsupportedOperationException("Not Supported - Use setAllChildCategoryXrefs()");
    }

    @Override
    @Deprecated
    public List<Category> getChildCategories() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).getChildCategories(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        if (this.legacyChildCategories.isEmpty()) {
            for (CategoryXref category : this.allChildCategoryXrefs) {
                if (!category.getSubCategory().isActive()) continue;
                this.legacyChildCategories.add(category.getSubCategory());
            }
        }
        return Collections.unmodifiableList(this.legacyChildCategories);
    }

    @Override
    public boolean hasChildCategories() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).hasChildCategories(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (Boolean)holder.getResult();
            }
        }
        return !this.getChildCategoryXrefs().isEmpty();
    }

    @Override
    @Deprecated
    public void setChildCategories(List<Category> childCategories) {
        throw new UnsupportedOperationException("Not Supported - Use setChildCategoryXrefs()");
    }

    @Override
    public List<Long> getChildCategoryIds() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).getChildCategoryIds(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        if (this.childCategoryIds == null) {
            HydratedSetup.populateFromCache((Object)this, (String)"childCategoryIds");
        }
        return this.childCategoryIds;
    }

    @Override
    public void setChildCategoryIds(List<Long> childCategoryIds) {
        this.childCategoryIds = childCategoryIds;
    }

    public List<Long> createChildCategoryIds() {
        this.childCategoryIds = new ArrayList<Long>();
        for (CategoryXref category : this.allChildCategoryXrefs) {
            if (!category.getSubCategory().isActive()) continue;
            this.childCategoryIds.add(category.getSubCategory().getId());
        }
        return this.childCategoryIds;
    }

    @Override
    @Deprecated
    public Map<String, String> getCategoryImages() {
        return this.categoryImages;
    }

    @Override
    @Deprecated
    public String getCategoryImage(String imageKey) {
        return this.categoryImages.get(imageKey);
    }

    @Override
    @Deprecated
    public void setCategoryImages(Map<String, String> categoryImages) {
        this.categoryImages.clear();
        for (Map.Entry<String, String> me : categoryImages.entrySet()) {
            this.categoryImages.put(me.getKey(), me.getValue());
        }
    }

    @Override
    @Deprecated
    public Map<String, List<Long>> getChildCategoryURLMap() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).getChildCategoryURLMap(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (Map)holder.getResult();
            }
        }
        if (this.childCategoryURLMap == null) {
            this.createChildCategoryURLMap();
        }
        return this.childCategoryURLMap;
    }

    public Map<String, List<Long>> createChildCategoryURLMap() {
        try {
            HashMap<String, List<Long>> newMap = new HashMap<String, List<Long>>(50);
            CategoryImpl.fillInURLMapForCategory(newMap, this, "", new ArrayList<Long>(10));
            return newMap;
        }
        catch (CacheFactoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public void setChildCategoryURLMap(Map<String, List<Long>> childCategoryURLMap) {
        this.childCategoryURLMap = childCategoryURLMap;
    }

    @Override
    public List<Category> buildFullCategoryHierarchy(List<Category> currentHierarchy) {
        if (currentHierarchy == null) {
            currentHierarchy = new ArrayList<Category>();
            currentHierarchy.add(this);
        }
        ArrayList<Category> myParentCategories = new ArrayList<Category>();
        if (this.getDefaultParentCategory() != null) {
            myParentCategories.add(this.getDefaultParentCategory());
        }
        if (!CollectionUtils.isEmpty(this.getAllParentCategoryXrefs())) {
            for (CategoryXref parent : this.getAllParentCategoryXrefs()) {
                myParentCategories.add(parent.getCategory());
            }
        }
        for (Category category : myParentCategories) {
            if (currentHierarchy.contains(category)) continue;
            currentHierarchy.add(category);
            category.buildFullCategoryHierarchy(currentHierarchy);
        }
        return currentHierarchy;
    }

    @Override
    public List<Category> buildCategoryHierarchy(List<Category> currentHierarchy) {
        if (currentHierarchy == null) {
            currentHierarchy = new ArrayList<Category>();
            currentHierarchy.add(this);
        }
        if (this.getDefaultParentCategory() != null && !currentHierarchy.contains(this.getDefaultParentCategory())) {
            currentHierarchy.add(this.getDefaultParentCategory());
            this.getDefaultParentCategory().buildCategoryHierarchy(currentHierarchy);
        }
        return currentHierarchy;
    }

    @Override
    public List<CategoryXref> getAllParentCategoryXrefs() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).getAllParentCategoryXrefs(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        return this.allParentCategoryXrefs;
    }

    @Override
    public void setAllParentCategoryXrefs(List<CategoryXref> allParentCategories) {
        this.allParentCategoryXrefs.clear();
        this.allParentCategoryXrefs.addAll(allParentCategories);
    }

    @Override
    @Deprecated
    public List<Category> getAllParentCategories() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).getAllParentCategories(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        ArrayList<Category> parents = new ArrayList<Category>(this.allParentCategoryXrefs.size());
        for (CategoryXref xref : this.allParentCategoryXrefs) {
            parents.add(xref.getCategory());
        }
        return Collections.unmodifiableList(parents);
    }

    @Override
    @Deprecated
    public void setAllParentCategories(List<Category> allParentCategories) {
        throw new UnsupportedOperationException("Not Supported - Use setAllParentCategoryXrefs()");
    }

    @Override
    public List<FeaturedProduct> getFeaturedProducts() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).getFeaturedProducts(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        return this.featuredProducts;
    }

    @Override
    public void setFeaturedProducts(List<FeaturedProduct> featuredProducts) {
        this.featuredProducts.clear();
        for (FeaturedProduct featuredProduct : featuredProducts) {
            this.featuredProducts.add(featuredProduct);
        }
    }

    @Override
    public List<RelatedProduct> getCrossSaleProducts() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).getCrossSaleProducts(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        return this.crossSaleProducts;
    }

    @Override
    public void setCrossSaleProducts(List<RelatedProduct> crossSaleProducts) {
        this.crossSaleProducts.clear();
        for (RelatedProduct relatedProduct : crossSaleProducts) {
            this.crossSaleProducts.add(relatedProduct);
        }
    }

    @Override
    public List<RelatedProduct> getUpSaleProducts() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).getUpSaleProducts(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        return this.upSaleProducts;
    }

    @Override
    public List<RelatedProduct> getCumulativeCrossSaleProducts() {
        LinkedHashSet<RelatedProduct> returnProductsSet = new LinkedHashSet<RelatedProduct>();
        List<Category> categoryHierarchy = this.buildCategoryHierarchy(null);
        for (Category category : categoryHierarchy) {
            returnProductsSet.addAll(category.getCrossSaleProducts());
        }
        return new ArrayList<RelatedProduct>(returnProductsSet);
    }

    @Override
    public List<RelatedProduct> getCumulativeUpSaleProducts() {
        LinkedHashSet<RelatedProduct> returnProductsSet = new LinkedHashSet<RelatedProduct>();
        List<Category> categoryHierarchy = this.buildCategoryHierarchy(null);
        for (Category category : categoryHierarchy) {
            returnProductsSet.addAll(category.getUpSaleProducts());
        }
        return new ArrayList<RelatedProduct>(returnProductsSet);
    }

    @Override
    public List<FeaturedProduct> getCumulativeFeaturedProducts() {
        LinkedHashSet<FeaturedProduct> returnProductsSet = new LinkedHashSet<FeaturedProduct>();
        List<Category> categoryHierarchy = this.buildCategoryHierarchy(null);
        for (Category category : categoryHierarchy) {
            returnProductsSet.addAll(category.getFeaturedProducts());
        }
        return new ArrayList<FeaturedProduct>(returnProductsSet);
    }

    @Override
    public void setUpSaleProducts(List<RelatedProduct> upSaleProducts) {
        this.upSaleProducts.clear();
        for (RelatedProduct relatedProduct : upSaleProducts) {
            this.upSaleProducts.add(relatedProduct);
        }
        this.upSaleProducts = upSaleProducts;
    }

    @Override
    public List<CategoryProductXref> getActiveProductXrefs() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).getActiveProductXrefs(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        ArrayList<CategoryProductXref> result = new ArrayList<CategoryProductXref>();
        for (CategoryProductXref product : this.allProductXrefs) {
            if (!product.getProduct().isActive()) continue;
            result.add(product);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<CategoryProductXref> getAllProductXrefs() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).getAllProductXrefs(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        return this.allProductXrefs;
    }

    @Override
    public void setAllProductXrefs(List<CategoryProductXref> allProducts) {
        this.allProductXrefs.clear();
        this.allProductXrefs.addAll(allProducts);
    }

    @Override
    @Deprecated
    public List<Product> getActiveProducts() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).getActiveProducts(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        ArrayList<Product> result = new ArrayList<Product>();
        for (CategoryProductXref product : this.allProductXrefs) {
            if (!product.getProduct().isActive()) continue;
            result.add(product.getProduct());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    @Deprecated
    public List<Product> getAllProducts() {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getAdditionalProperties().containsKey("blCategoryEntityExtensionManager")) {
            CategoryEntityExtensionManager extensionManager = (CategoryEntityExtensionManager)((Object)context.getAdditionalProperties().get("blCategoryEntityExtensionManager"));
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryEntityExtensionHandler)extensionManager.getProxy()).getAllProducts(this, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        ArrayList<Product> result = new ArrayList<Product>();
        for (CategoryProductXref product : this.allProductXrefs) {
            result.add(product.getProduct());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    @Deprecated
    public void setAllProducts(List<Product> allProducts) {
        throw new UnsupportedOperationException("Not Supported - Use setAllProductXrefs()");
    }

    @Override
    public List<CategorySearchFacet> getSearchFacets() {
        return this.searchFacets;
    }

    @Override
    public void setSearchFacets(List<CategorySearchFacet> searchFacets) {
        this.searchFacets = searchFacets;
    }

    @Override
    public List<SearchFacet> getExcludedSearchFacets() {
        return this.excludedSearchFacets;
    }

    @Override
    public void setExcludedSearchFacets(List<SearchFacet> excludedSearchFacets) {
        this.excludedSearchFacets = excludedSearchFacets;
    }

    @Override
    public InventoryType getInventoryType() {
        return InventoryType.getInstance(this.inventoryType);
    }

    @Override
    public void setInventoryType(InventoryType inventoryType) {
        this.inventoryType = inventoryType.getType();
    }

    @Override
    public FulfillmentType getFulfillmentType() {
        return FulfillmentType.getInstance(this.fulfillmentType);
    }

    @Override
    public void setFulfillmentType(FulfillmentType fulfillmentType) {
        this.fulfillmentType = fulfillmentType.getType();
    }

    @Override
    public List<CategorySearchFacet> getCumulativeSearchFacets() {
        final ArrayList<CategorySearchFacet> returnFacets = new ArrayList<CategorySearchFacet>();
        returnFacets.addAll(this.getSearchFacets());
        Collections.sort(returnFacets, facetPositionComparator);
        List<CategorySearchFacet> parentFacets = null;
        if (this.defaultParentCategory != null) {
            parentFacets = this.defaultParentCategory.getCumulativeSearchFacets();
            CollectionUtils.filter(parentFacets, (Predicate)new Predicate(){

                public boolean evaluate(Object arg) {
                    CategorySearchFacet csf = (CategorySearchFacet)arg;
                    return !CategoryImpl.this.getExcludedSearchFacets().contains(csf.getSearchFacet()) && !returnFacets.contains(csf.getSearchFacet());
                }
            });
        }
        if (parentFacets != null) {
            returnFacets.addAll(parentFacets);
        }
        return returnFacets;
    }

    @Override
    public Map<String, Media> getCategoryMedia() {
        return this.categoryMedia;
    }

    @Override
    public void setCategoryMedia(Map<String, Media> categoryMedia) {
        this.categoryMedia.clear();
        for (Map.Entry<String, Media> me : categoryMedia.entrySet()) {
            this.categoryMedia.put(me.getKey(), me.getValue());
        }
    }

    @Override
    public Map<String, CategoryAttribute> getCategoryAttributesMap() {
        return this.categoryAttributes;
    }

    @Override
    public void setCategoryAttributesMap(Map<String, CategoryAttribute> categoryAttributes) {
        this.categoryAttributes = categoryAttributes;
    }

    @Override
    public List<CategoryAttribute> getCategoryAttributes() {
        ArrayList<CategoryAttribute> ca = new ArrayList<CategoryAttribute>(this.categoryAttributes.values());
        return Collections.unmodifiableList(ca);
    }

    @Override
    public void setCategoryAttributes(List<CategoryAttribute> categoryAttributes) {
        this.categoryAttributes = new HashMap<String, CategoryAttribute>();
        for (CategoryAttribute categoryAttribute : categoryAttributes) {
            this.categoryAttributes.put(categoryAttribute.getName(), categoryAttribute);
        }
    }

    @Override
    public CategoryAttribute getCategoryAttributeByName(String name) {
        for (CategoryAttribute attribute : this.getCategoryAttributes()) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public Map<String, CategoryAttribute> getMappedCategoryAttributes() {
        HashMap<String, CategoryAttribute> map = new HashMap<String, CategoryAttribute>();
        for (CategoryAttribute attr : this.getCategoryAttributes()) {
            map.put(attr.getName(), attr);
        }
        return map;
    }

    public Character getArchived() {
        if (this.archiveStatus == null) {
            this.archiveStatus = new ArchiveStatus();
        }
        return this.archiveStatus.getArchived();
    }

    public void setArchived(Character archived) {
        if (this.archiveStatus == null) {
            this.archiveStatus = new ArchiveStatus();
        }
        this.archiveStatus.setArchived(archived);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.name == null ? 0 : this.name.hashCode());
        result = prime * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoryImpl other = (CategoryImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String getMainEntityName() {
        return this.getName();
    }

    @Override
    public String getTaxCode() {
        return this.taxCode;
    }

    @Override
    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public String getLocation() {
        return this.getUrl();
    }

    public static class Presentation {

        public static class Group {

            public static class Order {
                public static final int General = 1000;
                public static final int ActiveDateRange = 2000;
                public static final int Advanced = 1000;
            }

            public static class Name {
                public static final String General = "CategoryImpl_Category_Description";
                public static final String ActiveDateRange = "CategoryImpl_Active_Date_Range";
                public static final String Advanced = "CategoryImpl_Advanced";
            }
        }

        public static class Tab {

            public static class Order {
                public static final int Marketing = 2000;
                public static final int Media = 3000;
                public static final int Advanced = 4000;
                public static final int Products = 5000;
                public static final int SearchFacets = 3500;
            }

            public static class Name {
                public static final String Marketing = "CategoryImpl_Marketing_Tab";
                public static final String Media = "CategoryImpl_Media_Tab";
                public static final String Advanced = "CategoryImpl_Advanced_Tab";
                public static final String Products = "CategoryImpl_Products_Tab";
                public static final String SearchFacets = "CategoryImpl_categoryFacetsTab";
            }
        }
    }
}

