/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.rating.service.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RatingSortType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, RatingSortType> TYPES = new HashMap<String, RatingSortType>();
    public static final RatingSortType MOST_HELPFUL = new RatingSortType("MOST_HELPFUL");
    public static final RatingSortType MOST_RECENT = new RatingSortType("MOST_RECENT");
    public static final RatingSortType DEFAULT = new RatingSortType("DEFAULT");
    private String type;

    public static RatingSortType getInstance(String type) {
        return TYPES.get(type);
    }

    public RatingSortType() {
    }

    public RatingSortType(String type) {
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RatingSortType)) {
            return false;
        }
        RatingSortType other = (RatingSortType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

