/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.workflow;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class FulfillmentItemPricingActivity
extends BaseActivity<ProcessContext<Order>> {
    private static final Log LOG = LogFactory.getLog(FulfillmentItemPricingActivity.class);

    protected BroadleafCurrency getCurrency(FulfillmentGroup fg) {
        return fg.getOrder().getCurrency();
    }

    protected Money getOrderSavingsToDistribute(Order order) {
        if (order.getOrderAdjustmentsValue() == null) {
            return new Money(order.getCurrency());
        }
        Money adjustmentValue = order.getOrderAdjustmentsValue();
        Money orderSubTotal = order.getSubTotal();
        if (orderSubTotal == null || orderSubTotal.lessThan(adjustmentValue)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Subtotal is null or less than orderSavings in DistributeOrderSavingsActivity.java.  No distribution is taking place.");
            }
            return new Money(order.getCurrency());
        }
        return adjustmentValue;
    }

    @Override
    public ProcessContext<Order> execute(ProcessContext<Order> context) throws Exception {
        Order order = context.getSeedData();
        HashMap<OrderItem, List<FulfillmentGroupItem>> partialOrderItemMap = new HashMap<OrderItem, List<FulfillmentGroupItem>>();
        this.populateItemTotalAmount(order, partialOrderItemMap);
        this.fixItemTotalRoundingIssues(order, partialOrderItemMap);
        Money totalAllItemsAmount = this.calculateTotalPriceForAllFulfillmentItems(order);
        Money totalOrderAdjustmentDistributed = this.distributeOrderSavingsToItems(order, totalAllItemsAmount.getAmount());
        this.fixOrderSavingsRoundingIssues(order, totalOrderAdjustmentDistributed);
        this.updateTaxableAmountsOnItems(order);
        context.setSeedData(order);
        return context;
    }

    protected void populateItemTotalAmount(Order order, Map<OrderItem, List<FulfillmentGroupItem>> partialOrderItemMap) {
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            for (FulfillmentGroupItem fgItem : fulfillmentGroup.getFulfillmentGroupItems()) {
                OrderItem orderItem = fgItem.getOrderItem();
                int fgItemQty = fgItem.getQuantity();
                int orderItemQty = orderItem.getQuantity();
                Money totalItemAmount = orderItem.getTotalPrice();
                if (fgItemQty != orderItemQty) {
                    List<FulfillmentGroupItem> fgItemList = partialOrderItemMap.get(orderItem);
                    if (fgItemList == null) {
                        fgItemList = new ArrayList<FulfillmentGroupItem>();
                        partialOrderItemMap.put(orderItem, fgItemList);
                    }
                    fgItemList.add(fgItem);
                    fgItem.setTotalItemAmount(totalItemAmount.multiply(fgItemQty).divide(orderItemQty));
                    continue;
                }
                fgItem.setTotalItemAmount(totalItemAmount);
            }
        }
    }

    protected void fixItemTotalRoundingIssues(Order order, Map<OrderItem, List<FulfillmentGroupItem>> partialOrderItemMap) {
        for (OrderItem orderItem : partialOrderItemMap.keySet()) {
            Money totalFGItemAmount;
            Money totalItemAmount = orderItem.getTotalPrice();
            Money amountDiff = totalItemAmount.subtract(totalFGItemAmount = this.sumItemAmount(partialOrderItemMap.get(orderItem), order));
            if (amountDiff.getAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            long numApplicationsNeeded = this.countNumberOfUnits(amountDiff);
            Money unitAmount = this.getUnitAmount(amountDiff);
            for (FulfillmentGroupItem fgItem : partialOrderItemMap.get(orderItem)) {
                if ((numApplicationsNeeded -= this.applyDifferenceToAmount(fgItem, numApplicationsNeeded, unitAmount)) == 0L) break;
            }
        }
    }

    protected Money calculateTotalPriceForAllFulfillmentItems(Order order) {
        Money totalAllItemsAmount = new Money(order.getCurrency());
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            for (FulfillmentGroupItem fgItem : fulfillmentGroup.getFulfillmentGroupItems()) {
                totalAllItemsAmount = totalAllItemsAmount.add(fgItem.getTotalItemAmount());
            }
        }
        return totalAllItemsAmount;
    }

    protected Money distributeOrderSavingsToItems(Order order, BigDecimal totalAllItems) {
        Money returnAmount = new Money(order.getCurrency());
        BigDecimal orderAdjAmt = order.getOrderAdjustmentsValue().getAmount();
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            for (FulfillmentGroupItem fgItem : fulfillmentGroup.getFulfillmentGroupItems()) {
                BigDecimal fgItemAmount = fgItem.getTotalItemAmount().getAmount();
                BigDecimal proratedAdjAmt = totalAllItems.compareTo(BigDecimal.ZERO) == 0 ? totalAllItems : orderAdjAmt.multiply(fgItemAmount).divide(totalAllItems, RoundingMode.FLOOR);
                fgItem.setProratedOrderAdjustmentAmount(new Money(proratedAdjAmt, order.getCurrency()));
                returnAmount = returnAmount.add(fgItem.getProratedOrderAdjustmentAmount());
            }
        }
        return returnAmount;
    }

    protected void fixOrderSavingsRoundingIssues(Order order, Money totalOrderAdjustmentDistributed) {
        if (!order.getHasOrderAdjustments()) {
            return;
        }
        Money orderAdjustmentTotal = order.getOrderAdjustmentsValue();
        Money amountDiff = totalOrderAdjustmentDistributed.subtract(orderAdjustmentTotal);
        if (amountDiff.getAmount().compareTo(BigDecimal.ZERO) != 0) {
            long numApplicationsNeeded = this.countNumberOfUnits(amountDiff);
            Money unitAmount = this.getUnitAmount(amountDiff);
            for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
                for (FulfillmentGroupItem fgItem : fulfillmentGroup.getFulfillmentGroupItems()) {
                    if ((numApplicationsNeeded -= this.applyDifferenceToProratedAdj(fgItem, numApplicationsNeeded, unitAmount)) == 0L) break;
                }
            }
        }
    }

    protected void updateTaxableAmountsOnItems(Order order) {
        Money zero = new Money(order.getCurrency());
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            for (FulfillmentGroupItem fgItem : fulfillmentGroup.getFulfillmentGroupItems()) {
                if (fgItem.getOrderItem().isTaxable().booleanValue()) {
                    Money proratedOrderAdjAmt = fgItem.getProratedOrderAdjustmentAmount();
                    if (proratedOrderAdjAmt != null) {
                        fgItem.setTotalItemTaxableAmount(fgItem.getTotalItemAmount().subtract(proratedOrderAdjAmt));
                        continue;
                    }
                    fgItem.setTotalItemTaxableAmount(fgItem.getTotalItemAmount());
                    continue;
                }
                fgItem.setTotalItemTaxableAmount(zero);
            }
        }
    }

    protected Money sumItemAmount(List<FulfillmentGroupItem> items, Order order) {
        Money totalAmount = new Money(order.getCurrency());
        for (FulfillmentGroupItem fgItem : items) {
            totalAmount = totalAmount.add(fgItem.getTotalItemAmount());
        }
        return totalAmount;
    }

    protected Money sumTaxAmount(List<FulfillmentGroupItem> items, Order order) {
        Money taxAmount = new Money(order.getCurrency());
        for (FulfillmentGroupItem fgItem : items) {
            taxAmount = taxAmount.add(fgItem.getTotalItemTaxableAmount());
        }
        return taxAmount;
    }

    public long countNumberOfUnits(Money difference) {
        double numUnits = difference.multiply(Math.pow(10.0, difference.getCurrency().getDefaultFractionDigits())).doubleValue();
        return Math.round(numUnits);
    }

    public Money getUnitAmount(Money difference) {
        Currency currency = difference.getCurrency();
        BigDecimal divisor = new BigDecimal(Math.pow(10.0, currency.getDefaultFractionDigits()));
        BigDecimal unitAmount = new BigDecimal("1").divide(divisor);
        if (difference.lessThan(BigDecimal.ZERO)) {
            unitAmount = unitAmount.negate();
        }
        return new Money(unitAmount, currency);
    }

    public long applyDifferenceToAmount(FulfillmentGroupItem fgItem, long numApplicationsNeeded, Money unitAmount) {
        BigDecimal numTimesToApply = new BigDecimal(Math.min(numApplicationsNeeded, (long)fgItem.getQuantity()));
        Money oldAmount = fgItem.getTotalItemAmount();
        Money changeToAmount = unitAmount.multiply(numTimesToApply);
        fgItem.setTotalItemAmount(oldAmount.add(changeToAmount));
        return numTimesToApply.longValue();
    }

    public long applyDifferenceToProratedAdj(FulfillmentGroupItem fgItem, long numApplicationsNeeded, Money unitAmount) {
        BigDecimal numTimesToApply = new BigDecimal(Math.min(numApplicationsNeeded, (long)fgItem.getQuantity()));
        Money oldAmount = fgItem.getProratedOrderAdjustmentAmount();
        Money changeToAmount = unitAmount.multiply(numTimesToApply);
        fgItem.setProratedOrderAdjustmentAmount(oldAmount.add(changeToAmount));
        return numTimesToApply.longValue();
    }

    public long applyTaxDifference(FulfillmentGroupItem fgItem, long numApplicationsNeeded, Money unitAmount) {
        BigDecimal numTimesToApply = new BigDecimal(Math.min(numApplicationsNeeded, (long)fgItem.getQuantity()));
        Money oldAmount = fgItem.getTotalItemTaxableAmount();
        Money changeToAmount = unitAmount.multiply(numTimesToApply);
        fgItem.setTotalItemTaxableAmount(oldAmount.add(changeToAmount));
        return numTimesToApply.longValue();
    }
}

