/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service.workflow;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class PaymentActionType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, PaymentActionType> TYPES = new LinkedHashMap<String, PaymentActionType>();
    public static final PaymentActionType AUTHORIZE = new PaymentActionType("AUTHORIZE", "Authorize");
    public static final PaymentActionType DEBIT = new PaymentActionType("DEBIT", "Debit");
    public static final PaymentActionType AUTHORIZEANDDEBIT = new PaymentActionType("AUTHORIZEANDDEBIT", "Authorize and Debit");
    public static final PaymentActionType CREDIT = new PaymentActionType("CREDIT", "Credit");
    public static final PaymentActionType VOID = new PaymentActionType("VOID", "Void");
    public static final PaymentActionType BALANCE = new PaymentActionType("BALANCE", "Check Balance");
    public static final PaymentActionType REVERSEAUTHORIZE = new PaymentActionType("REVERSEAUTHORIZE", "Reverse Authorize");
    public static final PaymentActionType PARTIALPAYMENT = new PaymentActionType("PARTIALPAYMENT", "Partial Payment");
    private String type;
    private String friendlyType;

    public static PaymentActionType getInstance(String type) {
        return TYPES.get(type);
    }

    public PaymentActionType() {
    }

    public PaymentActionType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentActionType)) {
            return false;
        }
        PaymentActionType other = (PaymentActionType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

