/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service.type;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class PaymentInfoType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, PaymentInfoType> TYPES = new LinkedHashMap<String, PaymentInfoType>();
    public static final PaymentInfoType GIFT_CARD = new PaymentInfoType("GIFT_CARD", "Gift Card");
    public static final PaymentInfoType CREDIT_CARD = new PaymentInfoType("CREDIT_CARD", "Credit Card");
    public static final PaymentInfoType BANK_ACCOUNT = new PaymentInfoType("BANK_ACCOUNT", "Bank Account");
    public static final PaymentInfoType PAYPAL = new PaymentInfoType("PAYPAL", "PayPal");
    public static final PaymentInfoType CHECK = new PaymentInfoType("CHECK", "Check");
    public static final PaymentInfoType ELECTRONIC_CHECK = new PaymentInfoType("ELECTRONIC_CHECK", "Electronic Check");
    public static final PaymentInfoType WIRE = new PaymentInfoType("WIRE", "Wire Transfer");
    public static final PaymentInfoType MONEY_ORDER = new PaymentInfoType("MONEY_ORDER", "Money Order");
    public static final PaymentInfoType CUSTOMER_CREDIT = new PaymentInfoType("CUSTOMER_CREDIT", "Customer Credit");
    public static final PaymentInfoType COD = new PaymentInfoType("COD", "Collect On Delivery");
    @Deprecated
    public static final PaymentInfoType ACCOUNT = new PaymentInfoType("ACCOUNT", "Account");
    private String type;
    private String friendlyType;

    public static PaymentInfoType getInstance(String type) {
        return TYPES.get(type);
    }

    public PaymentInfoType() {
    }

    public PaymentInfoType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentInfoType)) {
            return false;
        }
        PaymentInfoType other = (PaymentInfoType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

