/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service;

import javax.annotation.Resource;
import org.broadleafcommerce.core.payment.dao.SecurePaymentInfoDao;
import org.broadleafcommerce.core.payment.domain.BankAccountPaymentInfo;
import org.broadleafcommerce.core.payment.domain.CreditCardPaymentInfo;
import org.broadleafcommerce.core.payment.domain.GiftCardPaymentInfo;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.payment.service.SecurePaymentInfoService;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.core.workflow.WorkflowException;
import org.springframework.stereotype.Service;

@Service(value="blSecurePaymentInfoService")
public class SecurePaymentInfoServiceImpl
implements SecurePaymentInfoService {
    @Resource(name="blSecurePaymentInfoDao")
    protected SecurePaymentInfoDao securePaymentInfoDao;

    @Override
    public Referenced save(Referenced securePaymentInfo) {
        return this.securePaymentInfoDao.save(securePaymentInfo);
    }

    @Override
    public Referenced create(PaymentInfoType paymentInfoType) {
        if (paymentInfoType.equals(PaymentInfoType.CREDIT_CARD)) {
            CreditCardPaymentInfo ccinfo = this.securePaymentInfoDao.createCreditCardPaymentInfo();
            return ccinfo;
        }
        if (paymentInfoType.equals(PaymentInfoType.BANK_ACCOUNT)) {
            BankAccountPaymentInfo bankinfo = this.securePaymentInfoDao.createBankAccountPaymentInfo();
            return bankinfo;
        }
        if (paymentInfoType.equals(PaymentInfoType.GIFT_CARD)) {
            GiftCardPaymentInfo gcinfo = this.securePaymentInfoDao.createGiftCardPaymentInfo();
            return gcinfo;
        }
        return null;
    }

    @Override
    public Referenced findSecurePaymentInfo(String referenceNumber, PaymentInfoType paymentInfoType) throws WorkflowException {
        if (paymentInfoType == PaymentInfoType.CREDIT_CARD) {
            CreditCardPaymentInfo ccinfo = this.findCreditCardInfo(referenceNumber);
            if (ccinfo == null) {
                throw new WorkflowException("No credit card info associated with credit card payment type with reference number: " + referenceNumber);
            }
            return ccinfo;
        }
        if (paymentInfoType == PaymentInfoType.BANK_ACCOUNT) {
            BankAccountPaymentInfo bankinfo = this.findBankAccountInfo(referenceNumber);
            if (bankinfo == null) {
                throw new WorkflowException("No bank account info associated with bank account payment type with reference number: " + referenceNumber);
            }
            return bankinfo;
        }
        if (paymentInfoType == PaymentInfoType.GIFT_CARD) {
            GiftCardPaymentInfo gcinfo = this.findGiftCardInfo(referenceNumber);
            if (gcinfo == null) {
                throw new WorkflowException("No bank account info associated with gift card payment type with reference number: " + referenceNumber);
            }
            return gcinfo;
        }
        return null;
    }

    @Override
    public void findAndRemoveSecurePaymentInfo(String referenceNumber, PaymentInfoType paymentInfoType) throws WorkflowException {
        Referenced referenced = this.findSecurePaymentInfo(referenceNumber, paymentInfoType);
        if (referenced != null) {
            this.remove(referenced);
        }
    }

    @Override
    public void remove(Referenced securePaymentInfo) {
        this.securePaymentInfoDao.delete(securePaymentInfo);
    }

    protected BankAccountPaymentInfo findBankAccountInfo(String referenceNumber) {
        return this.securePaymentInfoDao.findBankAccountInfo(referenceNumber);
    }

    protected CreditCardPaymentInfo findCreditCardInfo(String referenceNumber) {
        return this.securePaymentInfoDao.findCreditCardInfo(referenceNumber);
    }

    protected GiftCardPaymentInfo findGiftCardInfo(String referenceNumber) {
        return this.securePaymentInfoDao.findGiftCardInfo(referenceNumber);
    }
}

