/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.broadleafcommerce.common.encryption.EncryptionModule;
import org.broadleafcommerce.core.payment.domain.GiftCardPaymentInfo;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_GIFT_CARD_PAYMENT")
public class GiftCardPaymentInfoImpl
implements GiftCardPaymentInfo {
    private static final long serialVersionUID = 1L;
    @Transient
    protected EncryptionModule encryptionModule;
    @Id
    @GeneratedValue(generator="GiftCardPaymentId")
    @GenericGenerator(name="GiftCardPaymentId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="GiftCardPaymentInfoImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.payment.domain.GiftCardPaymentInfoImpl")})
    @Column(name="PAYMENT_ID")
    protected Long id;
    @Column(name="REFERENCE_NUMBER", nullable=false)
    @Index(name="GIFTCARD_INDEX", columnNames={"REFERENCE_NUMBER"})
    protected String referenceNumber;
    @Column(name="PAN", nullable=false)
    protected String pan;
    @Column(name="PIN")
    protected String pin;

    protected GiftCardPaymentInfoImpl() {
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getPan() {
        return this.encryptionModule.decrypt(this.pan);
    }

    @Override
    public String getPin() {
        return this.encryptionModule.decrypt(this.pin);
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setPan(String pan) {
        this.pan = this.encryptionModule.encrypt(pan);
    }

    @Override
    public void setPin(String pin) {
        this.pin = this.encryptionModule.encrypt(pin);
    }

    @Override
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    @Override
    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    @Override
    public EncryptionModule getEncryptionModule() {
        return this.encryptionModule;
    }

    @Override
    public void setEncryptionModule(EncryptionModule encryptionModule) {
        this.encryptionModule = encryptionModule;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pan == null ? 0 : this.pan.hashCode());
        result = 31 * result + (this.pin == null ? 0 : this.pin.hashCode());
        result = 31 * result + (this.referenceNumber == null ? 0 : this.referenceNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GiftCardPaymentInfoImpl)) {
            return false;
        }
        GiftCardPaymentInfoImpl other = (GiftCardPaymentInfoImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.pan == null ? other.pan != null : !this.pan.equals(other.pan)) {
            return false;
        }
        if (this.pin == null ? other.pin != null : !this.pin.equals(other.pin)) {
            return false;
        }
        return !(this.referenceNumber == null ? other.referenceNumber != null : !this.referenceNumber.equals(other.referenceNumber));
    }
}

