/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.currency.util.CurrencyCodeIdentifiable;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.core.payment.domain.AmountItem;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfoImpl;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_AMOUNT_ITEM")
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="", mergeEntries={@AdminPresentationMergeEntry(propertyType="readOnly", booleanOverrideValue=true)})})
public class AmountItemImpl
implements AmountItem,
CurrencyCodeIdentifiable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="AmountItemId")
    @GenericGenerator(name="AmountItemId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="AmountItemImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.payment.domain.AmountItemImpl")})
    @Column(name="AMOUNT_ITEM_ID")
    protected Long id;
    @Column(name="SHORT_DESCRIPTION", nullable=true)
    @Index(name="SHORT_DESCRIPTION_INDEX", columnNames={"SHORT_DESCRIPTION"})
    @AdminPresentation(friendlyName="AmountItemImpl_Short_Description", order=1000, prominent=true, gridOrder=1000)
    protected String shortDescription;
    @Column(name="DESCRIPTION")
    @AdminPresentation(friendlyName="AmountItemImpl_Description", order=2000)
    protected String description;
    @Column(name="UNIT_PRICE", nullable=false, precision=19, scale=5)
    @AdminPresentation(friendlyName="AmountItemImpl_Unit_Price", order=3000, gridOrder=2000, prominent=true, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal unitPrice;
    @Column(name="QUANTITY", nullable=false)
    @AdminPresentation(friendlyName="AmountItemImpl_Quantity", order=4000, prominent=true, gridOrder=3000)
    protected Long quantity;
    @Column(name="SYSTEM_ID")
    @AdminPresentation(friendlyName="AmountItemImpl_SystemId", order=5000)
    protected String systemId;
    @ManyToOne(targetEntity=PaymentInfoImpl.class, optional=true)
    @JoinColumn(name="PAYMENT_ID")
    @Index(name="AMOUNTITEM_PAYMENTINFO_INDEX", columnNames={"PAYMENT_ID"})
    @AdminPresentation(excluded=true)
    protected PaymentInfo paymentInfo;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    @Override
    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    @Override
    public Long getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    @Override
    public PaymentInfo getPaymentInfo() {
        return this.paymentInfo;
    }

    @Override
    public void setPaymentInfo(PaymentInfo paymentInfo) {
        this.paymentInfo = paymentInfo;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getCurrencyCode() {
        return ((CurrencyCodeIdentifiable)this.paymentInfo).getCurrencyCode();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.quantity == null ? 0 : this.quantity.hashCode());
        result = 31 * result + (this.shortDescription == null ? 0 : this.shortDescription.hashCode());
        result = 31 * result + (this.unitPrice == null ? 0 : this.unitPrice.hashCode());
        result = 31 * result + (this.systemId == null ? 0 : this.systemId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmountItemImpl)) {
            return false;
        }
        AmountItemImpl other = (AmountItemImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.quantity == null ? other.quantity != null : !this.quantity.equals(other.quantity)) {
            return false;
        }
        if (this.shortDescription == null ? other.shortDescription != null : !this.shortDescription.equals(other.shortDescription)) {
            return false;
        }
        if (this.unitPrice == null ? other.unitPrice != null : !this.unitPrice.equals(other.unitPrice)) {
            return false;
        }
        return !(this.systemId == null ? other.systemId != null : !this.systemId.equals(other.systemId));
    }
}

