/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.type;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class OrderStatus
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, OrderStatus> TYPES = new LinkedHashMap<String, OrderStatus>();
    public static final OrderStatus NAMED = new OrderStatus("NAMED", "Named");
    public static final OrderStatus QUOTE = new OrderStatus("QUOTE", "Quote");
    public static final OrderStatus IN_PROCESS = new OrderStatus("IN_PROCESS", "In Process");
    public static final OrderStatus SUBMITTED = new OrderStatus("SUBMITTED", "Submitted");
    public static final OrderStatus CANCELLED = new OrderStatus("CANCELLED", "Cancelled");
    private String type;
    private String friendlyType;

    public static OrderStatus getInstance(String type) {
        return TYPES.get(type);
    }

    public OrderStatus() {
    }

    public OrderStatus(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderStatus)) {
            return false;
        }
        OrderStatus other = (OrderStatus)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

