/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemAttribute;
import org.broadleafcommerce.core.order.domain.OrderItemImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ORDER_ITEM_ATTRIBUTE")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blOrderElements")
@AdminPresentationClass(friendlyName="OrderItemAttributeImpl_baseProductAttribute")
public class OrderItemAttributeImpl
implements OrderItemAttribute {
    public static final Log LOG = LogFactory.getLog(OrderItemAttributeImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OrderItemAttributeId")
    @GenericGenerator(name="OrderItemAttributeId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="OrderItemAttributeImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.OrderItemAttributeImpl")})
    @Column(name="ORDER_ITEM_ATTRIBUTE_ID")
    protected Long id;
    @Column(name="NAME", nullable=false)
    @AdminPresentation(visibility=VisibilityEnum.HIDDEN_ALL)
    protected String name;
    @Column(name="VALUE", nullable=false)
    @AdminPresentation(friendlyName="OrderItemAttributeImpl_Attribute_Value", order=2, group="OrderItemAttributeImpl_Description", prominent=true)
    protected String value;
    @ManyToOne(targetEntity=OrderItemImpl.class, optional=false)
    @JoinColumn(name="ORDER_ITEM_ID")
    protected OrderItem orderItem;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public OrderItem getOrderItem() {
        return this.orderItem;
    }

    @Override
    public void setOrderItem(OrderItem orderItem) {
        this.orderItem = orderItem;
    }

    public void checkCloneable(OrderItemAttribute itemAttribute) throws CloneNotSupportedException, SecurityException, NoSuchMethodException {
        Method cloneMethod = itemAttribute.getClass().getMethod("clone", new Class[0]);
        if (cloneMethod.getDeclaringClass().getName().startsWith("org.broadleafcommerce") && !itemAttribute.getClass().getName().startsWith("org.broadleafcommerce")) {
            throw new CloneNotSupportedException("Custom extensions and implementations should implement clone in order to guarantee split and merge operations are performed accurately");
        }
    }

    @Override
    public OrderItemAttribute clone() {
        OrderItemAttribute itemAttribute;
        try {
            itemAttribute = (OrderItemAttribute)Class.forName(this.getClass().getName()).newInstance();
            try {
                this.checkCloneable(itemAttribute);
            }
            catch (CloneNotSupportedException e) {
                LOG.warn((Object)("Clone implementation missing in inheritance hierarchy outside of Broadleaf: " + itemAttribute.getClass().getName()), (Throwable)e);
            }
            itemAttribute.setName(this.name);
            itemAttribute.setOrderItem(this.orderItem);
            itemAttribute.setValue((Serializable)((Object)this.value));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return itemAttribute;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderItemAttributeImpl)) {
            return false;
        }
        if (this.value == null) {
            return false;
        }
        return this.value.equals(((OrderItemAttribute)obj).getValue());
    }
}

