/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderAttribute;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ORDER_ATTRIBUTE")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blOrderElements")
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="", mergeEntries={@AdminPresentationMergeEntry(propertyType="readOnly", booleanOverrideValue=true)})})
@AdminPresentationClass(friendlyName="OrderAttributeImpl_baseProductAttribute")
public class OrderAttributeImpl
implements OrderAttribute {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OrderAttributeId")
    @GenericGenerator(name="OrderAttributeId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="OrderAttributeImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.OrderAttributeImpl")})
    @Column(name="ORDER_ATTRIBUTE_ID")
    protected Long id;
    @Column(name="NAME", nullable=false)
    @AdminPresentation(friendlyName="OrderAttributeImpl_Attribute_Name", order=1000, prominent=true)
    protected String name;
    @Column(name="VALUE")
    @AdminPresentation(friendlyName="OrderAttributeImpl_Attribute_Value", order=2000, prominent=true)
    protected String value;
    @ManyToOne(targetEntity=OrderImpl.class, optional=false)
    @JoinColumn(name="ORDER_ID")
    protected Order order;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Order order) {
        this.order = order;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderAttributeImpl)) {
            return false;
        }
        if (this.value == null) {
            return false;
        }
        return this.value.equals(((OrderAttribute)obj).getValue());
    }
}

