/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.currency.util.CurrencyCodeIdentifiable;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationCollection;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOfferImpl;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustmentImpl;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.BundleOrderItemImpl;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupFee;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupFeeImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItemImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentOption;
import org.broadleafcommerce.core.order.domain.FulfillmentOptionImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.PersonalMessage;
import org.broadleafcommerce.core.order.domain.PersonalMessageImpl;
import org.broadleafcommerce.core.order.domain.TaxDetail;
import org.broadleafcommerce.core.order.domain.TaxDetailImpl;
import org.broadleafcommerce.core.order.service.type.FulfillmentGroupStatusType;
import org.broadleafcommerce.core.order.service.type.FulfillmentType;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.core.domain.PhoneImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_FULFILLMENT_GROUP")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="", mergeEntries={@AdminPresentationMergeEntry(propertyType="readOnly", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="currency", mergeEntries={@AdminPresentationMergeEntry(propertyType="prominent", booleanOverrideValue=false)}), @AdminPresentationMergeOverride(name="personalMessage", mergeEntries={@AdminPresentationMergeEntry(propertyType="tab", overrideValue="FulfillmentGroupImpl_Advanced_Tab"), @AdminPresentationMergeEntry(propertyType="tabOrder", intOverrideValue=5000)}), @AdminPresentationMergeOverride(name="address", mergeEntries={@AdminPresentationMergeEntry(propertyType="tab", overrideValue="FulfillmentGroupImpl_Address_Tab"), @AdminPresentationMergeEntry(propertyType="tabOrder", intOverrideValue=4000)}), @AdminPresentationMergeOverride(name="address.isDefault", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="address.isActive", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="address.isBusiness", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="phone", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="phone.phoneNumber", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=false), @AdminPresentationMergeEntry(propertyType="order", intOverrideValue=8000), @AdminPresentationMergeEntry(propertyType="group", overrideValue="General"), @AdminPresentationMergeEntry(propertyType="requiredOverride", overrideValue="NOT_REQUIRED")})})
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="FulfillmentGroupImpl_baseFulfillmentGroup")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"multiTenantSite"})})
public class FulfillmentGroupImpl
implements FulfillmentGroup,
CurrencyCodeIdentifiable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="FulfillmentGroupId")
    @GenericGenerator(name="FulfillmentGroupId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="FulfillmentGroupImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl")})
    @Column(name="FULFILLMENT_GROUP_ID")
    protected Long id;
    @Column(name="REFERENCE_NUMBER")
    @Index(name="FG_REFERENCE_INDEX", columnNames={"REFERENCE_NUMBER"})
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Reference_Number", order=3000, groupOrder=1000)
    protected String referenceNumber;
    @Column(name="METHOD")
    @Index(name="FG_METHOD_INDEX", columnNames={"METHOD"})
    @AdminPresentation(excluded=true)
    @Deprecated
    protected String method;
    @Column(name="SERVICE")
    @Index(name="FG_SERVICE_INDEX", columnNames={"SERVICE"})
    @AdminPresentation(excluded=true)
    @Deprecated
    protected String service;
    @Column(name="RETAIL_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_Retail_Shipping_Price", order=1000, group="FulfillmentGroupImpl_Pricing", groupOrder=2000, tab="FulfillmentGroupImpl_Pricing_Tab", tabOrder=3000, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal retailFulfillmentPrice;
    @Column(name="SALE_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_Sale_Shipping_Price", order=2000, group="FulfillmentGroupImpl_Pricing", groupOrder=2000, tab="FulfillmentGroupImpl_Pricing_Tab", tabOrder=3000, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal saleFulfillmentPrice;
    @Column(name="PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_Shipping_Price", order=3000, group="FulfillmentGroupImpl_Pricing", groupOrder=2000, tab="FulfillmentGroupImpl_Pricing_Tab", tabOrder=3000, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal fulfillmentPrice;
    @Column(name="TYPE")
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Type", order=5000, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.order.service.type.FulfillmentType", prominent=true, gridOrder=3000)
    protected String type;
    @Column(name="TOTAL_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Total_Tax", order=7000, group="FulfillmentGroupImpl_Pricing", groupOrder=2000, tab="FulfillmentGroupImpl_Pricing_Tab", tabOrder=3000, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal totalTax;
    @Column(name="TOTAL_ITEM_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Total_Item_Tax", order=4000, group="FulfillmentGroupImpl_Pricing", groupOrder=2000, tab="FulfillmentGroupImpl_Pricing_Tab", tabOrder=3000, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal totalItemTax;
    @Column(name="TOTAL_FEE_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Total_Fee_Tax", order=5000, group="FulfillmentGroupImpl_Pricing", groupOrder=2000, tab="FulfillmentGroupImpl_Pricing_Tab", tabOrder=3000, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal totalFeeTax;
    @Column(name="TOTAL_FG_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Total_FG_Tax", order=6000, group="FulfillmentGroupImpl_Pricing", groupOrder=2000, tab="FulfillmentGroupImpl_Pricing_Tab", tabOrder=3000, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal totalFulfillmentGroupTax;
    @Column(name="DELIVERY_INSTRUCTION")
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Delivery_Instruction", order=6000)
    protected String deliveryInstruction;
    @Column(name="IS_PRIMARY")
    @Index(name="FG_PRIMARY_INDEX", columnNames={"IS_PRIMARY"})
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_Primary_FG", order=7000)
    protected boolean primary = false;
    @Column(name="MERCHANDISE_TOTAL", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Merchandise_Total", order=8000, group="FulfillmentGroupImpl_Pricing", groupOrder=2000, tab="FulfillmentGroupImpl_Pricing_Tab", tabOrder=3000, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal merchandiseTotal;
    @Column(name="TOTAL", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Total", order=9000, group="FulfillmentGroupImpl_Pricing", groupOrder=2000, tab="FulfillmentGroupImpl_Pricing_Tab", tabOrder=3000, fieldType=SupportedFieldType.MONEY, prominent=true, gridOrder=2000)
    protected BigDecimal total;
    @Column(name="STATUS")
    @Index(name="FG_STATUS_INDEX", columnNames={"STATUS"})
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Status", order=4000, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.order.service.type.FulfillmentGroupStatusType", prominent=true, gridOrder=4000)
    protected String status;
    @Column(name="SHIPPING_PRICE_TAXABLE")
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_Shipping_Price_Taxable", order=10000, group="FulfillmentGroupImpl_Pricing", groupOrder=2000, tab="FulfillmentGroupImpl_Pricing_Tab", tabOrder=3000)
    protected Boolean isShippingPriceTaxable = Boolean.FALSE;
    @ManyToOne(targetEntity=FulfillmentOptionImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="FULFILLMENT_OPTION_ID")
    protected FulfillmentOption fulfillmentOption;
    @ManyToOne(targetEntity=OrderImpl.class, optional=false)
    @JoinColumn(name="ORDER_ID")
    @Index(name="FG_ORDER_INDEX", columnNames={"ORDER_ID"})
    @AdminPresentation(excluded=true)
    protected Order order;
    @Column(name="FULFILLMENT_GROUP_SEQUNCE")
    protected Integer sequence;
    @ManyToOne(targetEntity=AddressImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="ADDRESS_ID")
    @Index(name="FG_ADDRESS_INDEX", columnNames={"ADDRESS_ID"})
    protected Address address;
    @ManyToOne(targetEntity=PhoneImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="PHONE_ID")
    @Index(name="FG_PHONE_INDEX", columnNames={"PHONE_ID"})
    protected Phone phone;
    @ManyToOne(targetEntity=PersonalMessageImpl.class, cascade={CascadeType.ALL})
    @JoinColumn(name="PERSONAL_MESSAGE_ID")
    @Index(name="FG_MESSAGE_INDEX", columnNames={"PERSONAL_MESSAGE_ID"})
    protected PersonalMessage personalMessage;
    @OneToMany(mappedBy="fulfillmentGroup", targetEntity=FulfillmentGroupItemImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    @AdminPresentationCollection(friendlyName="FulfillmentGroupImpl_Items", tab="FulfillmentGroupImpl_Items_Tab", tabOrder=2000)
    protected List<FulfillmentGroupItem> fulfillmentGroupItems = new ArrayList<FulfillmentGroupItem>();
    @OneToMany(mappedBy="fulfillmentGroup", targetEntity=FulfillmentGroupFeeImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    @AdminPresentationCollection(friendlyName="FulfillmentGroupImpl_Fees", tab="FulfillmentGroupImpl_Pricing_Tab", tabOrder=3000)
    protected List<FulfillmentGroupFee> fulfillmentGroupFees = new ArrayList<FulfillmentGroupFee>();
    @OneToMany(mappedBy="fulfillmentGroup", targetEntity=CandidateFulfillmentGroupOfferImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<CandidateFulfillmentGroupOffer> candidateOffers = new ArrayList<CandidateFulfillmentGroupOffer>();
    @OneToMany(mappedBy="fulfillmentGroup", targetEntity=FulfillmentGroupAdjustmentImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    @AdminPresentationCollection(friendlyName="FulfillmentGroupImpl_Adjustments", tab="FulfillmentGroupImpl_Advanced_Tab", tabOrder=5000)
    protected List<FulfillmentGroupAdjustment> fulfillmentGroupAdjustments = new ArrayList<FulfillmentGroupAdjustment>();
    @OneToMany(fetch=FetchType.LAZY, targetEntity=TaxDetailImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(name="BLC_FG_FG_TAX_XREF", joinColumns={@JoinColumn(name="FULFILLMENT_GROUP_ID")}, inverseJoinColumns={@JoinColumn(name="TAX_DETAIL_ID")})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<TaxDetail> taxes = new ArrayList<TaxDetail>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Order order) {
        this.order = order;
    }

    @Override
    public FulfillmentOption getFulfillmentOption() {
        return this.fulfillmentOption;
    }

    @Override
    public void setFulfillmentOption(FulfillmentOption fulfillmentOption) {
        this.fulfillmentOption = fulfillmentOption;
    }

    @Override
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    @Override
    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    @Override
    public List<FulfillmentGroupItem> getFulfillmentGroupItems() {
        return this.fulfillmentGroupItems;
    }

    @Override
    public List<DiscreteOrderItem> getDiscreteOrderItems() {
        ArrayList<DiscreteOrderItem> discreteOrderItems = new ArrayList<DiscreteOrderItem>();
        for (FulfillmentGroupItem fgItem : this.fulfillmentGroupItems) {
            OrderItem orderItem = fgItem.getOrderItem();
            if (orderItem instanceof BundleOrderItem) {
                BundleOrderItemImpl bundleOrderItem = (BundleOrderItemImpl)orderItem;
                for (DiscreteOrderItem discreteOrderItem : bundleOrderItem.getDiscreteOrderItems()) {
                    discreteOrderItems.add(discreteOrderItem);
                }
                continue;
            }
            if (!(orderItem instanceof DiscreteOrderItem)) continue;
            DiscreteOrderItem discreteOrderItem = (DiscreteOrderItem)orderItem;
            discreteOrderItems.add(discreteOrderItem);
        }
        return discreteOrderItems;
    }

    @Override
    public void setFulfillmentGroupItems(List<FulfillmentGroupItem> fulfillmentGroupItems) {
        this.fulfillmentGroupItems = fulfillmentGroupItems;
    }

    @Override
    public void addFulfillmentGroupItem(FulfillmentGroupItem fulfillmentGroupItem) {
        if (this.fulfillmentGroupItems == null) {
            this.fulfillmentGroupItems = new Vector<FulfillmentGroupItem>();
        }
        this.fulfillmentGroupItems.add(fulfillmentGroupItem);
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(Address address) {
        this.address = address;
    }

    @Override
    public Phone getPhone() {
        return this.phone;
    }

    @Override
    public void setPhone(Phone phone) {
        this.phone = phone;
    }

    @Override
    @Deprecated
    public String getMethod() {
        return this.method;
    }

    @Override
    @Deprecated
    public void setMethod(String fulfillmentMethod) {
        this.method = fulfillmentMethod;
    }

    @Override
    public Money getRetailFulfillmentPrice() {
        return this.retailFulfillmentPrice == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.retailFulfillmentPrice, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setRetailFulfillmentPrice(Money retailFulfillmentPrice) {
        this.retailFulfillmentPrice = Money.toAmount((Money)retailFulfillmentPrice);
    }

    @Override
    public Money getRetailShippingPrice() {
        return this.getRetailFulfillmentPrice();
    }

    @Override
    public void setRetailShippingPrice(Money retailShippingPrice) {
        this.setRetailFulfillmentPrice(retailShippingPrice);
    }

    @Override
    public FulfillmentType getType() {
        return FulfillmentType.getInstance(this.type);
    }

    @Override
    public void setType(FulfillmentType type) {
        this.type = type == null ? null : type.getType();
    }

    @Override
    public void addCandidateFulfillmentGroupOffer(CandidateFulfillmentGroupOffer candidateOffer) {
        this.candidateOffers.add(candidateOffer);
    }

    @Override
    public List<CandidateFulfillmentGroupOffer> getCandidateFulfillmentGroupOffers() {
        return this.candidateOffers;
    }

    @Override
    public void setCandidateFulfillmentGroupOffer(List<CandidateFulfillmentGroupOffer> candidateOffers) {
        this.candidateOffers = candidateOffers;
    }

    @Override
    public void removeAllCandidateOffers() {
        if (this.candidateOffers != null) {
            for (CandidateFulfillmentGroupOffer offer : this.candidateOffers) {
                offer.setFulfillmentGroup(null);
            }
            this.candidateOffers.clear();
        }
    }

    @Override
    public List<FulfillmentGroupAdjustment> getFulfillmentGroupAdjustments() {
        return this.fulfillmentGroupAdjustments;
    }

    @Override
    public Money getFulfillmentGroupAdjustmentsValue() {
        Money adjustmentsValue = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)this.getOrder().getCurrency());
        for (FulfillmentGroupAdjustment adjustment : this.fulfillmentGroupAdjustments) {
            adjustmentsValue = adjustmentsValue.add(adjustment.getValue());
        }
        return adjustmentsValue;
    }

    @Override
    public void removeAllAdjustments() {
        if (this.fulfillmentGroupAdjustments != null) {
            for (FulfillmentGroupAdjustment adjustment : this.fulfillmentGroupAdjustments) {
                adjustment.setFulfillmentGroup(null);
            }
            this.fulfillmentGroupAdjustments.clear();
        }
    }

    @Override
    public void setFulfillmentGroupAdjustments(List<FulfillmentGroupAdjustment> fulfillmentGroupAdjustments) {
        this.fulfillmentGroupAdjustments = fulfillmentGroupAdjustments;
    }

    @Override
    public Money getSaleFulfillmentPrice() {
        return this.saleFulfillmentPrice == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.saleFulfillmentPrice, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setSaleFulfillmentPrice(Money saleFulfillmentPrice) {
        this.saleFulfillmentPrice = Money.toAmount((Money)saleFulfillmentPrice);
    }

    @Override
    public Money getSaleShippingPrice() {
        return this.getSaleFulfillmentPrice();
    }

    @Override
    public void setSaleShippingPrice(Money saleShippingPrice) {
        this.setSaleFulfillmentPrice(saleShippingPrice);
    }

    @Override
    public Money getFulfillmentPrice() {
        return this.fulfillmentPrice == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.fulfillmentPrice, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setFulfillmentPrice(Money fulfillmentPrice) {
        this.fulfillmentPrice = Money.toAmount((Money)fulfillmentPrice);
    }

    @Override
    public Money getShippingPrice() {
        return this.getFulfillmentPrice();
    }

    @Override
    public void setShippingPrice(Money shippingPrice) {
        this.setFulfillmentPrice(shippingPrice);
    }

    @Override
    public List<TaxDetail> getTaxes() {
        return this.taxes;
    }

    @Override
    public void setTaxes(List<TaxDetail> taxes) {
        this.taxes = taxes;
    }

    @Override
    public Money getTotalTax() {
        return this.totalTax == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.totalTax, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setTotalTax(Money totalTax) {
        this.totalTax = Money.toAmount((Money)totalTax);
    }

    @Override
    public Money getTotalItemTax() {
        return this.totalItemTax == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.totalItemTax, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setTotalItemTax(Money totalItemTax) {
        this.totalItemTax = Money.toAmount((Money)totalItemTax);
    }

    @Override
    public Money getTotalFeeTax() {
        return this.totalFeeTax == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.totalFeeTax, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setTotalFeeTax(Money totalFeeTax) {
        this.totalFeeTax = Money.toAmount((Money)totalFeeTax);
    }

    @Override
    public Money getTotalFulfillmentGroupTax() {
        return this.totalFulfillmentGroupTax == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.totalFulfillmentGroupTax, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setTotalFulfillmentGroupTax(Money totalFulfillmentGroupTax) {
        this.totalFulfillmentGroupTax = Money.toAmount((Money)totalFulfillmentGroupTax);
    }

    @Override
    public String getDeliveryInstruction() {
        return this.deliveryInstruction;
    }

    @Override
    public void setDeliveryInstruction(String deliveryInstruction) {
        this.deliveryInstruction = deliveryInstruction;
    }

    @Override
    public PersonalMessage getPersonalMessage() {
        return this.personalMessage;
    }

    @Override
    public void setPersonalMessage(PersonalMessage personalMessage) {
        this.personalMessage = personalMessage;
    }

    @Override
    public boolean isPrimary() {
        return this.primary;
    }

    @Override
    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    @Override
    public Money getMerchandiseTotal() {
        return this.merchandiseTotal == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.merchandiseTotal, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setMerchandiseTotal(Money merchandiseTotal) {
        this.merchandiseTotal = Money.toAmount((Money)merchandiseTotal);
    }

    @Override
    public Money getTotal() {
        return this.total == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.total, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setTotal(Money orderTotal) {
        this.total = Money.toAmount((Money)orderTotal);
    }

    @Override
    public FulfillmentGroupStatusType getStatus() {
        return FulfillmentGroupStatusType.getInstance(this.status);
    }

    @Override
    public void setStatus(FulfillmentGroupStatusType status) {
        this.status = status.getType();
    }

    @Override
    public List<FulfillmentGroupFee> getFulfillmentGroupFees() {
        return this.fulfillmentGroupFees;
    }

    @Override
    public void setFulfillmentGroupFees(List<FulfillmentGroupFee> fulfillmentGroupFees) {
        this.fulfillmentGroupFees = fulfillmentGroupFees;
    }

    @Override
    public void addFulfillmentGroupFee(FulfillmentGroupFee fulfillmentGroupFee) {
        if (this.fulfillmentGroupFees == null) {
            this.fulfillmentGroupFees = new ArrayList<FulfillmentGroupFee>();
        }
        this.fulfillmentGroupFees.add(fulfillmentGroupFee);
    }

    @Override
    public void removeAllFulfillmentGroupFees() {
        if (this.fulfillmentGroupFees != null) {
            this.fulfillmentGroupFees.clear();
        }
    }

    @Override
    public Boolean isShippingPriceTaxable() {
        return this.isShippingPriceTaxable;
    }

    @Override
    public void setIsShippingPriceTaxable(Boolean isShippingPriceTaxable) {
        this.isShippingPriceTaxable = isShippingPriceTaxable;
    }

    @Override
    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    @Override
    public Integer getSequence() {
        return this.sequence;
    }

    @Override
    @Deprecated
    public String getService() {
        return this.service;
    }

    @Override
    @Deprecated
    public void setService(String service) {
        this.service = service;
    }

    public String getCurrencyCode() {
        if (this.getOrder().getCurrency() != null) {
            return this.getOrder().getCurrency().getCurrencyCode();
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.fulfillmentGroupItems == null ? 0 : this.fulfillmentGroupItems.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FulfillmentGroupImpl)) {
            return false;
        }
        FulfillmentGroupImpl other = (FulfillmentGroupImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        return !(this.fulfillmentGroupItems == null ? other.fulfillmentGroupItems != null : !this.fulfillmentGroupItems.equals(other.fulfillmentGroupItems));
    }

    public static class Presentation {

        public static class FieldOrder {
            public static final int REFNUMBER = 3000;
            public static final int STATUS = 4000;
            public static final int TYPE = 5000;
            public static final int DELIVERINSTRUCTION = 6000;
            public static final int PRIMARY = 7000;
            public static final int PHONE = 8000;
            public static final int RETAIL = 1000;
            public static final int SALE = 2000;
            public static final int PRICE = 3000;
            public static final int ITEMTAX = 4000;
            public static final int FEETAX = 5000;
            public static final int FGTAX = 6000;
            public static final int TOTALTAX = 7000;
            public static final int MERCHANDISETOTAL = 8000;
            public static final int TOTAL = 9000;
            public static final int TAXABLE = 10000;
        }

        public static class Group {

            public static class Order {
                public static final int General = 1000;
                public static final int Pricing = 2000;
            }

            public static class Name {
                public static final String Pricing = "FulfillmentGroupImpl_Pricing";
            }
        }

        public static class Tab {

            public static class Order {
                public static final int Items = 2000;
                public static final int Pricing = 3000;
                public static final int Address = 4000;
                public static final int Advanced = 5000;
            }

            public static class Name {
                public static final String Items = "FulfillmentGroupImpl_Items_Tab";
                public static final String Pricing = "FulfillmentGroupImpl_Pricing_Tab";
                public static final String Address = "FulfillmentGroupImpl_Address_Tab";
                public static final String Advanced = "FulfillmentGroupImpl_Advanced_Tab";
            }
        }
    }
}

