/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationToOneLookup;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="BLC_OFFER_CODE")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.FALSE, friendlyName="OfferCodeImpl_baseOfferCode")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true)})
public class OfferCodeImpl
implements OfferCode {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OfferCodeId")
    @GenericGenerator(name="OfferCodeId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="OfferCodeImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.offer.domain.OfferCodeImpl")})
    @Column(name="OFFER_CODE_ID")
    @AdminPresentation(friendlyName="OfferCodeImpl_Offer_Code_Id")
    protected Long id;
    @ManyToOne(targetEntity=OfferImpl.class, optional=false)
    @JoinColumn(name="OFFER_ID")
    @Index(name="OFFERCODE_OFFER_INDEX", columnNames={"OFFER_ID"})
    @AdminPresentation(friendlyName="OfferCodeImpl_Offer", order=2000, prominent=true, gridOrder=2000)
    @AdminPresentationToOneLookup
    protected Offer offer;
    @Column(name="OFFER_CODE", nullable=false)
    @Index(name="OFFERCODE_CODE_INDEX", columnNames={"OFFER_CODE"})
    @AdminPresentation(friendlyName="OfferCodeImpl_Offer_Code", order=1000, prominent=true, gridOrder=1000)
    protected String offerCode;
    @Column(name="START_DATE")
    @AdminPresentation(friendlyName="OfferCodeImpl_Code_Start_Date", order=3000)
    protected Date offerCodeStartDate;
    @Column(name="END_DATE")
    @AdminPresentation(friendlyName="OfferCodeImpl_Code_End_Date", order=4000)
    protected Date offerCodeEndDate;
    @Column(name="MAX_USES")
    @AdminPresentation(friendlyName="OfferCodeImpl_Code_Max_Uses", order=5000)
    protected Integer maxUses;
    @Column(name="USES")
    @Deprecated
    protected int uses;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="addedOfferCodes", targetEntity=OrderImpl.class)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<Order> orders = new ArrayList<Order>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    @Override
    public void setOffer(Offer offer) {
        this.offer = offer;
    }

    @Override
    public String getOfferCode() {
        return this.offerCode;
    }

    @Override
    public void setOfferCode(String offerCode) {
        this.offerCode = offerCode;
    }

    @Override
    public int getMaxUses() {
        return this.maxUses == null ? 0 : this.maxUses;
    }

    @Override
    public void setMaxUses(int maxUses) {
        this.maxUses = maxUses;
    }

    @Override
    public boolean isUnlimitedUse() {
        return this.getMaxUses() == 0;
    }

    @Override
    public boolean isLimitedUse() {
        return this.getMaxUses() > 0;
    }

    @Override
    @Deprecated
    public int getUses() {
        return this.uses;
    }

    @Override
    @Deprecated
    public void setUses(int uses) {
        this.uses = uses;
    }

    @Override
    public Date getStartDate() {
        return this.offerCodeStartDate;
    }

    @Override
    public void setStartDate(Date startDate) {
        this.offerCodeStartDate = startDate;
    }

    @Override
    public Date getEndDate() {
        return this.offerCodeEndDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.offerCodeEndDate = endDate;
    }

    @Override
    public List<Order> getOrders() {
        return this.orders;
    }

    @Override
    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.offer).append((Object)this.offerCode).build();
    }

    public boolean equals(Object o) {
        if (o instanceof OfferCodeImpl) {
            OfferCodeImpl that = (OfferCodeImpl)o;
            return new EqualsBuilder().append((Object)this.id, (Object)that.id).append((Object)this.offer, (Object)that.offer).append((Object)this.offerCode, (Object)that.offerCode).build();
        }
        return false;
    }
}

