/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.dao;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.common.persistence.Status;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.domain.CandidateItemOffer;
import org.broadleafcommerce.core.offer.domain.CandidateOrderOffer;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.domain.OfferInfo;
import org.broadleafcommerce.core.offer.domain.OrderAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderItemPriceDetailAdjustment;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.ejb.HibernateEntityManager;
import org.springframework.stereotype.Repository;

@Repository(value="blOfferDao")
public class OfferDaoImpl
implements OfferDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    protected Long currentDateResolution = 10000L;
    protected Date cachedDate = SystemTime.asDate();

    protected Date getCurrentDateAfterFactoringInDateResolution() {
        Date returnDate = SystemTime.getCurrentDateWithinTimeResolution((Date)this.cachedDate, (Long)this.currentDateResolution);
        if (returnDate != this.cachedDate && SystemTime.shouldCacheDate()) {
            this.cachedDate = returnDate;
        }
        return returnDate;
    }

    @Override
    public Offer create() {
        return (Offer)this.entityConfiguration.createEntityInstance(Offer.class.getName());
    }

    @Override
    public OfferInfo createOfferInfo() {
        return (OfferInfo)this.entityConfiguration.createEntityInstance(OfferInfo.class.getName());
    }

    @Override
    public CandidateOrderOffer createCandidateOrderOffer() {
        return (CandidateOrderOffer)this.entityConfiguration.createEntityInstance(CandidateOrderOffer.class.getName());
    }

    @Override
    public CandidateItemOffer createCandidateItemOffer() {
        return (CandidateItemOffer)this.entityConfiguration.createEntityInstance(CandidateItemOffer.class.getName());
    }

    @Override
    public CandidateFulfillmentGroupOffer createCandidateFulfillmentGroupOffer() {
        return (CandidateFulfillmentGroupOffer)this.entityConfiguration.createEntityInstance(CandidateFulfillmentGroupOffer.class.getName());
    }

    @Override
    public OrderItemAdjustment createOrderItemAdjustment() {
        return (OrderItemAdjustment)this.entityConfiguration.createEntityInstance(OrderItemAdjustment.class.getName());
    }

    @Override
    public OrderItemPriceDetailAdjustment createOrderItemPriceDetailAdjustment() {
        return (OrderItemPriceDetailAdjustment)this.entityConfiguration.createEntityInstance(OrderItemPriceDetailAdjustment.class.getName());
    }

    @Override
    public OrderAdjustment createOrderAdjustment() {
        return (OrderAdjustment)this.entityConfiguration.createEntityInstance(OrderAdjustment.class.getName());
    }

    @Override
    public FulfillmentGroupAdjustment createFulfillmentGroupAdjustment() {
        return (FulfillmentGroupAdjustment)this.entityConfiguration.createEntityInstance(FulfillmentGroupAdjustment.class.getName());
    }

    @Override
    public void delete(Offer offer) {
        ((Status)offer).setArchived(Character.valueOf('Y'));
        this.em.merge((Object)offer);
    }

    @Override
    public void delete(OfferInfo offerInfo) {
        if (!this.em.contains((Object)offerInfo)) {
            offerInfo = (OfferInfo)this.em.find(this.entityConfiguration.lookupEntityClass(OfferInfo.class.getName()), (Object)offerInfo.getId());
        }
        this.em.remove((Object)offerInfo);
    }

    @Override
    public Offer save(Offer offer) {
        return (Offer)this.em.merge((Object)offer);
    }

    @Override
    public OfferInfo save(OfferInfo offerInfo) {
        return (OfferInfo)this.em.merge((Object)offerInfo);
    }

    @Override
    public List<Offer> readAllOffers() {
        Query query = this.em.createNamedQuery("BC_READ_ALL_OFFERS");
        return query.getResultList();
    }

    @Override
    public Offer readOfferById(Long offerId) {
        return (Offer)this.em.find(OfferImpl.class, (Object)offerId);
    }

    @Override
    public List<Offer> readOffersByAutomaticDeliveryType() {
        Criteria criteria = ((HibernateEntityManager)this.em).getSession().createCriteria(OfferImpl.class);
        Date myDate = this.getCurrentDateAfterFactoringInDateResolution();
        Calendar c = Calendar.getInstance();
        c.setTime(myDate);
        c.add(5, 1);
        criteria.add((Criterion)Restrictions.lt((String)"startDate", (Object)c.getTime()));
        c = Calendar.getInstance();
        c.setTime(myDate);
        c.add(5, -1);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"endDate"), (Criterion)Restrictions.gt((String)"endDate", (Object)c.getTime())));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"archiveStatus.archived", (Object)Character.valueOf('N')), (Criterion)Restrictions.isNull((String)"archiveStatus.archived")));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"automaticallyAdded", (Object)true), (Criterion)Restrictions.and((Criterion)Restrictions.isNull((String)"automaticallyAdded"), (Criterion)Restrictions.eq((String)"deliveryType", (Object)"AUTOMATIC"))));
        criteria.setCacheable(true);
        criteria.setCacheRegion("query.Offer");
        return criteria.list();
    }

    @Override
    public Long getCurrentDateResolution() {
        return this.currentDateResolution;
    }

    @Override
    public void setCurrentDateResolution(Long currentDateResolution) {
        this.currentDateResolution = currentDateResolution;
    }
}

