/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.dao;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.common.util.dao.TypedQueryBuilder;
import org.broadleafcommerce.core.offer.dao.OfferAuditDao;
import org.broadleafcommerce.core.offer.domain.OfferAudit;
import org.broadleafcommerce.core.offer.domain.OfferAuditImpl;
import org.springframework.stereotype.Repository;

@Repository(value="blOfferAuditDao")
public class OfferAuditDaoImpl
implements OfferAuditDao {
    protected static final Log LOG = LogFactory.getLog(OfferAuditDaoImpl.class);
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public OfferAudit create() {
        return (OfferAudit)this.entityConfiguration.createEntityInstance(OfferAudit.class.getName());
    }

    @Override
    public void delete(OfferAudit offerAudit) {
        OfferAudit loa = offerAudit;
        if (!this.em.contains((Object)loa)) {
            loa = this.readAuditById(offerAudit.getId());
        }
        this.em.remove((Object)loa);
    }

    @Override
    public OfferAudit save(OfferAudit offerAudit) {
        return (OfferAudit)this.em.merge((Object)offerAudit);
    }

    @Override
    public OfferAudit readAuditById(Long offerAuditId) {
        return (OfferAudit)this.em.find(OfferAuditImpl.class, (Object)offerAuditId);
    }

    @Override
    public Long countUsesByCustomer(Long customerId, Long offerId) {
        TypedQuery query = new TypedQueryBuilder(OfferAudit.class, "offerAudit").addRestriction("offerAudit.customerId", "=", (Object)customerId).addRestriction("offerAudit.offerId", "=", (Object)offerId).toCountQuery(this.em);
        Long result = (Long)query.getSingleResult();
        return result;
    }

    @Override
    public Long countOfferCodeUses(Long offerCodeId) {
        TypedQuery query = new TypedQueryBuilder(OfferAudit.class, "offerAudit").addRestriction("offerAudit.offerCodeId", "=", (Object)offerCodeId).toCountQuery(this.em);
        Long result = (Long)query.getSingleResult();
        return result;
    }
}

