/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.checkout.service;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.core.checkout.service.CheckoutService;
import org.broadleafcommerce.core.checkout.service.exception.CheckoutException;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutResponse;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.exception.RequiredAttributeNotProvidedException;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.workflow.ActivityMessages;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.Processor;
import org.broadleafcommerce.core.workflow.WorkflowException;
import org.springframework.stereotype.Service;

@Service(value="blCheckoutService")
public class CheckoutServiceImpl
implements CheckoutService {
    @Resource(name="blCheckoutWorkflow")
    protected Processor checkoutWorkflow;
    @Resource(name="blOrderService")
    protected OrderService orderService;

    @Override
    public CheckoutResponse performCheckout(Order order, Map<PaymentInfo, Referenced> payments) throws CheckoutException {
        if (payments != null) {
            for (PaymentInfo info : payments.keySet()) {
                if (info.getReferenceNumber() != null) continue;
                throw new CheckoutException("PaymentInfo reference number cannot be null", null);
            }
            for (Referenced referenced : payments.values()) {
                if (referenced.getReferenceNumber() != null) continue;
                throw new CheckoutException("Referenced reference number cannot be null", null);
            }
        }
        CheckoutSeed seed = null;
        try {
            order = this.orderService.save(order, false);
            seed = new CheckoutSeed(order, payments, new HashMap<String, Object>());
            ProcessContext<?> context = this.checkoutWorkflow.doActivities(seed);
            order = this.orderService.save(seed.getOrder(), false);
            order.getOrderMessages().addAll(((ActivityMessages)((Object)context)).getActivityMessages());
            seed.setOrder(order);
            return seed;
        }
        catch (PricingException e) {
            throw new CheckoutException("Unable to checkout order -- id: " + order.getId(), e, seed);
        }
        catch (WorkflowException e) {
            throw new CheckoutException("Unable to checkout order -- id: " + order.getId(), e.getRootCause(), seed);
        }
        catch (RequiredAttributeNotProvidedException e) {
            throw new CheckoutException("Unable to checkout order -- id: " + order.getId(), e.getCause(), seed);
        }
    }

    @Override
    public CheckoutResponse performCheckout(Order order) throws CheckoutException {
        return this.performCheckout(order, null);
    }
}

