/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service.type;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class ProductOptionValidationStrategyType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, ProductOptionValidationStrategyType> TYPES = new LinkedHashMap<String, ProductOptionValidationStrategyType>();
    public static final ProductOptionValidationStrategyType ADD_ITEM = new ProductOptionValidationStrategyType("ADD_ITEM", 1000, "Validate On Add Item");
    public static final ProductOptionValidationStrategyType SUBMIT_ORDER = new ProductOptionValidationStrategyType("SUBMIT_ORDER", 2000, "Validate On Submit");
    private String type;
    private String friendlyType;
    private Integer rank;

    public static ProductOptionValidationStrategyType getInstance(String type) {
        return TYPES.get(type);
    }

    public Integer getRank() {
        return this.rank;
    }

    public ProductOptionValidationStrategyType() {
    }

    public ProductOptionValidationStrategyType(String type, Integer rank, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
        this.rank = rank;
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductOptionValidationStrategyType)) {
            return false;
        }
        ProductOptionValidationStrategyType other = (ProductOptionValidationStrategyType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

