/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryAttribute;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CATEGORY_ATTRIBUTE")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCategories")
@AdminPresentationClass(friendlyName="baseCategoryAttribute")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true)})
public class CategoryAttributeImpl
implements CategoryAttribute {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="CategoryAttributeId")
    @GenericGenerator(name="CategoryAttributeId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="CategoryAttributeImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.CategoryAttributeImpl")})
    @Column(name="CATEGORY_ATTRIBUTE_ID")
    protected Long id;
    @Column(name="NAME", nullable=false)
    @Index(name="CATEGORYATTRIBUTE_NAME_INDEX", columnNames={"NAME"})
    @AdminPresentation(visibility=VisibilityEnum.HIDDEN_ALL)
    protected String name;
    @Column(name="VALUE")
    @AdminPresentation(friendlyName="ProductAttributeImpl_Attribute_Value", order=2, group="ProductAttributeImpl_Description", prominent=true)
    protected String value;
    @Column(name="SEARCHABLE")
    @AdminPresentation(excluded=true)
    protected Boolean searchable = false;
    @ManyToOne(targetEntity=CategoryImpl.class, optional=false)
    @JoinColumn(name="CATEGORY_ID")
    @Index(name="CATEGORYATTRIBUTE_INDEX", columnNames={"CATEGORY_ID"})
    protected Category category;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public Boolean getSearchable() {
        if (this.searchable == null) {
            return Boolean.FALSE;
        }
        return this.searchable;
    }

    public void setSearchable(Boolean searchable) {
        this.searchable = searchable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(Category category) {
        this.category = category;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryAttributeImpl)) {
            return false;
        }
        CategoryAttributeImpl other = (CategoryAttributeImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

