/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.broadleafcommerce.core.offer.dao.CustomerOfferDao;
import org.broadleafcommerce.core.offer.dao.OfferCodeDao;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOfferImpl;
import org.broadleafcommerce.core.offer.domain.CandidateItemOffer;
import org.broadleafcommerce.core.offer.domain.CandidateItemOfferImpl;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustmentImpl;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustmentImpl;
import org.broadleafcommerce.core.offer.service.OfferDataItemProvider;
import org.broadleafcommerce.core.offer.service.OfferServiceImpl;
import org.broadleafcommerce.core.offer.service.OfferServiceUtilities;
import org.broadleafcommerce.core.offer.service.OfferServiceUtilitiesImpl;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactoryImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.processor.FulfillmentGroupOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.FulfillmentGroupOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.processor.OfferTimeZoneProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.core.order.dao.OrderItemDao;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetail;
import org.broadleafcommerce.core.order.domain.OrderMultishipOption;
import org.broadleafcommerce.core.order.domain.OrderMultishipOptionImpl;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderMultishipOptionService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupItemRequest;
import org.broadleafcommerce.profile.core.domain.Address;
import org.easymock.EasyMock;
import org.easymock.IAnswer;

public class FulfillmentGroupOfferProcessorTest
extends TestCase {
    protected OfferDao offerDaoMock;
    protected OrderItemDao orderItemDaoMock;
    protected OfferServiceImpl offerService;
    protected final OfferDataItemProvider dataProvider = new OfferDataItemProvider();
    protected OrderService orderServiceMock;
    protected OrderItemService orderItemServiceMock;
    protected FulfillmentGroupItemDao fgItemDaoMock;
    protected FulfillmentGroupService fgServiceMock;
    protected OrderMultishipOptionService multishipOptionServiceMock;
    protected OfferTimeZoneProcessor offerTimeZoneProcessorMock;
    protected FulfillmentGroupOfferProcessorImpl fgProcessor;

    protected void setUp() throws Exception {
        this.offerService = new OfferServiceImpl();
        CustomerOfferDao customerOfferDaoMock = (CustomerOfferDao)EasyMock.createMock(CustomerOfferDao.class);
        OfferCodeDao offerCodeDaoMock = (OfferCodeDao)EasyMock.createMock(OfferCodeDao.class);
        this.orderServiceMock = (OrderService)EasyMock.createMock(OrderService.class);
        this.orderItemDaoMock = (OrderItemDao)EasyMock.createMock(OrderItemDao.class);
        this.orderItemServiceMock = (OrderItemService)EasyMock.createMock(OrderItemService.class);
        this.fgItemDaoMock = (FulfillmentGroupItemDao)EasyMock.createMock(FulfillmentGroupItemDao.class);
        this.offerDaoMock = (OfferDao)EasyMock.createMock(OfferDao.class);
        this.fgServiceMock = (FulfillmentGroupService)EasyMock.createMock(FulfillmentGroupService.class);
        this.multishipOptionServiceMock = (OrderMultishipOptionService)EasyMock.createMock(OrderMultishipOptionService.class);
        this.fgProcessor = new FulfillmentGroupOfferProcessorImpl();
        this.fgProcessor.setOfferDao(this.offerDaoMock);
        this.fgProcessor.setOrderItemDao(this.orderItemDaoMock);
        this.fgProcessor.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        OfferServiceUtilitiesImpl offerServiceUtilities = new OfferServiceUtilitiesImpl();
        offerServiceUtilities.setOfferDao(this.offerDaoMock);
        offerServiceUtilities.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        OrderOfferProcessorImpl orderProcessor = new OrderOfferProcessorImpl();
        orderProcessor.setOfferDao(this.offerDaoMock);
        orderProcessor.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        this.offerTimeZoneProcessorMock = (OfferTimeZoneProcessor)EasyMock.createMock(OfferTimeZoneProcessor.class);
        orderProcessor.setOfferTimeZoneProcessor(this.offerTimeZoneProcessorMock);
        orderProcessor.setOrderItemDao(this.orderItemDaoMock);
        orderProcessor.setOfferServiceUtilities((OfferServiceUtilities)offerServiceUtilities);
        ItemOfferProcessorImpl itemProcessor = new ItemOfferProcessorImpl();
        itemProcessor.setOfferDao(this.offerDaoMock);
        itemProcessor.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        itemProcessor.setOrderItemDao(this.orderItemDaoMock);
        itemProcessor.setOfferServiceUtilities((OfferServiceUtilities)offerServiceUtilities);
        this.offerService.setCustomerOfferDao(customerOfferDaoMock);
        this.offerService.setOfferCodeDao(offerCodeDaoMock);
        this.offerService.setOfferDao(this.offerDaoMock);
        this.offerService.setOrderOfferProcessor((OrderOfferProcessor)orderProcessor);
        this.offerService.setItemOfferProcessor((ItemOfferProcessor)itemProcessor);
        this.offerService.setFulfillmentGroupOfferProcessor((FulfillmentGroupOfferProcessor)this.fgProcessor);
        this.offerService.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        this.offerService.setOrderService(this.orderServiceMock);
    }

    public void replay() {
        EasyMock.replay((Object[])new Object[]{this.offerDaoMock});
        EasyMock.replay((Object[])new Object[]{this.orderItemDaoMock});
        EasyMock.replay((Object[])new Object[]{this.orderServiceMock});
        EasyMock.replay((Object[])new Object[]{this.orderItemServiceMock});
        EasyMock.replay((Object[])new Object[]{this.fgItemDaoMock});
        EasyMock.replay((Object[])new Object[]{this.fgServiceMock});
        EasyMock.replay((Object[])new Object[]{this.multishipOptionServiceMock});
        EasyMock.replay((Object[])new Object[]{this.offerTimeZoneProcessorMock});
    }

    public void verify() {
        EasyMock.verify((Object[])new Object[]{this.offerDaoMock});
        EasyMock.verify((Object[])new Object[]{this.orderItemDaoMock});
        EasyMock.verify((Object[])new Object[]{this.orderServiceMock});
        EasyMock.verify((Object[])new Object[]{this.orderItemServiceMock});
        EasyMock.verify((Object[])new Object[]{this.fgItemDaoMock});
        EasyMock.verify((Object[])new Object[]{this.fgServiceMock});
        EasyMock.verify((Object[])new Object[]{this.multishipOptionServiceMock});
        EasyMock.verify((Object[])new Object[]{this.offerTimeZoneProcessorMock});
    }

    public void testApplyAllFulfillmentGroupOffersWithOrderItemOffers() throws Exception {
        final ThreadLocal<Order> myOrder = new ThreadLocal<Order>();
        EasyMock.expect((Object)this.orderItemDaoMock.createOrderItemPriceDetail()).andAnswer(OfferDataItemProvider.getCreateOrderItemPriceDetailAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderItemDaoMock.createOrderItemQualifier()).andAnswer(OfferDataItemProvider.getCreateOrderItemQualifierAnswer()).atLeastOnce();
        EasyMock.expect((Object)this.fgServiceMock.addItemToFulfillmentGroup((FulfillmentGroupItemRequest)EasyMock.isA(FulfillmentGroupItemRequest.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getAddItemToFulfillmentGroupAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.removeItem((Long)EasyMock.isA(Long.class), (Long)EasyMock.isA(Long.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getRemoveItemFromOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.save((Order)EasyMock.isA(Order.class), (Boolean)EasyMock.isA(Boolean.class))).andAnswer(OfferDataItemProvider.getSaveOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.getAutomaticallyMergeLikeItems()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.orderItemServiceMock.saveOrderItem((OrderItem)EasyMock.isA(OrderItem.class))).andAnswer(OfferDataItemProvider.getSaveOrderItemAnswer()).anyTimes();
        EasyMock.expect((Object)this.fgItemDaoMock.save((FulfillmentGroupItem)EasyMock.isA(FulfillmentGroupItem.class))).andAnswer(OfferDataItemProvider.getSaveFulfillmentGroupItemAnswer()).anyTimes();
        EasyMock.expect((Object)this.offerDaoMock.createOrderItemPriceDetailAdjustment()).andAnswer(OfferDataItemProvider.getCreateOrderItemPriceDetailAdjustmentAnswer()).anyTimes();
        EasyMock.expect((Object)this.offerDaoMock.createFulfillmentGroupAdjustment()).andAnswer(OfferDataItemProvider.getCreateFulfillmentGroupAdjustmentAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.findOrderById((Long)EasyMock.isA(Long.class))).andAnswer((IAnswer)new IAnswer<Order>(){

            public Order answer() throws Throwable {
                return (Order)myOrder.get();
            }
        }).anyTimes();
        EasyMock.expect((Object)this.multishipOptionServiceMock.findOrderMultishipOptions((Long)EasyMock.isA(Long.class))).andAnswer((IAnswer)new IAnswer<List<OrderMultishipOption>>(){

            public List<OrderMultishipOption> answer() throws Throwable {
                ArrayList<OrderMultishipOption> options = new ArrayList<OrderMultishipOption>();
                PromotableOrder order = FulfillmentGroupOfferProcessorTest.this.dataProvider.createBasicPromotableOrder();
                for (FulfillmentGroup fg : order.getOrder().getFulfillmentGroups()) {
                    Address address = fg.getAddress();
                    for (FulfillmentGroupItem fgItem : fg.getFulfillmentGroupItems()) {
                        for (int j = 0; j < fgItem.getQuantity(); ++j) {
                            OrderMultishipOptionImpl option = new OrderMultishipOptionImpl();
                            option.setOrder(order.getOrder());
                            option.setAddress(address);
                            option.setOrderItem(fgItem.getOrderItem());
                            options.add((OrderMultishipOption)option);
                        }
                    }
                }
                return options;
            }
        }).anyTimes();
        this.multishipOptionServiceMock.deleteAllOrderMultishipOptions((Order)EasyMock.isA(Order.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)this.fgServiceMock.collapseToOneShippableFulfillmentGroup((Order)EasyMock.isA(Order.class), EasyMock.eq((boolean)false))).andAnswer((IAnswer)new IAnswer<Order>(){

            public Order answer() throws Throwable {
                Order order = (Order)EasyMock.getCurrentArguments()[0];
                ((FulfillmentGroup)order.getFulfillmentGroups().get(0)).getFulfillmentGroupItems().addAll(((FulfillmentGroup)order.getFulfillmentGroups().get(1)).getFulfillmentGroupItems());
                order.getFulfillmentGroups().remove(order.getFulfillmentGroups().get(1));
                return order;
            }
        }).anyTimes();
        EasyMock.expect((Object)this.fgItemDaoMock.create()).andAnswer(OfferDataItemProvider.getCreateFulfillmentGroupItemAnswer()).anyTimes();
        this.fgItemDaoMock.delete((FulfillmentGroupItem)EasyMock.isA(FulfillmentGroupItem.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)this.offerTimeZoneProcessorMock.getTimeZone((Offer)EasyMock.isA(OfferImpl.class))).andReturn((Object)TimeZone.getTimeZone("CST")).anyTimes();
        this.replay();
        PromotableOrder promotableOrder = this.dataProvider.createBasicPromotableOrder();
        Order order = promotableOrder.getOrder();
        myOrder.set(promotableOrder.getOrder());
        ArrayList qualifiedOffers = new ArrayList();
        List<Offer> offers = this.dataProvider.createFGBasedOffer("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF);
        offers.addAll(this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))"));
        offers.get(1).setName("secondOffer");
        offers.addAll(this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))"));
        this.offerService.applyOffersToOrder(offers, promotableOrder.getOrder());
        offers.get(0).setTotalitarianOffer(Boolean.valueOf(true));
        this.offerService.applyFulfillmentGroupOffersToOrder(offers, promotableOrder.getOrder());
        int fgAdjustmentCount = 0;
        for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
            fgAdjustmentCount += fg.getFulfillmentGroupAdjustments().size();
        }
        FulfillmentGroupOfferProcessorTest.assertTrue((fgAdjustmentCount == 1 ? 1 : 0) != 0);
        promotableOrder = this.dataProvider.createBasicPromotableOrder();
        myOrder.set(promotableOrder.getOrder());
        offers.get(2).setValue(new BigDecimal("1"));
        this.offerService.applyOffersToOrder(offers, promotableOrder.getOrder());
        this.offerService.applyFulfillmentGroupOffersToOrder(offers, promotableOrder.getOrder());
        fgAdjustmentCount = 0;
        order = promotableOrder.getOrder();
        for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
            fgAdjustmentCount += fg.getFulfillmentGroupAdjustments().size();
        }
        FulfillmentGroupOfferProcessorTest.assertTrue((fgAdjustmentCount == 2 ? 1 : 0) != 0);
        int itemAdjustmentCount = 0;
        for (OrderItem item : order.getOrderItems()) {
            for (OrderItemPriceDetail detail : item.getOrderItemPriceDetails()) {
                itemAdjustmentCount += detail.getOrderItemPriceDetailAdjustments().size();
            }
        }
        FulfillmentGroupOfferProcessorTest.assertTrue((itemAdjustmentCount == 0 ? 1 : 0) != 0);
        this.verify();
    }

    public void testApplyAllFulfillmentGroupOffers() {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicPromotableOrder();
        ArrayList qualifiedOffers = new ArrayList();
        List<Offer> offers = this.dataProvider.createFGBasedOffer("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF);
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(0));
        boolean offerApplied = this.fgProcessor.applyAllFulfillmentGroupOffers(qualifiedOffers, order);
        FulfillmentGroupOfferProcessorTest.assertTrue((boolean)offerApplied);
        order = this.dataProvider.createBasicPromotableOrder();
        qualifiedOffers = new ArrayList();
        offers = this.dataProvider.createFGBasedOffer("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF);
        offers.addAll(this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))"));
        offers.get(1).setName("secondOffer");
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(0));
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(1));
        offerApplied = this.fgProcessor.applyAllFulfillmentGroupOffers(qualifiedOffers, order);
        FulfillmentGroupOfferProcessorTest.assertTrue((boolean)offerApplied);
        int fgAdjustmentCount = 0;
        for (PromotableFulfillmentGroup fg : order.getFulfillmentGroups()) {
            fgAdjustmentCount += fg.getCandidateFulfillmentGroupAdjustments().size();
        }
        FulfillmentGroupOfferProcessorTest.assertTrue((fgAdjustmentCount == 3 ? 1 : 0) != 0);
        this.verify();
    }

    public void testFilterFulfillmentGroupLevelOffer() {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicPromotableOrder();
        ArrayList qualifiedOffers = new ArrayList();
        List<Offer> offers = this.dataProvider.createFGBasedOffer("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF);
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(0));
        FulfillmentGroupOfferProcessorTest.assertTrue((qualifiedOffers.size() == 2 && ((PromotableCandidateFulfillmentGroupOffer)qualifiedOffers.get(0)).getOffer().equals(offers.get(0)) ? 1 : 0) != 0);
        qualifiedOffers = new ArrayList();
        offers = this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(0));
        FulfillmentGroupOfferProcessorTest.assertTrue((qualifiedOffers.size() == 1 && ((PromotableCandidateFulfillmentGroupOffer)qualifiedOffers.get(0)).getOffer().equals(offers.get(0)) ? 1 : 0) != 0);
        qualifiedOffers = new ArrayList();
        offers = this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75240", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"),MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(0));
        FulfillmentGroupOfferProcessorTest.assertTrue((qualifiedOffers.size() == 0 ? 1 : 0) != 0);
        qualifiedOffers = new ArrayList();
        offers = this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test5\"),MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(0));
        FulfillmentGroupOfferProcessorTest.assertTrue((qualifiedOffers.size() == 0 ? 1 : 0) != 0);
        this.verify();
    }

    public void testCouldOfferApplyToFulfillmentGroup() {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicPromotableOrder();
        List<Offer> offers = this.dataProvider.createFGBasedOffer("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF);
        boolean couldApply = this.fgProcessor.couldOfferApplyToFulfillmentGroup(offers.get(0), (PromotableFulfillmentGroup)order.getFulfillmentGroups().get(0));
        FulfillmentGroupOfferProcessorTest.assertTrue((boolean)couldApply);
        offers = this.dataProvider.createFGBasedOffer("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75240", OfferDiscountType.PERCENT_OFF);
        couldApply = this.fgProcessor.couldOfferApplyToFulfillmentGroup(offers.get(0), (PromotableFulfillmentGroup)order.getFulfillmentGroups().get(0));
        FulfillmentGroupOfferProcessorTest.assertFalse((boolean)couldApply);
        this.verify();
    }

    public void testCouldOrderItemMeetOfferRequirement() {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicPromotableOrder();
        List<Offer> offers = this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        boolean couldApply = this.fgProcessor.couldOrderItemMeetOfferRequirement((OfferItemCriteria)offers.get(0).getQualifyingItemCriteria().iterator().next(), (PromotableOrderItem)order.getDiscountableOrderItems().get(0));
        FulfillmentGroupOfferProcessorTest.assertTrue((boolean)couldApply);
        offers = this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        couldApply = this.fgProcessor.couldOrderItemMeetOfferRequirement((OfferItemCriteria)offers.get(0).getQualifyingItemCriteria().iterator().next(), (PromotableOrderItem)order.getDiscountableOrderItems().get(0));
        FulfillmentGroupOfferProcessorTest.assertFalse((boolean)couldApply);
        this.verify();
    }

    public void testCouldOfferApplyToOrderItems() {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicPromotableOrder();
        ArrayList<PromotableOrderItem> orderItems = new ArrayList<PromotableOrderItem>();
        for (PromotableOrderItem orderItem : order.getDiscountableOrderItems()) {
            orderItems.add(orderItem);
        }
        List<Offer> offers = this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        CandidatePromotionItems candidates = this.fgProcessor.couldOfferApplyToOrderItems(offers.get(0), orderItems);
        FulfillmentGroupOfferProcessorTest.assertTrue((candidates.isMatchedQualifier() && candidates.getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        offers = this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        candidates = this.fgProcessor.couldOfferApplyToOrderItems(offers.get(0), orderItems);
        FulfillmentGroupOfferProcessorTest.assertFalse((candidates.isMatchedQualifier() && candidates.getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        this.verify();
    }

    public class OrderItemAdjustmentAnswer
    implements IAnswer<OrderItemAdjustment> {
        public OrderItemAdjustment answer() throws Throwable {
            return new OrderItemAdjustmentImpl();
        }
    }

    public class CandidateItemOfferAnswer
    implements IAnswer<CandidateItemOffer> {
        public CandidateItemOffer answer() throws Throwable {
            return new CandidateItemOfferImpl();
        }
    }

    public class FulfillmentGroupAdjustmentAnswer
    implements IAnswer<FulfillmentGroupAdjustment> {
        public FulfillmentGroupAdjustment answer() throws Throwable {
            return new FulfillmentGroupAdjustmentImpl();
        }
    }

    public class CandidateFulfillmentGroupOfferAnswer
    implements IAnswer<CandidateFulfillmentGroupOffer> {
        public CandidateFulfillmentGroupOffer answer() throws Throwable {
            return new CandidateFulfillmentGroupOfferImpl();
        }
    }
}

