/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.domain;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXrefImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.offer.domain.CandidateItemOfferImpl;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.service.OfferDataItemProvider;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOfferImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactoryImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetail;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetailImpl;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetailImpl;
import org.broadleafcommerce.core.order.service.type.OrderItemType;

public class CandidateItemOfferTest
extends TestCase {
    private PromotableCandidateItemOffer promotableCandidate;
    private Offer offer;
    private PromotableCandidateItemOffer candidateOffer;
    private PromotableOrderItem promotableOrderItem;
    private PromotableOrder promotableOrder;
    private PromotableOrderItemPriceDetail priceDetail;

    protected void setUp() throws Exception {
        OfferDataItemProvider dataProvider = new OfferDataItemProvider();
        CandidateItemOfferImpl candidate = new CandidateItemOfferImpl();
        CategoryImpl category1 = new CategoryImpl();
        category1.setName("test1");
        category1.setId(Long.valueOf(1L));
        ProductImpl product1 = new ProductImpl();
        SkuImpl sku1 = new SkuImpl();
        sku1.setName("test1");
        sku1.setDiscountable(Boolean.valueOf(true));
        sku1.setRetailPrice(new Money(19.99));
        product1.setDefaultSku((Sku)sku1);
        CategoryProductXrefImpl xref1 = new CategoryProductXrefImpl();
        xref1.setProduct((Product)product1);
        xref1.setCategory((Category)category1);
        category1.getAllProductXrefs().add(xref1);
        CategoryImpl category2 = new CategoryImpl();
        category2.setName("test2");
        category2.setId(Long.valueOf(2L));
        ProductImpl product2 = new ProductImpl();
        SkuImpl sku2 = new SkuImpl();
        sku2.setName("test2");
        sku2.setDiscountable(Boolean.valueOf(true));
        sku2.setRetailPrice(new Money(29.99));
        product2.setDefaultSku((Sku)sku2);
        CategoryProductXrefImpl xref2 = new CategoryProductXrefImpl();
        xref2.setProduct((Product)product2);
        xref2.setCategory((Category)category2);
        category2.getAllProductXrefs().add(xref2);
        DiscreteOrderItemImpl orderItem1 = new DiscreteOrderItemImpl();
        orderItem1.setCategory((Category)category1);
        orderItem1.setName("test1");
        orderItem1.setOrderItemType(OrderItemType.DISCRETE);
        orderItem1.setProduct((Product)product1);
        orderItem1.setQuantity(2);
        orderItem1.setSku((Sku)sku1);
        OrderImpl order = new OrderImpl();
        orderItem1.setOrder((Order)order);
        this.promotableOrder = new PromotableOrderImpl((Order)order, (PromotableItemFactory)new PromotableItemFactoryImpl(), false);
        this.offer = dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))").get(0);
        this.candidateOffer = new PromotableCandidateItemOfferImpl(this.promotableOrder, this.offer);
        this.promotableOrderItem = new PromotableOrderItemImpl((OrderItem)orderItem1, null, (PromotableItemFactory)new PromotableItemFactoryImpl(), false);
        OrderItemPriceDetailImpl pdetail = new OrderItemPriceDetailImpl();
        pdetail.setOrderItem((OrderItem)orderItem1);
        pdetail.setQuantity(2);
        this.priceDetail = new PromotableOrderItemPriceDetailImpl(this.promotableOrderItem, 2);
        ArrayList<PromotableOrderItem> items = new ArrayList<PromotableOrderItem>();
        items.add(this.promotableOrderItem);
        this.promotableCandidate = new PromotableCandidateItemOfferImpl(this.promotableOrder, this.offer);
        this.promotableCandidate.getCandidateTargetsMap().put(this.offer.getTargetItemCriteria().iterator().next(), items);
    }

    public void testCalculateSavingsForOrderItem() throws Exception {
        Money savings = this.promotableCandidate.calculateSavingsForOrderItem(this.promotableOrderItem, 1);
        CandidateItemOfferTest.assertTrue((boolean)savings.equals((Object)new Money(2.0)));
        this.offer.setDiscountType(OfferDiscountType.AMOUNT_OFF);
        savings = this.promotableCandidate.calculateSavingsForOrderItem(this.promotableOrderItem, 1);
        CandidateItemOfferTest.assertTrue((boolean)savings.equals((Object)new Money(10.0)));
        this.offer.setDiscountType(OfferDiscountType.FIX_PRICE);
        savings = this.promotableCandidate.calculateSavingsForOrderItem(this.promotableOrderItem, 1);
        CandidateItemOfferTest.assertTrue((boolean)savings.equals((Object)new Money(9.989999999999998)));
    }

    public void testCalculateMaximumNumberOfUses() throws Exception {
        int maxOfferUses = this.promotableCandidate.calculateMaximumNumberOfUses();
        CandidateItemOfferTest.assertTrue((maxOfferUses == 2 ? 1 : 0) != 0);
        this.offer.setMaxUses(1);
        maxOfferUses = this.promotableCandidate.calculateMaximumNumberOfUses();
        CandidateItemOfferTest.assertTrue((maxOfferUses == 1 ? 1 : 0) != 0);
    }

    public void testCalculateMaxUsesForItemCriteria() throws Exception {
        int maxItemCriteriaUses = 9999;
        for (OfferItemCriteria targetCriteria : this.offer.getTargetItemCriteria()) {
            int temp = this.promotableCandidate.calculateMaxUsesForItemCriteria(targetCriteria, this.offer);
            maxItemCriteriaUses = Math.min(maxItemCriteriaUses, temp);
        }
        CandidateItemOfferTest.assertTrue((maxItemCriteriaUses == 2 ? 1 : 0) != 0);
    }
}

