/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.workflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.broadleafcommerce.common.logging.LifeCycleEvent;
import org.broadleafcommerce.common.logging.SupportLogManager;
import org.broadleafcommerce.common.logging.SupportLogger;
import org.broadleafcommerce.core.workflow.Activity;
import org.broadleafcommerce.core.workflow.ErrorHandler;
import org.broadleafcommerce.core.workflow.ModuleActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.Processor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.OrderComparator;

public abstract class BaseProcessor
implements InitializingBean,
BeanNameAware,
BeanFactoryAware,
Processor {
    protected BeanFactory beanFactory;
    protected String beanName;
    protected List<Activity<ProcessContext<? extends Object>>> activities = new ArrayList<Activity<ProcessContext<? extends Object>>>();
    protected List<ModuleActivity> moduleActivities = new ArrayList<ModuleActivity>();
    protected ErrorHandler defaultErrorHandler;
    @Value(value="${workflow.auto.rollback.on.error}")
    private boolean autoRollbackOnError = true;
    protected boolean allowEmptyActivities = false;
    protected SupportLogger supportLogger = SupportLogManager.getLogger((String)"Workflows", BaseProcessor.class);

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public boolean getAutoRollbackOnError() {
        return this.autoRollbackOnError;
    }

    public void setAutoRollbackOnError(boolean autoRollbackOnError) {
        this.autoRollbackOnError = autoRollbackOnError;
    }

    public boolean isAllowEmptyActivities() {
        return this.allowEmptyActivities;
    }

    public void setAllowEmptyActivities(boolean allowEmptyActivities) {
        this.allowEmptyActivities = allowEmptyActivities;
    }

    public void afterPropertiesSet() throws Exception {
        if (!(this.beanFactory instanceof ListableBeanFactory)) {
            throw new BeanInitializationException("The workflow processor [" + this.beanName + "] " + "is not managed by a ListableBeanFactory, please re-deploy using some derivative of ListableBeanFactory such as" + "ClassPathXmlApplicationContext ");
        }
        if (CollectionUtils.isEmpty(this.activities) && !this.isAllowEmptyActivities()) {
            throw new UnsatisfiedDependencyException(this.getBeanDesc(), this.beanName, "activities", "No activities were wired for this workflow");
        }
        OrderComparator.sort(this.activities);
        HashSet<String> moduleNames = new HashSet<String>();
        for (Activity<ProcessContext<? extends Object>> activity : this.activities) {
            if (!this.supports(activity)) {
                throw new BeanInitializationException("The workflow processor [" + this.beanName + "] does " + "not support the activity of type" + activity.getClass().getName());
            }
            if (!(activity instanceof ModuleActivity)) continue;
            this.moduleActivities.add((ModuleActivity)((Object)activity));
            moduleNames.add(((ModuleActivity)((Object)activity)).getModuleName());
        }
        if (CollectionUtils.isNotEmpty(this.moduleActivities)) {
            StringBuffer message = new StringBuffer();
            message.append("The following modules have made changes to the " + this.getBeanName() + " workflow: ");
            message.append(Arrays.toString(moduleNames.toArray()));
            message.append("\n");
            message.append("The final ordering of activities for the " + this.getBeanName() + " workflow is: \n");
            ArrayList activityNames = new ArrayList();
            CollectionUtils.collect(this.activities, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return ((Activity)input).getBeanName();
                }
            }, activityNames);
            message.append(Arrays.toString(activityNames.toArray()));
            this.supportLogger.lifecycle(LifeCycleEvent.CONFIG, (Object)message.toString());
        }
    }

    protected String getBeanDesc() {
        return this.beanFactory instanceof ConfigurableListableBeanFactory ? ((ConfigurableListableBeanFactory)this.beanFactory).getBeanDefinition(this.beanName).getResourceDescription() : "Workflow Processor: " + this.beanName;
    }

    public void setActivities(List<Activity<ProcessContext<? extends Object>>> activities) {
        this.activities = activities;
    }

    @Override
    public void setDefaultErrorHandler(ErrorHandler defaultErrorHandler) {
        this.defaultErrorHandler = defaultErrorHandler;
    }

    public List<Activity<ProcessContext<? extends Object>>> getActivities() {
        return this.activities;
    }

    public List<ModuleActivity> getModuleActivities() {
        return this.moduleActivities;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public ErrorHandler getDefaultErrorHandler() {
        return this.defaultErrorHandler;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }
}

