/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.store.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.core.store.dao.StoreDao;
import org.broadleafcommerce.core.store.domain.Store;
import org.broadleafcommerce.core.store.domain.ZipCode;
import org.broadleafcommerce.core.store.service.StoreService;
import org.broadleafcommerce.core.store.service.ZipCodeService;
import org.broadleafcommerce.profile.core.domain.Address;
import org.springframework.stereotype.Service;

@Service(value="blStoreService")
public class StoreServiceImpl
implements StoreService {
    @Resource(name="blStoreDao")
    private StoreDao storeDao;
    @Resource(name="blZipCodeService")
    private ZipCodeService zipCodeService;

    @Override
    public Store readStoreById(Long id) {
        return this.storeDao.readStoreById(id);
    }

    @Override
    public Store readStoreByStoreName(String storeName) {
        return this.storeDao.readStoreByStoreName(storeName);
    }

    @Override
    public Store readStoreByStoreCode(String storeCode) {
        return this.storeDao.readStoreByStoreCode(storeCode);
    }

    @Override
    public List<Store> readAllStores() {
        return this.storeDao.readAllStores();
    }

    @Override
    public List<Store> readAllStoresByState(String state) {
        return this.storeDao.readAllStoresByState(state);
    }

    @Override
    public Map<Store, Double> findStoresByAddress(Address searchAddress, double distance) {
        HashMap<Store, Double> matchingStores = new HashMap<Store, Double>();
        for (Store store : this.readAllStores()) {
            Double storeDistance = this.findStoreDistance(store, Integer.parseInt(searchAddress.getPostalCode()));
            if (storeDistance == null || !(storeDistance <= distance)) continue;
            matchingStores.put(store, storeDistance);
        }
        return matchingStores;
    }

    private Double findStoreDistance(Store store, Integer zip) {
        ZipCode zipCode = this.zipCodeService.findZipCodeByZipCode(zip);
        if (zipCode == null) {
            return null;
        }
        double degreesToRadians = 57.3;
        double storeDistance = 3959.0 * Math.acos(Math.sin(zipCode.getZipLatitude() / degreesToRadians) * Math.sin(store.getLatitude() / degreesToRadians) + Math.cos(zipCode.getZipLatitude() / degreesToRadians) * Math.cos(store.getLatitude() / degreesToRadians) * Math.cos(store.getLongitude() / degreesToRadians - zipCode.getZipLongitude() / degreesToRadians));
        return storeDistance;
    }
}

