/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.Group;
import org.apache.solr.client.solrj.response.GroupCommand;
import org.apache.solr.client.solrj.response.GroupResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.util.BLCMapUtils;
import org.broadleafcommerce.common.util.TypedClosure;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.search.dao.FieldDao;
import org.broadleafcommerce.core.search.dao.SearchFacetDao;
import org.broadleafcommerce.core.search.domain.CategorySearchFacet;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.ProductSearchCriteria;
import org.broadleafcommerce.core.search.domain.ProductSearchResult;
import org.broadleafcommerce.core.search.domain.RequiredFacet;
import org.broadleafcommerce.core.search.domain.SearchFacet;
import org.broadleafcommerce.core.search.domain.SearchFacetDTO;
import org.broadleafcommerce.core.search.domain.SearchFacetRange;
import org.broadleafcommerce.core.search.domain.SearchFacetResultDTO;
import org.broadleafcommerce.core.search.domain.solr.FieldType;
import org.broadleafcommerce.core.search.service.SearchService;
import org.broadleafcommerce.core.search.service.solr.SolrContext;
import org.broadleafcommerce.core.search.service.solr.SolrHelperService;
import org.broadleafcommerce.core.search.service.solr.SolrIndexService;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionHandler;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionManager;
import org.springframework.beans.factory.DisposableBean;
import org.xml.sax.SAXException;

public class SolrSearchServiceImpl
implements SearchService,
DisposableBean {
    private static final Log LOG = LogFactory.getLog(SolrSearchServiceImpl.class);
    @Resource(name="blProductDao")
    protected ProductDao productDao;
    @Resource(name="blFieldDao")
    protected FieldDao fieldDao;
    @Resource(name="blSearchFacetDao")
    protected SearchFacetDao searchFacetDao;
    @Resource(name="blSolrHelperService")
    protected SolrHelperService shs;
    @Resource(name="blSolrIndexService")
    protected SolrIndexService solrIndexService;
    @Resource(name="blSolrSearchServiceExtensionManager")
    protected SolrSearchServiceExtensionManager extensionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrSearchServiceImpl(String solrServer) throws IOException, ParserConfigurationException, SAXException {
        if ("solrhome".equals(solrServer)) {
            String baseTempPath = System.getProperty("java.io.tmpdir");
            File tempDir = new File(baseTempPath + File.separator + System.getProperty("user.name") + File.separator + "solrhome");
            if (System.getProperty("tmpdir.solrhome") != null) {
                tempDir = new File(System.getProperty("tmpdir.solrhome"));
            }
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            solrServer = tempDir.getAbsolutePath();
        }
        File solrXml = this.copyConfigToSolrHome(this.getClass().getResourceAsStream("/solr-default.xml"), solrServer, "solr-default.xml");
        LOG.debug((Object)String.format("Using [%s] as solrhome", solrServer));
        LOG.debug((Object)String.format("Using [%s] as solr.xml", solrXml.getAbsoluteFile()));
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Contents of solr.xml:");
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new FileReader(solrXml));
                while ((line = br.readLine()) != null) {
                    LOG.trace((Object)line);
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable e) {}
                }
            }
            LOG.trace((Object)"Done printing solr.xml");
        }
        CoreContainer coreContainer = CoreContainer.createAndLoad((String)solrServer, (File)solrXml);
        EmbeddedSolrServer primaryServer = new EmbeddedSolrServer(coreContainer, "primary");
        EmbeddedSolrServer reindexServer = new EmbeddedSolrServer(coreContainer, "reindex");
        SolrContext.setPrimaryServer((SolrServer)primaryServer);
        SolrContext.setReindexServer((SolrServer)reindexServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File copyConfigToSolrHome(InputStream configIs, String parentDir, String configFileSimpleName) throws IOException {
        File destFile = new File(new File(parentDir), configFileSimpleName);
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            bis = new BufferedInputStream(configIs);
            bos = new BufferedOutputStream(new FileOutputStream(destFile, false));
            boolean eof = false;
            while (!eof) {
                int temp = bis.read();
                if (temp == -1) {
                    eof = true;
                    continue;
                }
                ((BufferedOutputStream)bos).write(temp);
            }
            ((BufferedOutputStream)bos).flush();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Throwable e) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Throwable e) {}
            }
        }
        return destFile;
    }

    public SolrSearchServiceImpl(SolrServer solrServer) {
        SolrContext.setPrimaryServer(solrServer);
    }

    public SolrSearchServiceImpl(String solrServer, String reindexServer) throws IOException, ParserConfigurationException, SAXException {
        this(solrServer);
    }

    public SolrSearchServiceImpl(SolrServer solrServer, SolrServer reindexServer) {
        SolrContext.setPrimaryServer(solrServer);
        SolrContext.setReindexServer(reindexServer);
    }

    @Override
    public void rebuildIndex() throws ServiceException, IOException {
        this.solrIndexService.rebuildIndex();
    }

    public void destroy() throws Exception {
        if (SolrContext.getServer() instanceof EmbeddedSolrServer) {
            ((EmbeddedSolrServer)SolrContext.getServer()).shutdown();
        }
    }

    @Override
    public ProductSearchResult findExplicitProductsByCategory(Category category, ProductSearchCriteria searchCriteria) throws ServiceException {
        List<SearchFacetDTO> facets = this.getCategoryFacets(category);
        String query = this.shs.getExplicitCategoryFieldName() + ":" + this.shs.getCategoryId(category.getId());
        return this.findProducts("*:*", facets, searchCriteria, this.shs.getCategorySortFieldName(category) + " asc", query);
    }

    @Override
    public ProductSearchResult findProductsByCategory(Category category, ProductSearchCriteria searchCriteria) throws ServiceException {
        List<SearchFacetDTO> facets = this.getCategoryFacets(category);
        String query = this.shs.getCategoryFieldName() + ":" + this.shs.getCategoryId(category.getId());
        return this.findProducts("*:*", facets, searchCriteria, this.shs.getCategorySortFieldName(category) + " asc", query);
    }

    @Override
    public ProductSearchResult findProductsByQuery(String query, ProductSearchCriteria searchCriteria) throws ServiceException {
        List<SearchFacetDTO> facets = this.getSearchFacets();
        query = "(" + this.sanitizeQuery(query) + ")";
        return this.findProducts(query, facets, searchCriteria, null);
    }

    @Override
    public ProductSearchResult findProductsByCategoryAndQuery(Category category, String query, ProductSearchCriteria searchCriteria) throws ServiceException {
        List<SearchFacetDTO> facets = this.getSearchFacets();
        String catFq = this.shs.getCategoryFieldName() + ":" + this.shs.getCategoryId(category.getId());
        query = "(" + this.sanitizeQuery(query) + ")";
        return this.findProducts(query, facets, searchCriteria, null, catFq);
    }

    public String getLocalePrefix() {
        Locale locale;
        if (BroadleafRequestContext.getBroadleafRequestContext() != null && (locale = BroadleafRequestContext.getBroadleafRequestContext().getLocale()) != null) {
            return locale.getLocaleCode() + "_";
        }
        return "";
    }

    protected String buildQueryFieldsString() {
        StringBuilder queryBuilder = new StringBuilder();
        List<Field> fields = this.fieldDao.readAllProductFields();
        for (Field currentField : fields) {
            if (!currentField.getSearchable().booleanValue()) continue;
            this.appendFieldToQuery(queryBuilder, currentField);
        }
        return queryBuilder.toString();
    }

    protected void appendFieldToQuery(StringBuilder queryBuilder, Field currentField) {
        List<FieldType> searchableFieldTypes = this.shs.getSearchableFieldTypes(currentField);
        for (FieldType currentType : searchableFieldTypes) {
            queryBuilder.append(this.shs.getPropertyNameForFieldSearchable(currentField, currentType)).append(" ");
        }
    }

    protected ProductSearchResult findProducts(String qualifiedSolrQuery, List<SearchFacetDTO> facets, ProductSearchCriteria searchCriteria, String defaultSort) throws ServiceException {
        return this.findProducts(qualifiedSolrQuery, facets, searchCriteria, defaultSort, null);
    }

    protected ProductSearchResult findProducts(String qualifiedSolrQuery, List<SearchFacetDTO> facets, ProductSearchCriteria searchCriteria, String defaultSort, String ... filterQueries) throws ServiceException {
        List<SolrDocument> responseDocuments;
        QueryResponse response;
        Map<String, SearchFacetDTO> namedFacetMap = this.getNamedFacetMap(facets, searchCriteria);
        SolrQuery solrQuery = new SolrQuery().setQuery(qualifiedSolrQuery).setFields(new String[]{this.shs.getProductIdFieldName()}).setRows(searchCriteria.getPageSize()).setStart(Integer.valueOf((searchCriteria.getPage() - 1) * searchCriteria.getPageSize()));
        if (filterQueries != null) {
            solrQuery.setFilterQueries(filterQueries);
        }
        solrQuery.addFilterQuery(new String[]{this.shs.getNamespaceFieldName() + ":(\"" + this.shs.getCurrentNamespace() + "\")"});
        solrQuery.set("defType", new String[]{"edismax"});
        solrQuery.set("qf", new String[]{this.buildQueryFieldsString()});
        this.attachSortClause(solrQuery, searchCriteria, defaultSort);
        this.attachActiveFacetFilters(solrQuery, namedFacetMap, searchCriteria);
        this.attachFacets(solrQuery, namedFacetMap);
        ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).modifySolrQuery(solrQuery, qualifiedSolrQuery, facets, searchCriteria, defaultSort);
        if (LOG.isTraceEnabled()) {
            try {
                LOG.trace((Object)URLDecoder.decode(solrQuery.toString(), "UTF-8"));
            }
            catch (Exception e) {
                LOG.trace((Object)("Couldn't UTF-8 URL Decode: " + solrQuery.toString()));
            }
        }
        try {
            response = SolrContext.getServer().query((SolrParams)solrQuery);
            responseDocuments = this.getResponseDocuments(response);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)response.toString());
                for (SolrDocument doc : responseDocuments) {
                    LOG.trace((Object)doc);
                }
            }
        }
        catch (SolrServerException e) {
            throw new ServiceException("Could not perform search", (Throwable)e);
        }
        this.setFacetResults(namedFacetMap, response);
        this.sortFacetResults(namedFacetMap);
        List<Product> products = this.getProducts(responseDocuments);
        ProductSearchResult result = new ProductSearchResult();
        result.setFacets(facets);
        result.setProducts(products);
        this.setPagingAttributes(result, responseDocuments, searchCriteria);
        return result;
    }

    protected List<SolrDocument> getResponseDocuments(QueryResponse response) {
        Object docs;
        if (response.getGroupResponse() == null) {
            docs = response.getResults();
        } else {
            docs = new ArrayList();
            GroupResponse gr = response.getGroupResponse();
            for (GroupCommand gc : gr.getValues()) {
                for (Group g : gc.getValues()) {
                    for (SolrDocument d : g.getResult()) {
                        docs.add(d);
                    }
                }
            }
        }
        return docs;
    }

    @Override
    public List<SearchFacetDTO> getSearchFacets() {
        return this.buildSearchFacetDTOs(this.searchFacetDao.readAllSearchFacets());
    }

    @Override
    public List<SearchFacetDTO> getCategoryFacets(Category category) {
        List<CategorySearchFacet> categorySearchFacets = category.getCumulativeSearchFacets();
        ArrayList<SearchFacet> searchFacets = new ArrayList<SearchFacet>();
        for (CategorySearchFacet categorySearchFacet : categorySearchFacets) {
            searchFacets.add(categorySearchFacet.getSearchFacet());
        }
        return this.buildSearchFacetDTOs(searchFacets);
    }

    protected void attachSortClause(SolrQuery query, ProductSearchCriteria searchCriteria, String defaultSort) {
        Map<String, String> solrFieldKeyMap = this.getSolrFieldKeyMap(searchCriteria);
        String sortQuery = searchCriteria.getSortQuery();
        if (StringUtils.isBlank((String)sortQuery)) {
            sortQuery = defaultSort;
        }
        if (StringUtils.isNotBlank((String)sortQuery)) {
            String[] sortFields;
            for (String sortField : sortFields = sortQuery.split(",")) {
                SolrQuery.ORDER order;
                String field = sortField.split(" ")[0];
                if (solrFieldKeyMap.containsKey(field)) {
                    field = solrFieldKeyMap.get(field);
                }
                SolrQuery.ORDER oRDER = order = "desc".equals(sortField.split(" ")[1]) ? SolrQuery.ORDER.desc : SolrQuery.ORDER.asc;
                if (field == null) continue;
                query.addSortField(field, order);
            }
        }
    }

    protected void attachActiveFacetFilters(SolrQuery query, Map<String, SearchFacetDTO> namedFacetMap, ProductSearchCriteria searchCriteria) {
        for (Map.Entry<String, String[]> entry : searchCriteria.getFilterCriteria().entrySet()) {
            String solrKey = null;
            for (Map.Entry<String, SearchFacetDTO> dtoEntry : namedFacetMap.entrySet()) {
                if (!dtoEntry.getValue().getFacet().getField().getAbbreviation().equals(entry.getKey())) continue;
                solrKey = dtoEntry.getKey();
                dtoEntry.getValue().setActive(true);
            }
            if (solrKey == null) continue;
            String solrTag = this.getSolrFieldTag(this.shs.getGlobalFacetTagField(), "tag");
            Object[] selectedValues = (String[])entry.getValue().clone();
            for (int i = 0; i < selectedValues.length; ++i) {
                if (selectedValues[i].contains("range[")) {
                    String rangeValue = ((String)selectedValues[i]).substring(((String)selectedValues[i]).indexOf(91) + 1, ((String)selectedValues[i]).indexOf(93));
                    String[] rangeValues = StringUtils.split((String)rangeValue, (char)':');
                    if (rangeValues[1].equals("null")) {
                        rangeValues[1] = "*";
                    }
                    selectedValues[i] = solrKey + ":[" + rangeValues[0] + " TO " + rangeValues[1] + "]";
                    continue;
                }
                selectedValues[i] = solrKey + ":\"" + (String)selectedValues[i] + "\"";
            }
            String valueString = StringUtils.join((Object[])selectedValues, (String)" OR ");
            StringBuilder sb = new StringBuilder();
            sb.append(solrTag).append("(").append(valueString).append(")");
            query.addFilterQuery(new String[]{sb.toString()});
        }
    }

    protected void attachFacets(SolrQuery query, Map<String, SearchFacetDTO> namedFacetMap) {
        query.setFacet(true);
        for (Map.Entry<String, SearchFacetDTO> entry : namedFacetMap.entrySet()) {
            SearchFacetDTO dto = entry.getValue();
            String facetTagField = entry.getValue().isActive() ? this.shs.getGlobalFacetTagField() : entry.getKey();
            ArrayList<SearchFacetRange> facetRanges = new ArrayList<SearchFacetRange>(dto.getFacet().getSearchFacetRanges());
            if (this.extensionManager != null) {
                ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).filterSearchFacetRanges(dto, facetRanges);
            }
            if (facetRanges != null && facetRanges.size() > 0) {
                for (SearchFacetRange range : facetRanges) {
                    query.addFacetQuery(this.getSolrTaggedFieldString(entry.getKey(), facetTagField, "ex", range));
                }
                continue;
            }
            query.addFacetField(new String[]{this.getSolrTaggedFieldString(entry.getKey(), facetTagField, "ex", null)});
        }
    }

    protected void setFacetResults(Map<String, SearchFacetDTO> namedFacetMap, QueryResponse response) {
        if (response.getFacetFields() != null) {
            for (FacetField facetField : response.getFacetFields()) {
                String facetFieldName = facetField.getName();
                SearchFacetDTO facetDTO = namedFacetMap.get(facetFieldName);
                for (FacetField.Count value : facetField.getValues()) {
                    SearchFacetResultDTO resultDTO = new SearchFacetResultDTO();
                    resultDTO.setFacet(facetDTO.getFacet());
                    resultDTO.setQuantity(new Long(value.getCount()).intValue());
                    resultDTO.setValue(value.getName());
                    facetDTO.getFacetValues().add(resultDTO);
                }
            }
        }
        if (response.getFacetQuery() != null) {
            for (Map.Entry entry : response.getFacetQuery().entrySet()) {
                String key = (String)entry.getKey();
                String facetFieldName = key.substring(key.indexOf("}") + 1, key.indexOf(58));
                SearchFacetDTO facetDTO = namedFacetMap.get(facetFieldName);
                String minValue = key.substring(key.indexOf("[") + 1, key.indexOf(" TO"));
                String maxValue = key.substring(key.indexOf(" TO ") + 4, key.indexOf("]"));
                if (maxValue.equals("*")) {
                    maxValue = null;
                }
                SearchFacetResultDTO resultDTO = new SearchFacetResultDTO();
                resultDTO.setFacet(facetDTO.getFacet());
                resultDTO.setQuantity((Integer)entry.getValue());
                resultDTO.setMinValue(new BigDecimal(minValue));
                resultDTO.setMaxValue(maxValue == null ? null : new BigDecimal(maxValue));
                facetDTO.getFacetValues().add(resultDTO);
            }
        }
    }

    protected void sortFacetResults(Map<String, SearchFacetDTO> namedFacetMap) {
        for (Map.Entry<String, SearchFacetDTO> entry : namedFacetMap.entrySet()) {
            Collections.sort(entry.getValue().getFacetValues(), new Comparator<SearchFacetResultDTO>(){

                @Override
                public int compare(SearchFacetResultDTO o1, SearchFacetResultDTO o2) {
                    if (o1.getValue() != null && o2.getValue() != null) {
                        return o1.getValue().compareTo(o2.getValue());
                    }
                    if (o1.getMinValue() != null && o2.getMinValue() != null) {
                        return o1.getMinValue().compareTo(o2.getMinValue());
                    }
                    return 0;
                }
            });
        }
    }

    public void setPagingAttributes(ProductSearchResult result, List<SolrDocument> responseDocuments, ProductSearchCriteria searchCriteria) {
        result.setTotalResults(responseDocuments.size());
        result.setPage(searchCriteria.getPage());
        result.setPageSize(searchCriteria.getPageSize());
    }

    protected List<Product> getProducts(List<SolrDocument> responseDocuments) {
        final ArrayList<Long> productIds = new ArrayList<Long>();
        for (SolrDocument doc : responseDocuments) {
            productIds.add((Long)doc.getFieldValue(this.shs.getProductIdFieldName()));
        }
        List<Product> products = this.productDao.readProductsByIds(productIds);
        if (products != null) {
            Collections.sort(products, new Comparator<Product>(){

                @Override
                public int compare(Product o1, Product o2) {
                    return new Integer(productIds.indexOf(o1.getId())).compareTo(productIds.indexOf(o2.getId()));
                }
            });
        }
        return products;
    }

    protected List<SearchFacetDTO> buildSearchFacetDTOs(List<SearchFacet> searchFacets) {
        ArrayList<SearchFacetDTO> facets = new ArrayList<SearchFacetDTO>();
        Map requestParameters = BroadleafRequestContext.getRequestParameterMap();
        for (SearchFacet facet : searchFacets) {
            if (!this.facetIsAvailable(facet, requestParameters)) continue;
            SearchFacetDTO dto = new SearchFacetDTO();
            dto.setFacet(facet);
            dto.setShowQuantity(true);
            facets.add(dto);
        }
        return facets;
    }

    protected boolean facetIsAvailable(SearchFacet facet, Map<String, String[]> params) {
        if (CollectionUtils.isEmpty(facet.getRequiredFacets())) {
            return true;
        }
        if (MapUtils.isEmpty(params)) {
            return false;
        }
        int requiredMatches = facet.getRequiresAllDependentFacets() != false ? facet.getRequiredFacets().size() : 1;
        int matchesSoFar = 0;
        block0: for (RequiredFacet requiredFacet : facet.getRequiredFacets()) {
            if (requiredMatches == matchesSoFar) {
                return true;
            }
            for (Map.Entry<String, String[]> entry : params.entrySet()) {
                String key = entry.getKey();
                if (!key.equals(requiredFacet.getRequiredFacet().getField().getAbbreviation())) continue;
                ++matchesSoFar;
                continue block0;
            }
        }
        return requiredMatches == matchesSoFar;
    }

    protected String sanitizeQuery(String query) {
        return query.replace("(", "").replace("%28", "").replace(")", "").replace("%29", "").replace(":", "").replace("%3A", "").replace("%3a", "").replace("&quot;", "\"");
    }

    protected String getSolrFieldString(String indexField, SearchFacetRange range) {
        StringBuilder sb = new StringBuilder();
        sb.append(indexField);
        if (range != null) {
            String minValue = range.getMinValue().toPlainString();
            String maxValue = range.getMaxValue() == null ? "*" : range.getMaxValue().toPlainString();
            sb.append(":[").append(minValue).append(" TO ").append(maxValue).append("]");
        }
        return sb.toString();
    }

    protected String getSolrTaggedFieldString(String indexField, String tagField, String tag, SearchFacetRange range) {
        return this.getSolrFieldTag(tagField, tag) + this.getSolrFieldString(indexField, range);
    }

    protected String getSolrFieldTag(String tagField, String tag) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)tag)) {
            sb.append("{!").append(tag).append("=").append(tagField).append("}");
        }
        return sb.toString();
    }

    protected Map<String, SearchFacetDTO> getNamedFacetMap(List<SearchFacetDTO> facets, final ProductSearchCriteria searchCriteria) {
        return BLCMapUtils.keyedMap(facets, (TypedClosure)new TypedClosure<String, SearchFacetDTO>(){

            public String getKey(SearchFacetDTO facet) {
                return SolrSearchServiceImpl.this.getSolrFieldKey(facet.getFacet().getField(), searchCriteria);
            }
        });
    }

    protected String getSolrFieldKey(Field field, ProductSearchCriteria searchCriteria) {
        return this.shs.getPropertyNameForFieldFacet(field);
    }

    protected Map<String, String> getSolrFieldKeyMap(ProductSearchCriteria searchCriteria) {
        List<Field> fields = this.fieldDao.readAllProductFields();
        HashMap<String, String> solrFieldKeyMap = new HashMap<String, String>();
        for (Field field : fields) {
            solrFieldKeyMap.put(field.getAbbreviation(), this.getSolrFieldKey(field, searchCriteria));
        }
        return solrFieldKeyMap;
    }
}

