/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.rating.domain;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.core.rating.domain.RatingDetail;
import org.broadleafcommerce.core.rating.domain.RatingSummary;
import org.broadleafcommerce.core.rating.domain.RatingSummaryImpl;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_RATING_DETAIL")
public class RatingDetailImpl
implements RatingDetail {
    @Id
    @GeneratedValue(generator="RatingDetailId")
    @GenericGenerator(name="RatingDetailId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="RatingDetailImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.rating.domain.RatingDetailImpl")})
    @Column(name="RATING_DETAIL_ID")
    private Long id;
    @Column(name="RATING", nullable=false)
    protected Double rating;
    @Column(name="RATING_SUBMITTED_DATE", nullable=false)
    protected Date ratingSubmittedDate;
    @ManyToOne(targetEntity=CustomerImpl.class, optional=false)
    @JoinColumn(name="CUSTOMER_ID")
    @Index(name="RATING_CUSTOMER_INDEX", columnNames={"CUSTOMER_ID"})
    protected Customer customer;
    @ManyToOne(optional=false, targetEntity=RatingSummaryImpl.class)
    @JoinColumn(name="RATING_SUMMARY_ID")
    protected RatingSummary ratingSummary;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Double getRating() {
        return this.rating;
    }

    @Override
    public void setRating(Double newRating) {
        this.rating = newRating;
    }

    @Override
    public Date getRatingSubmittedDate() {
        return this.ratingSubmittedDate;
    }

    @Override
    public void setRatingSubmittedDate(Date ratingSubmittedDate) {
        this.ratingSubmittedDate = ratingSubmittedDate;
    }

    @Override
    public Customer getCustomer() {
        return this.customer;
    }

    @Override
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    @Override
    public RatingSummary getRatingSummary() {
        return this.ratingSummary;
    }

    @Override
    public void setRatingSummary(RatingSummary ratingSummary) {
        this.ratingSummary = ratingSummary;
    }
}

