/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.workflow;

import java.math.BigDecimal;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupFee;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.TaxDetail;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class TotalActivity
extends BaseActivity<ProcessContext<Order>> {
    @Override
    public ProcessContext<Order> execute(ProcessContext<Order> context) throws Exception {
        Order order = context.getSeedData();
        this.setTaxSums(order);
        Money total = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)order.getCurrency());
        total = total.add(order.getSubTotal());
        total = total.subtract(order.getOrderAdjustmentsValue());
        total = total.add(order.getTotalShipping());
        if (order.getTotalTax() != null) {
            total = total.add(order.getTotalTax());
        }
        Money fees = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)order.getCurrency());
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            Money fgTotal = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)order.getCurrency());
            fgTotal = fgTotal.add(fulfillmentGroup.getMerchandiseTotal());
            fgTotal = fgTotal.add(fulfillmentGroup.getShippingPrice());
            fgTotal = fgTotal.add(fulfillmentGroup.getTotalTax());
            for (FulfillmentGroupFee fulfillmentGroupFee : fulfillmentGroup.getFulfillmentGroupFees()) {
                fgTotal = fgTotal.add(fulfillmentGroupFee.getAmount());
                fees = fees.add(fulfillmentGroupFee.getAmount());
            }
            fulfillmentGroup.setTotal(fgTotal);
        }
        total = total.add(fees);
        order.setTotal(total);
        context.setSeedData(order);
        return context;
    }

    protected void setTaxSums(Order order) {
        Money orderTotalTax = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)order.getCurrency());
        for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
            Money fgTotalFgTax = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)order.getCurrency());
            Money fgTotalItemTax = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)order.getCurrency());
            Money fgTotalFeeTax = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)order.getCurrency());
            if (fg.getTaxes() != null) {
                for (TaxDetail tax : fg.getTaxes()) {
                    fgTotalFgTax = fgTotalFgTax.add(tax.getAmount());
                }
            }
            for (FulfillmentGroupItem item : fg.getFulfillmentGroupItems()) {
                Money itemTotalTax = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)order.getCurrency());
                if (item.getTaxes() != null) {
                    for (TaxDetail tax : item.getTaxes()) {
                        itemTotalTax = itemTotalTax.add(tax.getAmount());
                    }
                }
                item.setTotalTax(itemTotalTax);
                fgTotalItemTax = fgTotalItemTax.add(itemTotalTax);
            }
            for (FulfillmentGroupFee fee : fg.getFulfillmentGroupFees()) {
                Money feeTotalTax = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)order.getCurrency());
                if (fee.getTaxes() != null) {
                    for (TaxDetail tax : fee.getTaxes()) {
                        feeTotalTax = feeTotalTax.add(tax.getAmount());
                    }
                }
                fee.setTotalTax(feeTotalTax);
                fgTotalFeeTax = fgTotalFeeTax.add(feeTotalTax);
            }
            Money fgTotalTax = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)order.getCurrency()).add(fgTotalFgTax).add(fgTotalItemTax).add(fgTotalFeeTax);
            fg.setTotalFulfillmentGroupTax(fgTotalFgTax);
            fg.setTotalItemTax(fgTotalItemTax);
            fg.setTotalFeeTax(fgTotalFeeTax);
            fg.setTotalTax(fgTotalTax);
            orderTotalTax = orderTotalTax.add(fgTotalTax);
        }
        order.setTotalTax(orderTotalTax);
    }
}

