/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.BankAccountPaymentInfo;
import org.broadleafcommerce.core.payment.domain.CreditCardPaymentInfo;
import org.broadleafcommerce.core.payment.domain.EmptyReferenced;
import org.broadleafcommerce.core.payment.domain.GiftCardPaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.payment.service.BroadleafPaymentInfoTypeService;
import org.broadleafcommerce.core.payment.service.SecurePaymentInfoService;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.springframework.stereotype.Service;

@Service(value="blPaymentInfoTypeService")
public class BroadleafPaymentInfoTypeServiceImpl
implements BroadleafPaymentInfoTypeService {
    @Resource(name="blSecurePaymentInfoService")
    protected SecurePaymentInfoService securePaymentInfoService;

    @Override
    public Map<PaymentInfo, Referenced> getPaymentsMap(Order order) {
        HashMap<PaymentInfo, Referenced> payments = new HashMap<PaymentInfo, Referenced>();
        for (PaymentInfo paymentInfo : order.getPaymentInfos()) {
            Referenced referenceInfo;
            if (PaymentInfoType.ACCOUNT.equals(paymentInfo.getType())) {
                referenceInfo = this.createAccountReferenceInfo(paymentInfo);
                payments.put(paymentInfo, referenceInfo);
            }
            if (PaymentInfoType.BANK_ACCOUNT.equals(paymentInfo.getType())) {
                referenceInfo = this.createBankAccountReferenceInfo(paymentInfo);
                payments.put(paymentInfo, referenceInfo);
            }
            if (PaymentInfoType.CHECK.equals(paymentInfo.getType())) {
                referenceInfo = this.createCheckReferenceInfo(paymentInfo);
                payments.put(paymentInfo, referenceInfo);
            }
            if (PaymentInfoType.CREDIT_CARD.equals(paymentInfo.getType())) {
                referenceInfo = this.createCreditCardReferenceInfo(paymentInfo);
                payments.put(paymentInfo, referenceInfo);
            }
            if (PaymentInfoType.CUSTOMER_CREDIT.equals(paymentInfo.getType())) {
                referenceInfo = this.createCustomerCreditReferenceInfo(paymentInfo);
                payments.put(paymentInfo, referenceInfo);
            }
            if (PaymentInfoType.ELECTRONIC_CHECK.equals(paymentInfo.getType())) {
                referenceInfo = this.createElectronicCheckReferenceInfo(paymentInfo);
                payments.put(paymentInfo, referenceInfo);
            }
            if (PaymentInfoType.GIFT_CARD.equals(paymentInfo.getType())) {
                referenceInfo = this.createGiftCardReferenceInfo(paymentInfo);
                payments.put(paymentInfo, referenceInfo);
            }
            if (PaymentInfoType.MONEY_ORDER.equals(paymentInfo.getType())) {
                referenceInfo = this.createMoneyOrderReferenceInfo(paymentInfo);
                payments.put(paymentInfo, referenceInfo);
            }
            if (PaymentInfoType.PAYPAL.equals(paymentInfo.getType())) {
                referenceInfo = this.createPayPalReferenceInfo(paymentInfo);
                payments.put(paymentInfo, referenceInfo);
            }
            if (!PaymentInfoType.WIRE.equals(paymentInfo.getType())) continue;
            referenceInfo = this.createWireReferenceInfo(paymentInfo);
            payments.put(paymentInfo, referenceInfo);
        }
        return payments;
    }

    public Referenced createAccountReferenceInfo(PaymentInfo paymentInfo) {
        EmptyReferenced blankReference = new EmptyReferenced();
        blankReference.setReferenceNumber(paymentInfo.getReferenceNumber());
        return blankReference;
    }

    public Referenced createBankAccountReferenceInfo(PaymentInfo paymentInfo) {
        BankAccountPaymentInfo blankReference = (BankAccountPaymentInfo)this.securePaymentInfoService.create(PaymentInfoType.BANK_ACCOUNT);
        blankReference.setReferenceNumber(paymentInfo.getReferenceNumber());
        return blankReference;
    }

    public Referenced createCheckReferenceInfo(PaymentInfo paymentInfo) {
        EmptyReferenced blankReference = new EmptyReferenced();
        blankReference.setReferenceNumber(paymentInfo.getReferenceNumber());
        return blankReference;
    }

    public Referenced createCreditCardReferenceInfo(PaymentInfo paymentInfo) {
        CreditCardPaymentInfo blankReference = (CreditCardPaymentInfo)this.securePaymentInfoService.create(PaymentInfoType.CREDIT_CARD);
        blankReference.setReferenceNumber(paymentInfo.getReferenceNumber());
        return blankReference;
    }

    public Referenced createCustomerCreditReferenceInfo(PaymentInfo paymentInfo) {
        EmptyReferenced blankReference = new EmptyReferenced();
        blankReference.setReferenceNumber(paymentInfo.getReferenceNumber());
        return blankReference;
    }

    public Referenced createElectronicCheckReferenceInfo(PaymentInfo paymentInfo) {
        EmptyReferenced blankReference = new EmptyReferenced();
        blankReference.setReferenceNumber(paymentInfo.getReferenceNumber());
        return blankReference;
    }

    public Referenced createGiftCardReferenceInfo(PaymentInfo paymentInfo) {
        GiftCardPaymentInfo blankReference = (GiftCardPaymentInfo)this.securePaymentInfoService.create(PaymentInfoType.GIFT_CARD);
        blankReference.setReferenceNumber(paymentInfo.getReferenceNumber());
        return blankReference;
    }

    public Referenced createMoneyOrderReferenceInfo(PaymentInfo paymentInfo) {
        EmptyReferenced blankReference = new EmptyReferenced();
        blankReference.setReferenceNumber(paymentInfo.getReferenceNumber());
        return blankReference;
    }

    public Referenced createPayPalReferenceInfo(PaymentInfo paymentInfo) {
        EmptyReferenced blankReference = new EmptyReferenced();
        blankReference.setReferenceNumber(paymentInfo.getReferenceNumber());
        return blankReference;
    }

    public Referenced createWireReferenceInfo(PaymentInfo paymentInfo) {
        EmptyReferenced blankReference = new EmptyReferenced();
        blankReference.setReferenceNumber(paymentInfo.getReferenceNumber());
        return blankReference;
    }
}

