/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.currency.util.CurrencyCodeIdentifiable;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationCollection;
import org.broadleafcommerce.common.presentation.AdminPresentationMap;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.payment.domain.AmountItem;
import org.broadleafcommerce.core.payment.domain.AmountItemImpl;
import org.broadleafcommerce.core.payment.domain.EmptyReferenced;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfoDetail;
import org.broadleafcommerce.core.payment.domain.PaymentInfoDetailImpl;
import org.broadleafcommerce.core.payment.domain.PaymentInfoDetailType;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItemImpl;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.CustomerPayment;
import org.broadleafcommerce.profile.core.domain.CustomerPaymentImpl;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.core.domain.PhoneImpl;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ORDER_PAYMENT")
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="", mergeEntries={@AdminPresentationMergeEntry(propertyType="readOnly", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="address", mergeEntries={@AdminPresentationMergeEntry(propertyType="tab", overrideValue="FulfillmentGroupImpl_Address_Tab"), @AdminPresentationMergeEntry(propertyType="tabOrder", intOverrideValue=4000)}), @AdminPresentationMergeOverride(name="address.isDefault", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="address.isActive", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="address.isBusiness", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="phone", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="phone.phoneNumber", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=false), @AdminPresentationMergeEntry(propertyType="order", intOverrideValue=8000), @AdminPresentationMergeEntry(propertyType="group", overrideValue="General"), @AdminPresentationMergeEntry(propertyType="requiredOverride", overrideValue="NOT_REQUIRED")})})
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="PaymentInfoImpl_basePaymentInfo")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"multiTenantSite"})})
public class PaymentInfoImpl
implements PaymentInfo,
CurrencyCodeIdentifiable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="PaymentInfoId")
    @GenericGenerator(name="PaymentInfoId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="PaymentInfoImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.payment.domain.PaymentInfoImpl")})
    @Column(name="PAYMENT_ID")
    protected Long id;
    @ManyToOne(targetEntity=OrderImpl.class, optional=false)
    @JoinColumn(name="ORDER_ID")
    @Index(name="ORDERPAYMENT_ORDER_INDEX", columnNames={"ORDER_ID"})
    @AdminPresentation(excluded=true)
    protected Order order;
    @ManyToOne(targetEntity=AddressImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="ADDRESS_ID")
    @Index(name="ORDERPAYMENT_ADDRESS_INDEX", columnNames={"ADDRESS_ID"})
    protected Address address;
    @ManyToOne(targetEntity=PhoneImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="PHONE_ID")
    @Index(name="ORDERPAYMENT_PHONE_INDEX", columnNames={"PHONE_ID"})
    protected Phone phone;
    @Column(name="AMOUNT", precision=19, scale=5)
    @AdminPresentation(friendlyName="PaymentInfoImpl_Payment_Amount", order=2000, gridOrder=2000, prominent=true, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal amount;
    @Column(name="REFERENCE_NUMBER")
    @Index(name="ORDERPAYMENT_REFERENCE_INDEX", columnNames={"REFERENCE_NUMBER"})
    @AdminPresentation(friendlyName="PaymentInfoImpl_Payment_Reference_Number", order=1000, prominent=true, gridOrder=1000)
    protected String referenceNumber;
    @Column(name="PAYMENT_TYPE", nullable=false)
    @Index(name="ORDERPAYMENT_TYPE_INDEX", columnNames={"PAYMENT_TYPE"})
    @AdminPresentation(friendlyName="PaymentInfoImpl_Payment_Type", order=3000, gridOrder=3000, prominent=true, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.payment.service.type.PaymentInfoType")
    protected String type;
    @OneToMany(mappedBy="paymentInfo", targetEntity=AmountItemImpl.class, cascade={CascadeType.ALL})
    @AdminPresentationCollection(friendlyName="PaymentInfoImpl_Amount_Items", tab="PaymentInfoImpl_Advanced_Tab", tabOrder=5000)
    protected List<AmountItem> amountItems = new ArrayList<AmountItem>();
    @Column(name="CUSTOMER_IP_ADDRESS", nullable=true)
    @AdminPresentation(friendlyName="PaymentInfoImpl_Payment_IP_Address", order=4000)
    protected String customerIpAddress;
    @ElementCollection
    @MapKeyColumn(name="FIELD_NAME")
    @Column(name="FIELD_VALUE")
    @CollectionTable(name="BLC_PAYINFO_ADDITIONAL_FIELDS", joinColumns={@JoinColumn(name="PAYMENT_ID")})
    @BatchSize(size=50)
    @AdminPresentationMap(friendlyName="PaymentInfoImpl_Additional_Fields", forceFreeFormKeys=true, keyPropertyFriendlyName="PaymentInfoImpl_Additional_Fields_Name")
    protected Map<String, String> additionalFields = new HashMap<String, String>();
    @OneToMany(mappedBy="paymentInfo", targetEntity=PaymentInfoDetailImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @AdminPresentationCollection(friendlyName="PaymentInfoImpl_Details", tab="PaymentInfoImpl_Log_Tab", tabOrder=4000)
    protected List<PaymentInfoDetail> details = new ArrayList<PaymentInfoDetail>();
    @OneToMany(mappedBy="paymentInfo", targetEntity=PaymentResponseItemImpl.class, cascade={CascadeType.ALL})
    @AdminPresentationCollection(friendlyName="PaymentInfoImpl_Payment_Response_Items")
    protected List<PaymentResponseItem> paymentResponseItems = new ArrayList<PaymentResponseItem>();
    @ManyToOne(targetEntity=CustomerPaymentImpl.class)
    @JoinColumn(name="CUSTOMER_PAYMENT_ID")
    @Index(name="CUSTOMER_PAYMENT", columnNames={"CUSTOMER_PAYMENT_ID"})
    @AdminPresentation(excluded=true)
    protected CustomerPayment customerPayment;
    @Transient
    protected Map<String, String[]> requestParameterMap = new HashMap<String, String[]>();

    @Override
    public Money getAmount() {
        return this.amount == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.amount, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setAmount(Money amount) {
        this.amount = Money.toAmount((Money)amount);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Order order) {
        this.order = order;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(Address address) {
        this.address = address;
    }

    @Override
    public Phone getPhone() {
        return this.phone;
    }

    @Override
    public void setPhone(Phone phone) {
        this.phone = phone;
    }

    @Override
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    @Override
    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    @Override
    public PaymentInfoType getType() {
        return PaymentInfoType.getInstance(this.type);
    }

    @Override
    public void setType(PaymentInfoType type) {
        this.type = type.getType();
    }

    @Override
    public List<AmountItem> getAmountItems() {
        return this.amountItems;
    }

    @Override
    public void setAmountItems(List<AmountItem> amountItems) {
        this.amountItems = amountItems;
    }

    @Override
    public String getCustomerIpAddress() {
        return this.customerIpAddress;
    }

    @Override
    public void setCustomerIpAddress(String customerIpAddress) {
        this.customerIpAddress = customerIpAddress;
    }

    @Override
    public Map<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    @Override
    public void setAdditionalFields(Map<String, String> additionalFields) {
        this.additionalFields = additionalFields;
    }

    @Override
    public Map<String, String[]> getRequestParameterMap() {
        return this.requestParameterMap;
    }

    @Override
    public void setRequestParameterMap(Map<String, String[]> requestParameterMap) {
        this.requestParameterMap = requestParameterMap;
    }

    @Override
    public CustomerPayment getCustomerPayment() {
        return this.customerPayment;
    }

    @Override
    public void setCustomerPayment(CustomerPayment customerPayment) {
        this.customerPayment = customerPayment;
    }

    @Override
    public List<PaymentInfoDetail> getPaymentInfoDetails() {
        return this.details;
    }

    @Override
    public void setPaymentInfoDetails(List<PaymentInfoDetail> details) {
        this.details = details;
    }

    @Override
    public Money getPaymentCapturedAmount() {
        return this.getDetailsAmountForType(PaymentInfoDetailType.CAPTURE);
    }

    @Override
    public Money getPaymentCreditedAmount() {
        return this.getDetailsAmountForType(PaymentInfoDetailType.REFUND);
    }

    @Override
    public Money getReverseAuthAmount() {
        return this.getDetailsAmountForType(PaymentInfoDetailType.REVERSE_AUTH);
    }

    public Money getDetailsAmountForType(PaymentInfoDetailType type) {
        Money amount = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)this.getOrder().getCurrency());
        for (PaymentInfoDetail detail : this.details) {
            if (!type.equals(detail.getType())) continue;
            amount = amount.add(detail.getAmount());
        }
        return amount;
    }

    @Override
    public BroadleafCurrency getCurrency() {
        if (this.order != null) {
            return this.order.getCurrency();
        }
        return null;
    }

    public String getCurrencyCode() {
        if (this.getCurrency() != null) {
            return this.getCurrency().getCurrencyCode();
        }
        return null;
    }

    @Override
    public List<PaymentResponseItem> getPaymentResponseItems() {
        return this.paymentResponseItems;
    }

    @Override
    public void setPaymentResponseItems(List<PaymentResponseItem> paymentResponseItems) {
        this.paymentResponseItems = paymentResponseItems;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaymentInfoImpl other = (PaymentInfoImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.referenceNumber == null ? other.referenceNumber != null : !this.referenceNumber.equals(other.referenceNumber)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.referenceNumber == null ? 0 : this.referenceNumber.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public Referenced createEmptyReferenced() {
        if (this.getReferenceNumber() == null) {
            throw new RuntimeException("referenceNumber must be already set");
        }
        EmptyReferenced emptyReferenced = new EmptyReferenced();
        emptyReferenced.setReferenceNumber(this.getReferenceNumber());
        return emptyReferenced;
    }

    public static class Presentation {

        public static class FieldOrder {
            public static final int REFNUMBER = 3000;
        }

        public static class Group {

            public static class Order {
                public static final int Items = 1000;
            }

            public static class Name {
                public static final String Items = "PaymentInfoImpl_Items";
            }
        }

        public static class Tab {

            public static class Order {
                public static final int Address = 2000;
                public static final int Log = 4000;
                public static final int Advanced = 5000;
            }

            public static class Name {
                public static final String Address = "PaymentInfoImpl_Address_Tab";
                public static final String Log = "PaymentInfoImpl_Log_Tab";
                public static final String Advanced = "PaymentInfoImpl_Advanced_Tab";
            }
        }
    }
}

