/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.legacy;

import java.util.ArrayList;
import javax.annotation.Resource;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.call.MergeCartResponse;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.call.ReconstructCartResponse;
import org.broadleafcommerce.core.order.service.exception.AddToCartException;
import org.broadleafcommerce.core.order.service.exception.ItemNotFoundException;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.order.service.exception.UpdateCartException;
import org.broadleafcommerce.core.order.service.legacy.LegacyCartService;
import org.broadleafcommerce.core.order.service.legacy.LegacyOrderServiceImpl;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;

@Deprecated
public class LegacyCartServiceImpl
extends LegacyOrderServiceImpl
implements LegacyCartService {
    @Resource(name="blCustomerService")
    protected CustomerService customerService;

    @Override
    public Order addAllItemsToCartFromNamedOrder(Order namedOrder) throws PricingException {
        return this.addAllItemsToCartFromNamedOrder(namedOrder, true);
    }

    @Override
    public Order addAllItemsToCartFromNamedOrder(Order namedOrder, boolean priceOrder) throws PricingException {
        Order cartOrder = this.orderDao.readCartForCustomer(namedOrder.getCustomer());
        if (cartOrder == null) {
            cartOrder = this.createNewCartForCustomer(namedOrder.getCustomer());
        }
        ArrayList<OrderItem> items = new ArrayList<OrderItem>(namedOrder.getOrderItems());
        for (int i = 0; i < items.size(); ++i) {
            boolean shouldPriceOrder;
            OrderItem orderItem = (OrderItem)items.get(i);
            boolean bl = shouldPriceOrder = priceOrder && i == items.size() - 1;
            if (this.moveNamedOrderItems) {
                this.moveItemToOrder(namedOrder, cartOrder, orderItem, shouldPriceOrder);
                continue;
            }
            this.addOrderItemToOrder(cartOrder, orderItem, shouldPriceOrder);
        }
        return cartOrder;
    }

    @Override
    public OrderItem moveItemToCartFromNamedOrder(Long customerId, String orderName, Long orderItemId, Integer quantity) throws PricingException {
        return this.moveItemToCartFromNamedOrder(customerId, orderName, orderItemId, quantity, true);
    }

    @Override
    public OrderItem moveItemToCartFromNamedOrder(Long customerId, String orderName, Long orderItemId, Integer quantity, boolean priceOrder) throws PricingException {
        Order wishlistOrder = this.findNamedOrderForCustomer(orderName, this.customerService.createCustomerFromId(customerId));
        OrderItem orderItem = this.orderItemService.readOrderItemById(orderItemId);
        orderItem.setQuantity(quantity);
        return this.moveItemToCartFromNamedOrder(wishlistOrder, orderItem, priceOrder);
    }

    @Override
    public OrderItem moveItemToCartFromNamedOrder(Order namedOrder, OrderItem orderItem) throws PricingException {
        return this.moveItemToCartFromNamedOrder(namedOrder, orderItem, true);
    }

    @Override
    public OrderItem moveItemToCartFromNamedOrder(Order namedOrder, OrderItem orderItem, boolean priceOrder) throws PricingException {
        Order cartOrder = this.orderDao.readCartForCustomer(namedOrder.getCustomer());
        if (cartOrder == null) {
            cartOrder = this.createNewCartForCustomer(namedOrder.getCustomer());
        }
        if (this.moveNamedOrderItems) {
            this.moveItemToOrder(namedOrder, cartOrder, orderItem, priceOrder);
            if (namedOrder.getOrderItems().size() == 0 && this.deleteEmptyNamedOrders) {
                this.cancelOrder(namedOrder);
            }
        } else {
            orderItem = this.addOrderItemToOrder(cartOrder, orderItem, priceOrder);
        }
        return orderItem;
    }

    @Override
    public Order moveAllItemsToCartFromNamedOrder(Order namedOrder) throws PricingException {
        return this.moveAllItemsToCartFromNamedOrder(namedOrder, true);
    }

    @Override
    public Order moveAllItemsToCartFromNamedOrder(Order namedOrder, boolean priceOrder) throws PricingException {
        Order cartOrder = this.addAllItemsToCartFromNamedOrder(namedOrder, priceOrder);
        if (this.deleteEmptyNamedOrders) {
            this.cancelOrder(namedOrder);
        }
        return cartOrder;
    }

    @Override
    public MergeCartResponse mergeCart(Customer customer, Order anonymousCart) throws PricingException {
        return this.mergeCart(customer, anonymousCart, true);
    }

    @Override
    public ReconstructCartResponse reconstructCart(Customer customer) throws PricingException {
        return this.reconstructCart(customer, true);
    }

    @Override
    public MergeCartResponse mergeCart(Customer customer, Order anonymousCart, boolean priceOrder) throws PricingException {
        try {
            return this.mergeCartService.mergeCart(customer, anonymousCart, priceOrder);
        }
        catch (RemoveFromCartException e) {
            throw new PricingException(e);
        }
    }

    @Override
    public ReconstructCartResponse reconstructCart(Customer customer, boolean priceOrder) throws PricingException {
        try {
            return this.mergeCartService.reconstructCart(customer, priceOrder);
        }
        catch (RemoveFromCartException e) {
            throw new PricingException(e);
        }
    }

    @Override
    public Order addItem(Long orderId, OrderItemRequestDTO orderItemRequestDTO, boolean priceOrder) throws AddToCartException {
        try {
            return this.addItemToOrder(orderId, orderItemRequestDTO, priceOrder);
        }
        catch (PricingException e) {
            throw new AddToCartException("Could not add item", e);
        }
    }

    @Override
    public Order updateItemQuantity(Long orderId, OrderItemRequestDTO orderItemRequestDTO, boolean priceOrder) throws UpdateCartException {
        try {
            Order order = this.findOrderById(orderId);
            this.updateItemQuantity(order, orderItemRequestDTO);
            return order;
        }
        catch (PricingException e) {
            throw new UpdateCartException("Could not update cart", e);
        }
        catch (ItemNotFoundException e) {
            throw new UpdateCartException("Could not update cart", e);
        }
    }

    @Override
    public Order removeItem(Long orderId, Long orderItemId, boolean priceOrder) throws RemoveFromCartException {
        try {
            return this.removeItemFromOrder(orderId, orderItemId, priceOrder);
        }
        catch (PricingException e) {
            throw new RemoveFromCartException("Could not remove item", e);
        }
    }
}

