/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.admin.domain.AdminMainEntity;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.currency.util.CurrencyCodeIdentifiable;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationCollection;
import org.broadleafcommerce.common.presentation.AdminPresentationMap;
import org.broadleafcommerce.common.presentation.AdminPresentationToOneLookup;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.offer.domain.CandidateItemOffer;
import org.broadleafcommerce.core.offer.domain.CandidateItemOfferImpl;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustmentImpl;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItemImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemAttribute;
import org.broadleafcommerce.core.order.domain.OrderItemAttributeImpl;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetail;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetailImpl;
import org.broadleafcommerce.core.order.domain.OrderItemQualifier;
import org.broadleafcommerce.core.order.domain.OrderItemQualifierImpl;
import org.broadleafcommerce.core.order.domain.PersonalMessage;
import org.broadleafcommerce.core.order.domain.PersonalMessageImpl;
import org.broadleafcommerce.core.order.service.type.OrderItemType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ORDER_ITEM")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="", mergeEntries={@AdminPresentationMergeEntry(propertyType="readOnly", booleanOverrideValue=true)})})
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="OrderItemImpl_baseOrderItem")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"multiTenantSite"})})
public class OrderItemImpl
implements OrderItem,
Cloneable,
AdminMainEntity,
CurrencyCodeIdentifiable {
    private static final Log LOG = LogFactory.getLog(OrderItemImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OrderItemId")
    @GenericGenerator(name="OrderItemId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="OrderItemImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.order.domain.OrderItemImpl")})
    @Column(name="ORDER_ITEM_ID")
    @AdminPresentation(visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @ManyToOne(targetEntity=CategoryImpl.class)
    @JoinColumn(name="CATEGORY_ID")
    @Index(name="ORDERITEM_CATEGORY_INDEX", columnNames={"CATEGORY_ID"})
    @NotFound(action=NotFoundAction.IGNORE)
    @AdminPresentation(friendlyName="OrderItemImpl_Category", order=1000, group="OrderItemImpl_Catalog", groupOrder=3000)
    @AdminPresentationToOneLookup
    protected Category category;
    @ManyToOne(targetEntity=OrderImpl.class)
    @JoinColumn(name="ORDER_ID")
    @Index(name="ORDERITEM_ORDER_INDEX", columnNames={"ORDER_ID"})
    @AdminPresentation(excluded=true)
    protected Order order;
    @Column(name="PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="OrderItemImpl_Item_Price", order=2000, group="OrderItemImpl_Pricing", groupOrder=2000, fieldType=SupportedFieldType.MONEY, prominent=true, gridOrder=3000)
    protected BigDecimal price;
    @Column(name="QUANTITY", nullable=false)
    @AdminPresentation(friendlyName="OrderItemImpl_Item_Quantity", order=3000, group="OrderItemImpl_Pricing", groupOrder=2000, prominent=true, gridOrder=2000)
    protected int quantity;
    @Column(name="RETAIL_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="OrderItemImpl_Item_Retail_Price", order=4000, group="OrderItemImpl_Pricing", groupOrder=2000, fieldType=SupportedFieldType.MONEY, prominent=true, gridOrder=4000)
    protected BigDecimal retailPrice;
    @Column(name="SALE_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="OrderItemImpl_Item_Sale_Price", order=5000, group="OrderItemImpl_Pricing", groupOrder=2000, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal salePrice;
    @Column(name="NAME")
    @AdminPresentation(friendlyName="OrderItemImpl_Item_Name", order=1000, group="OrderItemImpl_Description", prominent=true, gridOrder=1000, groupOrder=1000)
    protected String name;
    @ManyToOne(targetEntity=PersonalMessageImpl.class, cascade={CascadeType.ALL})
    @JoinColumn(name="PERSONAL_MESSAGE_ID")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    @Index(name="ORDERITEM_MESSAGE_INDEX", columnNames={"PERSONAL_MESSAGE_ID"})
    protected PersonalMessage personalMessage;
    @ManyToOne(targetEntity=GiftWrapOrderItemImpl.class, cascade={CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="GIFT_WRAP_ITEM_ID", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    @Index(name="ORDERITEM_GIFT_INDEX", columnNames={"GIFT_WRAP_ITEM_ID"})
    @AdminPresentation(excluded=true)
    protected GiftWrapOrderItem giftWrapOrderItem;
    @OneToMany(mappedBy="orderItem", targetEntity=OrderItemAdjustmentImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    @AdminPresentationCollection(friendlyName="OrderItemImpl_Adjustments", order=2000, tab="OrderImpl_Advanced", tabOrder=2000)
    protected List<OrderItemAdjustment> orderItemAdjustments = new ArrayList<OrderItemAdjustment>();
    @OneToMany(mappedBy="orderItem", targetEntity=OrderItemQualifierImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<OrderItemQualifier> orderItemQualifiers = new ArrayList<OrderItemQualifier>();
    @OneToMany(mappedBy="orderItem", targetEntity=CandidateItemOfferImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<CandidateItemOffer> candidateItemOffers = new ArrayList<CandidateItemOffer>();
    @OneToMany(mappedBy="orderItem", targetEntity=OrderItemPriceDetailImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    @AdminPresentationCollection(friendlyName="OrderItemImpl_Price_Details", order=1000, tab="OrderImpl_Advanced", tabOrder=2000)
    protected List<OrderItemPriceDetail> orderItemPriceDetails = new ArrayList<OrderItemPriceDetail>();
    @Column(name="ORDER_ITEM_TYPE")
    @Index(name="ORDERITEM_TYPE_INDEX", columnNames={"ORDER_ITEM_TYPE"})
    protected String orderItemType;
    @Column(name="ITEM_TAXABLE_FLAG")
    protected Boolean itemTaxable;
    @Column(name="RETAIL_PRICE_OVERRIDE")
    protected Boolean retailPriceOverride;
    @Column(name="SALE_PRICE_OVERRIDE")
    protected Boolean salePriceOverride;
    @Column(name="DISCOUNTS_ALLOWED")
    @AdminPresentation(friendlyName="OrderItemImpl_Discounts_Allowed", order=3000, tab="OrderImpl_Advanced", tabOrder=2000)
    protected Boolean discountsAllowed;
    @OneToMany(mappedBy="orderItem", targetEntity=OrderItemAttributeImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    @MapKey(name="name")
    @AdminPresentationMap(friendlyName="OrderItemImpl_Attributes", tab="OrderImpl_Advanced", tabOrder=2000, deleteEntityUponRemove=true, forceFreeFormKeys=true, keyPropertyFriendlyName="OrderItemAttributeImpl_Attribute_Name")
    protected Map<String, OrderItemAttribute> orderItemAttributeMap = new HashMap<String, OrderItemAttribute>();
    @Column(name="TOTAL_TAX")
    @AdminPresentation(friendlyName="OrderItemImpl_Total_Tax", order=6000, group="OrderItemImpl_Pricing", groupOrder=2000, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal totalTax;
    @OneToMany(mappedBy="parentOrderItem", targetEntity=OrderItemImpl.class)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<OrderItem> childOrderItems = new ArrayList<OrderItem>();
    @ManyToOne(targetEntity=OrderItemImpl.class)
    @JoinColumn(name="PARENT_ORDER_ITEM_ID")
    @Index(name="ORDERITEM_PARENTORDERITEM_INDEX", columnNames={"PARENT_ORDER_ITEM_ID"})
    protected OrderItem parentOrderItem;

    @Override
    public Money getRetailPrice() {
        if (this.retailPrice == null) {
            this.updateSaleAndRetailPrices();
        }
        return this.convertToMoney(this.retailPrice);
    }

    @Override
    public void setRetailPrice(Money retailPrice) {
        this.retailPrice = Money.toAmount((Money)retailPrice);
    }

    @Override
    public Money getSalePrice() {
        if (this.salePrice == null) {
            this.updateSaleAndRetailPrices();
        }
        if (this.salePrice != null) {
            Money returnPrice = this.convertToMoney(this.salePrice);
            if (this.retailPrice != null && returnPrice.greaterThan(this.getRetailPrice())) {
                return this.getRetailPrice();
            }
            return returnPrice;
        }
        return this.getRetailPrice();
    }

    @Override
    public void setSalePrice(Money salePrice) {
        this.salePrice = Money.toAmount((Money)salePrice);
    }

    @Override
    public Money getPrice() {
        return this.getAveragePrice();
    }

    @Override
    public void setPrice(Money finalPrice) {
        this.setRetailPrice(finalPrice);
        this.setSalePrice(finalPrice);
        this.setRetailPriceOverride(true);
        this.setSalePriceOverride(true);
        this.setDiscountingAllowed(false);
        this.price = Money.toAmount((Money)finalPrice);
    }

    @Override
    public Money getTaxablePrice() {
        Money taxablePrice = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)this.getOrder().getCurrency());
        if (this.isTaxable() == null || this.isTaxable().booleanValue()) {
            taxablePrice = this.getAveragePrice();
        }
        return taxablePrice;
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(Category category) {
        this.category = category;
    }

    @Override
    public List<CandidateItemOffer> getCandidateItemOffers() {
        return this.candidateItemOffers;
    }

    @Override
    public void setCandidateItemOffers(List<CandidateItemOffer> candidateItemOffers) {
        this.candidateItemOffers = candidateItemOffers;
    }

    @Override
    public PersonalMessage getPersonalMessage() {
        return this.personalMessage;
    }

    @Override
    public void setPersonalMessage(PersonalMessage personalMessage) {
        this.personalMessage = personalMessage;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Order order) {
        this.order = order;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isInCategory(String categoryName) {
        Category currentCategory = this.category;
        if (currentCategory != null) {
            if (currentCategory.getName().equals(categoryName)) {
                return true;
            }
            while ((currentCategory = currentCategory.getDefaultParentCategory()) != null) {
                if (!currentCategory.getName().equals(categoryName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<OrderItemQualifier> getOrderItemQualifiers() {
        return this.orderItemQualifiers;
    }

    @Override
    public void setOrderItemQualifiers(List<OrderItemQualifier> orderItemQualifiers) {
        this.orderItemQualifiers = orderItemQualifiers;
    }

    @Override
    public List<OrderItemAdjustment> getOrderItemAdjustments() {
        return this.orderItemAdjustments;
    }

    @Override
    public void setOrderItemAdjustments(List<OrderItemAdjustment> orderItemAdjustments) {
        this.orderItemAdjustments = orderItemAdjustments;
    }

    @Override
    public Money getAdjustmentValue() {
        return this.getAverageAdjustmentValue();
    }

    @Override
    public GiftWrapOrderItem getGiftWrapOrderItem() {
        return this.giftWrapOrderItem;
    }

    @Override
    public void setGiftWrapOrderItem(GiftWrapOrderItem giftWrapOrderItem) {
        this.giftWrapOrderItem = giftWrapOrderItem;
    }

    @Override
    public OrderItemType getOrderItemType() {
        return this.convertOrderItemType(this.orderItemType);
    }

    @Override
    public void setOrderItemType(OrderItemType orderItemType) {
        this.orderItemType = orderItemType.getType();
    }

    @Override
    public boolean getIsOnSale() {
        if (this.getSalePrice() != null) {
            return !this.getSalePrice().equals((Object)this.getRetailPrice());
        }
        return false;
    }

    @Override
    public boolean getIsDiscounted() {
        if (this.getPrice() != null) {
            return !this.getPrice().equals((Object)this.getRetailPrice());
        }
        return false;
    }

    @Override
    public boolean updateSaleAndRetailPrices() {
        if (this.salePrice == null) {
            this.salePrice = this.retailPrice;
        }
        return false;
    }

    @Override
    public void finalizePrice() {
        this.price = this.getAveragePrice().getAmount();
    }

    @Override
    public void assignFinalPrice() {
        Money finalPrice = this.getTotalPrice().divide(this.quantity);
        this.price = finalPrice.getAmount();
    }

    @Override
    public Money getPriceBeforeAdjustments(boolean allowSalesPrice) {
        boolean retailPriceOverride = false;
        for (OrderItemPriceDetail oipd : this.getOrderItemPriceDetails()) {
            if (oipd.getUseSalePrice()) continue;
            retailPriceOverride = true;
            break;
        }
        if (allowSalesPrice && !retailPriceOverride) {
            return this.getSalePrice();
        }
        return this.getRetailPrice();
    }

    @Override
    public void addCandidateItemOffer(CandidateItemOffer candidateItemOffer) {
        this.getCandidateItemOffers().add(candidateItemOffer);
    }

    @Override
    public void removeAllCandidateItemOffers() {
        if (this.getCandidateItemOffers() != null) {
            for (CandidateItemOffer candidate : this.getCandidateItemOffers()) {
                candidate.setOrderItem(null);
            }
            this.getCandidateItemOffers().clear();
        }
    }

    @Override
    public int removeAllAdjustments() {
        int removedAdjustmentCount = 0;
        if (this.getOrderItemAdjustments() != null) {
            for (OrderItemAdjustment adjustment : this.getOrderItemAdjustments()) {
                adjustment.setOrderItem(null);
            }
            removedAdjustmentCount = this.getOrderItemAdjustments().size();
            this.getOrderItemAdjustments().clear();
        }
        this.assignFinalPrice();
        return removedAdjustmentCount;
    }

    @Override
    public Map<String, OrderItemAttribute> getOrderItemAttributes() {
        return this.orderItemAttributeMap;
    }

    @Override
    public void setOrderItemAttributes(Map<String, OrderItemAttribute> orderItemAttributes) {
        this.orderItemAttributeMap = orderItemAttributes;
    }

    @Override
    public Boolean isTaxable() {
        return this.itemTaxable == null ? true : this.itemTaxable;
    }

    @Override
    public void setTaxable(Boolean taxable) {
        this.itemTaxable = taxable;
    }

    @Override
    public void setOrderItemPriceDetails(List<OrderItemPriceDetail> orderItemPriceDetails) {
        this.orderItemPriceDetails = orderItemPriceDetails;
    }

    @Override
    public boolean isDiscountingAllowed() {
        if (this.discountsAllowed == null) {
            return true;
        }
        return this.discountsAllowed;
    }

    @Override
    public void setDiscountingAllowed(boolean discountsAllowed) {
        this.discountsAllowed = discountsAllowed;
    }

    @Override
    public Money getAveragePrice() {
        if (this.quantity == 0) {
            return this.price == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.price, (BroadleafCurrency)this.getOrder().getCurrency());
        }
        return this.getTotalPrice().divide(this.quantity);
    }

    @Override
    public Money getAverageAdjustmentValue() {
        if (this.quantity == 0) {
            return null;
        }
        return this.getTotalAdjustmentValue().divide(this.quantity);
    }

    @Override
    public Money getTotalAdjustmentValue() {
        Money totalAdjustmentValue = BroadleafCurrencyUtils.getMoney((BroadleafCurrency)this.getOrder().getCurrency());
        List<OrderItemPriceDetail> priceDetails = this.getOrderItemPriceDetails();
        if (priceDetails != null) {
            for (OrderItemPriceDetail priceDetail : this.getOrderItemPriceDetails()) {
                totalAdjustmentValue = totalAdjustmentValue.add(priceDetail.getTotalAdjustmentValue());
            }
        }
        return totalAdjustmentValue;
    }

    @Override
    public Money getTotalPrice() {
        Money returnValue = this.convertToMoney(BigDecimal.ZERO);
        if (this.orderItemPriceDetails != null && this.orderItemPriceDetails.size() > 0) {
            for (OrderItemPriceDetail oipd : this.orderItemPriceDetails) {
                returnValue = returnValue.add(oipd.getTotalAdjustedPrice());
            }
        } else if (this.price != null) {
            returnValue = this.convertToMoney(this.price).multiply(this.quantity);
        } else {
            return this.getSalePrice().multiply(this.quantity);
        }
        return returnValue;
    }

    @Override
    public Money getTotalPriceBeforeAdjustments(boolean allowSalesPrice) {
        return this.getPriceBeforeAdjustments(allowSalesPrice).multiply(this.getQuantity());
    }

    @Override
    public void setRetailPriceOverride(boolean override) {
        this.retailPriceOverride = override;
    }

    @Override
    public boolean isRetailPriceOverride() {
        if (this.retailPriceOverride == null) {
            return false;
        }
        return this.retailPriceOverride;
    }

    @Override
    public void setSalePriceOverride(boolean override) {
        this.salePriceOverride = override;
    }

    @Override
    public boolean isSalePriceOverride() {
        if (this.salePriceOverride == null) {
            return false;
        }
        return this.salePriceOverride;
    }

    @Override
    public List<OrderItemPriceDetail> getOrderItemPriceDetails() {
        return this.orderItemPriceDetails;
    }

    @Override
    public List<OrderItem> getChildOrderItems() {
        return this.childOrderItems;
    }

    @Override
    public void setChildOrderItems(List<OrderItem> childOrderItems) {
        this.childOrderItems = childOrderItems;
    }

    @Override
    public OrderItem getParentOrderItem() {
        return this.parentOrderItem;
    }

    @Override
    public void setParentOrderItem(OrderItem parentOrderItem) {
        this.parentOrderItem = parentOrderItem;
    }

    @Override
    public boolean isAParentOf(OrderItem candidateChild) {
        if (CollectionUtils.isNotEmpty(this.getChildOrderItems())) {
            for (OrderItem child : this.getChildOrderItems()) {
                if (!child.equals(candidateChild)) continue;
                return true;
            }
            for (OrderItem child : this.getChildOrderItems()) {
                if (!child.isAParentOf(candidateChild)) continue;
                return true;
            }
        }
        return false;
    }

    public String getMainEntityName() {
        return this.getName();
    }

    public String getCurrencyCode() {
        if (this.getOrder().getCurrency() != null) {
            return this.getOrder().getCurrency().getCurrencyCode();
        }
        return null;
    }

    public void checkCloneable(OrderItem orderItem) throws CloneNotSupportedException, SecurityException, NoSuchMethodException {
        Method cloneMethod = orderItem.getClass().getMethod("clone", new Class[0]);
        if (cloneMethod.getDeclaringClass().getName().startsWith("org.broadleafcommerce") && !orderItem.getClass().getName().startsWith("org.broadleafcommerce")) {
            throw new CloneNotSupportedException("Custom extensions and implementations should implement clone in order to guarantee split and merge operations are performed accurately");
        }
    }

    protected Money convertToMoney(BigDecimal amount) {
        return amount == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)amount, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    protected OrderItemType convertOrderItemType(String type) {
        return OrderItemType.getInstance(type);
    }

    @Override
    public OrderItem clone() {
        OrderItemImpl clonedOrderItem;
        try {
            Object clone;
            clonedOrderItem = (OrderItemImpl)Class.forName(this.getClass().getName()).newInstance();
            try {
                this.checkCloneable(clonedOrderItem);
            }
            catch (CloneNotSupportedException e) {
                LOG.warn((Object)("Clone implementation missing in inheritance hierarchy outside of Broadleaf: " + clonedOrderItem.getClass().getName()), (Throwable)e);
            }
            if (this.candidateItemOffers != null) {
                for (CandidateItemOffer candidate : this.candidateItemOffers) {
                    clone = candidate.clone();
                    clone.setOrderItem(clonedOrderItem);
                    clonedOrderItem.getCandidateItemOffers().add((CandidateItemOffer)clone);
                }
            }
            if (this.orderItemAttributeMap != null && !this.orderItemAttributeMap.isEmpty()) {
                for (OrderItemAttribute attribute : this.orderItemAttributeMap.values()) {
                    clone = attribute.clone();
                    clone.setOrderItem(clonedOrderItem);
                    clonedOrderItem.getOrderItemAttributes().put(clone.getName(), (OrderItemAttribute)clone);
                }
            }
            if (CollectionUtils.isNotEmpty(this.childOrderItems)) {
                for (OrderItem childOrderItem : this.childOrderItems) {
                    clone = childOrderItem.clone();
                    clone.setParentOrderItem(clonedOrderItem);
                    clonedOrderItem.getChildOrderItems().add((OrderItem)clone);
                }
            }
            clonedOrderItem.setCategory(this.category);
            clonedOrderItem.setGiftWrapOrderItem(this.giftWrapOrderItem);
            clonedOrderItem.setName(this.name);
            clonedOrderItem.setOrder(this.order);
            clonedOrderItem.setOrderItemType(this.convertOrderItemType(this.orderItemType));
            clonedOrderItem.setPersonalMessage(this.personalMessage);
            clonedOrderItem.setQuantity(this.quantity);
            clonedOrderItem.retailPrice = this.retailPrice;
            clonedOrderItem.salePrice = this.salePrice;
            clonedOrderItem.discountsAllowed = this.discountsAllowed;
            clonedOrderItem.salePriceOverride = this.salePriceOverride;
            clonedOrderItem.retailPriceOverride = this.retailPriceOverride;
            clonedOrderItem.setParentOrderItem(this.parentOrderItem);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return clonedOrderItem;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.giftWrapOrderItem == null ? 0 : this.giftWrapOrderItem.hashCode());
        result = 31 * result + (this.order == null ? 0 : this.order.hashCode());
        result = 31 * result + (this.orderItemType == null ? 0 : this.orderItemType.hashCode());
        result = 31 * result + (this.personalMessage == null ? 0 : this.personalMessage.hashCode());
        result = 31 * result + (this.price == null ? 0 : this.price.hashCode());
        result = 31 * result + this.quantity;
        result = 31 * result + (this.retailPrice == null ? 0 : this.retailPrice.hashCode());
        result = 31 * result + (this.salePrice == null ? 0 : this.salePrice.hashCode());
        result = 31 * result + (this.parentOrderItem == null ? 0 : this.parentOrderItem.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderItemImpl other = (OrderItemImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        if (this.giftWrapOrderItem == null ? other.giftWrapOrderItem != null : !this.giftWrapOrderItem.equals(other.giftWrapOrderItem)) {
            return false;
        }
        if (this.order == null ? other.order != null : !this.order.equals(other.order)) {
            return false;
        }
        if (this.orderItemType == null ? other.orderItemType != null : !this.orderItemType.equals(other.orderItemType)) {
            return false;
        }
        if (this.personalMessage == null ? other.personalMessage != null : !this.personalMessage.equals(other.personalMessage)) {
            return false;
        }
        if (this.price == null ? other.price != null : !this.price.equals(other.price)) {
            return false;
        }
        if (this.quantity != other.quantity) {
            return false;
        }
        if (this.retailPrice == null ? other.retailPrice != null : !this.retailPrice.equals(other.retailPrice)) {
            return false;
        }
        if (this.salePrice == null ? other.salePrice != null : !this.salePrice.equals(other.salePrice)) {
            return false;
        }
        return !(this.parentOrderItem == null ? other.parentOrderItem != null : !this.parentOrderItem.equals(other.parentOrderItem));
    }

    @Override
    public boolean isSkuActive() {
        return true;
    }

    public static class Presentation {

        public static class FieldOrder {
            public static final int NAME = 1000;
            public static final int PRICE = 2000;
            public static final int QUANTITY = 3000;
            public static final int RETAILPRICE = 4000;
            public static final int SALEPRICE = 5000;
            public static final int TOTALTAX = 6000;
            public static final int CATEGORY = 1000;
            public static final int PRICEDETAILS = 1000;
            public static final int ADJUSTMENTS = 2000;
            public static final int DISCOUNTALLOWED = 3000;
        }

        public static class Group {

            public static class Order {
                public static final int Description = 1000;
                public static final int Pricing = 2000;
                public static final int Catalog = 3000;
            }

            public static class Name {
                public static final String Description = "OrderItemImpl_Description";
                public static final String Pricing = "OrderItemImpl_Pricing";
                public static final String Catalog = "OrderItemImpl_Catalog";
            }
        }

        public static class Tab {

            public static class Order {
                public static final int Advanced = 2000;
            }

            public static class Name {
                public static final String Advanced = "OrderImpl_Advanced";
            }
        }
    }
}

