/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.offer.dao.CustomerOfferDao;
import org.broadleafcommerce.core.offer.dao.OfferCodeDao;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.Adjustment;
import org.broadleafcommerce.core.offer.domain.CustomerOffer;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.service.OfferAuditService;
import org.broadleafcommerce.core.offer.service.OfferContext;
import org.broadleafcommerce.core.offer.service.OfferService;
import org.broadleafcommerce.core.offer.service.OfferServiceExtensionHandler;
import org.broadleafcommerce.core.offer.service.OfferServiceExtensionManager;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateOrderOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.processor.FulfillmentGroupOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessor;
import org.broadleafcommerce.core.offer.service.type.OfferType;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetail;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="blOfferService")
public class OfferServiceImpl
implements OfferService {
    private static final Log LOG = LogFactory.getLog(OfferServiceImpl.class);
    @Resource(name="blCustomerOfferDao")
    protected CustomerOfferDao customerOfferDao;
    @Resource(name="blOfferCodeDao")
    protected OfferCodeDao offerCodeDao;
    @Resource(name="blOfferAuditService")
    protected OfferAuditService offerAuditService;
    @Resource(name="blOfferDao")
    protected OfferDao offerDao;
    @Resource(name="blOrderOfferProcessor")
    protected OrderOfferProcessor orderOfferProcessor;
    @Resource(name="blItemOfferProcessor")
    protected ItemOfferProcessor itemOfferProcessor;
    @Resource(name="blFulfillmentGroupOfferProcessor")
    protected FulfillmentGroupOfferProcessor fulfillmentGroupOfferProcessor;
    @Resource(name="blPromotableItemFactory")
    protected PromotableItemFactory promotableItemFactory;
    @Resource(name="blOfferServiceExtensionManager")
    protected OfferServiceExtensionManager extensionManager;
    @Resource(name="blOrderService")
    protected OrderService orderService;

    @Override
    public List<Offer> findAllOffers() {
        return this.offerDao.readAllOffers();
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Offer save(Offer offer) {
        return this.offerDao.save(offer);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public OfferCode saveOfferCode(OfferCode offerCode) {
        offerCode.setOffer(this.offerDao.save(offerCode.getOffer()));
        return this.offerCodeDao.save(offerCode);
    }

    @Override
    public Offer lookupOfferByCode(String code) {
        Offer offer = null;
        OfferCode offerCode = this.offerCodeDao.readOfferCodeByCode(code);
        if (offerCode != null) {
            offer = offerCode.getOffer();
        }
        return offer;
    }

    @Override
    public OfferCode lookupOfferCodeByCode(String code) {
        return this.offerCodeDao.readOfferCodeByCode(code);
    }

    @Override
    public List<Offer> buildOfferListForOrder(Order order) {
        ArrayList<Offer> offers = new ArrayList<Offer>();
        List<CustomerOffer> customerOffers = this.lookupOfferCustomerByCustomer(order.getCustomer());
        for (CustomerOffer customerOffer : customerOffers) {
            if (offers.contains(customerOffer.getOffer())) continue;
            offers.add(customerOffer.getOffer());
        }
        List<OfferCode> orderOfferCodes = order.getAddedOfferCodes();
        orderOfferCodes = this.removeOutOfDateOfferCodes(orderOfferCodes);
        for (OfferCode orderOfferCode : orderOfferCodes) {
            if (offers.contains(orderOfferCode.getOffer())) continue;
            offers.add(orderOfferCode.getOffer());
        }
        List<Offer> globalOffers = this.lookupAutomaticDeliveryOffers();
        for (Offer globalOffer : globalOffers) {
            if (offers.contains(globalOffer) || !this.verifyMaxCustomerUsageThreshold(order.getCustomer(), globalOffer)) continue;
            offers.add(globalOffer);
        }
        if (this.extensionManager != null) {
            ((OfferServiceExtensionHandler)this.extensionManager.getProxy()).applyAdditionalFilters(offers);
        }
        return offers;
    }

    protected List<CustomerOffer> lookupOfferCustomerByCustomer(Customer customer) {
        List<CustomerOffer> offerCustomers = this.customerOfferDao.readCustomerOffersByCustomer(customer);
        return offerCustomers;
    }

    protected List<Offer> lookupAutomaticDeliveryOffers() {
        List<Offer> globalOffers = this.offerDao.readOffersByAutomaticDeliveryType();
        return globalOffers;
    }

    protected List<OfferCode> removeOutOfDateOfferCodes(List<OfferCode> offerCodes) {
        Date now = SystemTime.asDate();
        ArrayList<OfferCode> offerCodesToRemove = new ArrayList<OfferCode>();
        for (OfferCode offerCode : offerCodes) {
            if (offerCode.getStartDate() != null && offerCode.getStartDate().after(now)) {
                offerCodesToRemove.add(offerCode);
                continue;
            }
            if (offerCode.getEndDate() == null || !offerCode.getEndDate().before(now)) continue;
            offerCodesToRemove.add(offerCode);
        }
        for (OfferCode offerCode : offerCodesToRemove) {
            offerCodes.remove(offerCode);
        }
        return offerCodes;
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void applyOffersToOrder(List<Offer> offers, Order order) throws PricingException {
        OfferContext offerContext = OfferContext.getOfferContext();
        if (offerContext == null || offerContext.executePromotionCalculation.booleanValue()) {
            order.updatePrices();
            PromotableOrder promotableOrder = this.promotableItemFactory.createPromotableOrder(order, false);
            List<Offer> filteredOffers = this.orderOfferProcessor.filterOffers(offers, order.getCustomer());
            if (filteredOffers == null || filteredOffers.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"No offers applicable to this order.");
                }
            } else {
                ArrayList<PromotableCandidateOrderOffer> qualifiedOrderOffers = new ArrayList<PromotableCandidateOrderOffer>();
                ArrayList<PromotableCandidateItemOffer> qualifiedItemOffers = new ArrayList<PromotableCandidateItemOffer>();
                this.itemOfferProcessor.filterOffers(promotableOrder, filteredOffers, qualifiedOrderOffers, qualifiedItemOffers);
                if (!qualifiedItemOffers.isEmpty() || !qualifiedOrderOffers.isEmpty()) {
                    this.itemOfferProcessor.applyAndCompareOrderAndItemOffers(promotableOrder, qualifiedOrderOffers, qualifiedItemOffers);
                }
            }
            this.orderOfferProcessor.synchronizeAdjustmentsAndPrices(promotableOrder);
            order.setSubTotal(order.calculateSubTotal());
            order.finalizeItemPrices();
            this.orderService.save(order, false);
        }
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void applyFulfillmentGroupOffersToOrder(List<Offer> offers, Order order) throws PricingException {
        OfferContext offerContext = OfferContext.getOfferContext();
        if (offerContext == null || offerContext.executePromotionCalculation.booleanValue()) {
            PromotableOrder promotableOrder = this.promotableItemFactory.createPromotableOrder(order, true);
            ArrayList<Offer> possibleFGOffers = new ArrayList<Offer>();
            for (Offer offer : offers) {
                if (!offer.getType().getType().equals(OfferType.FULFILLMENT_GROUP.getType())) continue;
                possibleFGOffers.add(offer);
            }
            List<Offer> filteredOffers = this.orderOfferProcessor.filterOffers(possibleFGOffers, order.getCustomer());
            ArrayList<PromotableCandidateFulfillmentGroupOffer> qualifiedFGOffers = new ArrayList<PromotableCandidateFulfillmentGroupOffer>();
            for (Offer offer : filteredOffers) {
                this.fulfillmentGroupOfferProcessor.filterFulfillmentGroupLevelOffer(promotableOrder, qualifiedFGOffers, offer);
            }
            if (!qualifiedFGOffers.isEmpty()) {
                this.fulfillmentGroupOfferProcessor.applyAllFulfillmentGroupOffers(qualifiedFGOffers, promotableOrder);
                this.fulfillmentGroupOfferProcessor.calculateFulfillmentGroupTotal(promotableOrder);
                this.orderOfferProcessor.synchronizeAdjustmentsAndPrices(promotableOrder);
            }
            this.orderService.save(order, false);
        }
    }

    @Override
    public boolean verifyMaxCustomerUsageThreshold(Customer customer, Offer offer) {
        Long currentUses;
        return !offer.isLimitedUsePerCustomer() || (currentUses = this.offerAuditService.countUsesByCustomer(customer.getId(), offer.getId())) < offer.getMaxUsesPerCustomer();
    }

    @Override
    public boolean verifyMaxCustomerUsageThreshold(@NotNull Customer customer, OfferCode code) {
        boolean underCodeMaxUses = true;
        if (code.isLimitedUse()) {
            Long currentCodeUses = this.offerAuditService.countOfferCodeUses(code.getId());
            underCodeMaxUses = currentCodeUses < (long)code.getMaxUses();
        }
        return underCodeMaxUses && this.verifyMaxCustomerUsageThreshold(customer, code.getOffer());
    }

    @Override
    public Set<Offer> getUniqueOffersFromOrder(Order order) {
        HashSet<Offer> result = new HashSet<Offer>();
        Transformer adjustmentToOfferTransformer = new Transformer(){

            public Object transform(Object input) {
                return ((Adjustment)input).getOffer();
            }
        };
        result.addAll(CollectionUtils.collect(order.getOrderAdjustments(), (Transformer)adjustmentToOfferTransformer));
        if (order.getOrderItems() != null) {
            for (OrderItem item : order.getOrderItems()) {
                result.addAll(CollectionUtils.collect(item.getOrderItemAdjustments(), (Transformer)adjustmentToOfferTransformer));
                if (item.getOrderItemPriceDetails() == null) continue;
                for (OrderItemPriceDetail detail : item.getOrderItemPriceDetails()) {
                    result.addAll(CollectionUtils.collect(detail.getOrderItemPriceDetailAdjustments(), (Transformer)adjustmentToOfferTransformer));
                }
            }
        }
        if (order.getFulfillmentGroups() != null) {
            for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
                result.addAll(CollectionUtils.collect(fg.getFulfillmentGroupAdjustments(), (Transformer)adjustmentToOfferTransformer));
            }
        }
        return result;
    }

    @Override
    public Map<Offer, OfferCode> getOffersRetrievedFromCodes(Order order) {
        return this.getOffersRetrievedFromCodes(order.getAddedOfferCodes(), this.getUniqueOffersFromOrder(order));
    }

    @Override
    public Map<Offer, OfferCode> getOffersRetrievedFromCodes(List<OfferCode> codes, Set<Offer> appliedOffers) {
        HashMap<Offer, OfferCode> offerToCodeMapping = new HashMap<Offer, OfferCode>();
        for (OfferCode code : codes) {
            if (!appliedOffers.contains(code.getOffer())) continue;
            offerToCodeMapping.put(code.getOffer(), code);
        }
        return offerToCodeMapping;
    }

    @Override
    public CustomerOfferDao getCustomerOfferDao() {
        return this.customerOfferDao;
    }

    @Override
    public void setCustomerOfferDao(CustomerOfferDao customerOfferDao) {
        this.customerOfferDao = customerOfferDao;
    }

    @Override
    public OfferCodeDao getOfferCodeDao() {
        return this.offerCodeDao;
    }

    @Override
    public void setOfferCodeDao(OfferCodeDao offerCodeDao) {
        this.offerCodeDao = offerCodeDao;
    }

    @Override
    public OfferDao getOfferDao() {
        return this.offerDao;
    }

    @Override
    public void setOfferDao(OfferDao offerDao) {
        this.offerDao = offerDao;
    }

    @Override
    public OrderOfferProcessor getOrderOfferProcessor() {
        return this.orderOfferProcessor;
    }

    @Override
    public void setOrderOfferProcessor(OrderOfferProcessor orderOfferProcessor) {
        this.orderOfferProcessor = orderOfferProcessor;
    }

    @Override
    public ItemOfferProcessor getItemOfferProcessor() {
        return this.itemOfferProcessor;
    }

    @Override
    public void setItemOfferProcessor(ItemOfferProcessor itemOfferProcessor) {
        this.itemOfferProcessor = itemOfferProcessor;
    }

    @Override
    public FulfillmentGroupOfferProcessor getFulfillmentGroupOfferProcessor() {
        return this.fulfillmentGroupOfferProcessor;
    }

    @Override
    public void setFulfillmentGroupOfferProcessor(FulfillmentGroupOfferProcessor fulfillmentGroupOfferProcessor) {
        this.fulfillmentGroupOfferProcessor = fulfillmentGroupOfferProcessor;
    }

    @Override
    public PromotableItemFactory getPromotableItemFactory() {
        return this.promotableItemFactory;
    }

    @Override
    public void setPromotableItemFactory(PromotableItemFactory promotableItemFactory) {
        this.promotableItemFactory = promotableItemFactory;
    }

    @Override
    public OfferCode findOfferCodeById(Long id) {
        return this.offerCodeDao.readOfferCodeById(id);
    }

    @Override
    public OrderService getOrderService() {
        return this.orderService;
    }

    @Override
    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }
}

