/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.locale.service.LocaleService;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.common.util.BLCMapUtils;
import org.broadleafcommerce.common.util.TypedClosure;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.service.dynamic.DynamicSkuPricingService;
import org.broadleafcommerce.core.catalog.service.dynamic.SkuPricingConsiderationContext;
import org.broadleafcommerce.core.search.dao.FieldDao;
import org.broadleafcommerce.core.search.dao.SearchFacetDao;
import org.broadleafcommerce.core.search.domain.CategorySearchFacet;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.ProductSearchCriteria;
import org.broadleafcommerce.core.search.domain.ProductSearchResult;
import org.broadleafcommerce.core.search.domain.RequiredFacet;
import org.broadleafcommerce.core.search.domain.SearchFacet;
import org.broadleafcommerce.core.search.domain.SearchFacetDTO;
import org.broadleafcommerce.core.search.domain.SearchFacetRange;
import org.broadleafcommerce.core.search.domain.SearchFacetResultDTO;
import org.broadleafcommerce.core.search.domain.solr.FieldType;
import org.broadleafcommerce.core.search.service.SearchService;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionListener;
import org.broadleafcommerce.core.util.StopWatch;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.xml.sax.SAXException;

public class SolrSearchServiceImpl
implements SearchService,
DisposableBean {
    private static final Log LOG = LogFactory.getLog(SolrSearchServiceImpl.class);
    protected static final String GLOBAL_FACET_TAG_FIELD = "a";
    protected static final String DEFAULT_NAMESPACE = "d";
    protected static Locale defaultLocale;
    @Resource(name="blProductDao")
    protected ProductDao productDao;
    @Resource(name="blFieldDao")
    protected FieldDao fieldDao;
    @Resource(name="blSearchFacetDao")
    protected SearchFacetDao searchFacetDao;
    @Resource(name="blLocaleService")
    protected LocaleService localeService;
    @Resource(name="blSolrSearchServiceExtensionManager")
    protected SolrSearchServiceExtensionListener extensionManager;
    protected SolrServer server;

    public SolrSearchServiceImpl(String solrServer) throws IOException, ParserConfigurationException, SAXException {
        System.setProperty("solr.solr.home", solrServer);
        CoreContainer.Initializer initializer = new CoreContainer.Initializer();
        CoreContainer coreContainer = initializer.initialize();
        EmbeddedSolrServer server = new EmbeddedSolrServer(coreContainer, "");
        this.server = server;
    }

    public SolrSearchServiceImpl(SolrServer solrServer) {
        this.server = solrServer;
    }

    public void destroy() throws Exception {
        if (this.server instanceof EmbeddedSolrServer) {
            ((EmbeddedSolrServer)this.server).shutdown();
        }
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void rebuildIndex() throws ServiceException, IOException {
        LOG.info((Object)"Rebuilding the solr index...");
        StopWatch s = new StopWatch();
        BroadleafRequestContext savedContext = BroadleafRequestContext.getBroadleafRequestContext();
        HashMap savedPricing = SkuPricingConsiderationContext.getSkuPricingConsiderationContext();
        DynamicSkuPricingService savedPricingService = SkuPricingConsiderationContext.getSkuPricingService();
        List<Product> products = this.readAllActiveProducts();
        List<Field> fields = this.fieldDao.readAllProductFields();
        List<Locale> locales = this.getAllLocales();
        ArrayList<SolrInputDocument> documents = new ArrayList<SolrInputDocument>();
        for (Product product : products) {
            documents.add(this.buildDocument(product, fields, locales));
        }
        if (LOG.isTraceEnabled()) {
            for (SolrInputDocument document : documents) {
                LOG.trace((Object)document);
            }
        }
        try {
            if (documents != null && documents.size() > 0) {
                String deleteQuery = this.getNamespaceFieldName() + ":" + this.getCurrentNamespace();
                LOG.trace((Object)("Deleting by query: " + deleteQuery));
                this.server.deleteByQuery(deleteQuery);
                this.server.commit();
                this.server.add(documents);
                this.server.commit();
            }
        }
        catch (SolrServerException e) {
            throw new ServiceException("Could not rebuild index", (Throwable)e);
        }
        finally {
            BroadleafRequestContext.setBroadleafRequestContext((BroadleafRequestContext)savedContext);
            SkuPricingConsiderationContext.setSkuPricingConsiderationContext(savedPricing);
            SkuPricingConsiderationContext.setSkuPricingService(savedPricingService);
        }
        LOG.info((Object)("Finished rebuilding the solr index in " + s.toLapString()));
    }

    protected List<Product> readAllActiveProducts() {
        return this.productDao.readAllActiveProducts(SystemTime.asDate());
    }

    protected List<Locale> getAllLocales() {
        return this.localeService.findAllLocales();
    }

    protected SolrInputDocument buildDocument(Product product, List<Field> fields, List<Locale> locales) {
        SolrInputDocument document = new SolrInputDocument();
        this.attachBasicDocumentFields(product, document);
        ArrayList<String> addedProperties = new ArrayList<String>();
        HashMap<String, ArrayList<String>> copyFieldValues = new HashMap<String, ArrayList<String>>();
        for (Field field : fields) {
            try {
                FieldType facetType;
                if (field.getSearchable().booleanValue()) {
                    for (FieldType sft : field.getSearchableFieldTypes()) {
                        Map<String, Object> propertyValues = this.getPropertyValues(product, field, sft, locales);
                        for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
                            ArrayList<String> copyFieldValue;
                            String prefix = entry.getKey();
                            prefix = StringUtils.isBlank((String)prefix) ? prefix : prefix + "_";
                            String solrPropertyName = this.getPropertyNameForFieldSearchable(field, sft, prefix);
                            Object value = entry.getValue();
                            if (sft.equals(FieldType.PRICE) || field.getTranslatable().booleanValue() || prefix.equals(this.getDefaultLocalePrefix())) {
                                document.addField(solrPropertyName, value);
                                addedProperties.add(solrPropertyName);
                            }
                            if ((copyFieldValue = (ArrayList<String>)copyFieldValues.get(prefix)) == null) {
                                copyFieldValue = new ArrayList<String>();
                                copyFieldValues.put(prefix, copyFieldValue);
                            }
                            copyFieldValue.add(value.toString());
                        }
                    }
                }
                if ((facetType = field.getFacetFieldType()) == null) continue;
                Map<String, Object> propertyValues = this.getPropertyValues(product, field, facetType, locales);
                for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
                    String prefix = entry.getKey();
                    prefix = StringUtils.isBlank((String)prefix) ? prefix : prefix + "_";
                    String solrFacetPropertyName = this.getPropertyNameForFieldFacet(field, prefix);
                    Object value = entry.getValue();
                    if (!facetType.equals(FieldType.PRICE) && !field.getTranslatable().booleanValue() && !prefix.equals(this.getDefaultLocalePrefix()) || addedProperties.contains(solrFacetPropertyName)) continue;
                    document.addField(solrFacetPropertyName, value);
                }
            }
            catch (Exception e) {
                LOG.trace((Object)("Could not get value for property[" + field.getQualifiedFieldName() + "] for product id[" + product.getId() + "]"));
            }
        }
        for (Map.Entry entry : copyFieldValues.entrySet()) {
            document.addField(this.getSearchableFieldName((String)entry.getKey()), (Object)StringUtils.join((Collection)((Collection)entry.getValue()), (String)" "));
        }
        return document;
    }

    protected void attachBasicDocumentFields(Product product, SolrInputDocument document) {
        document.addField(this.getNamespaceFieldName(), (Object)this.getCurrentNamespace());
        document.addField(this.getIdFieldName(), (Object)product.getId());
        for (Category category : product.getAllParentCategories()) {
            document.addField(this.getExplicitCategoryFieldName(), (Object)category.getId());
            String categorySortFieldName = this.getCategorySortFieldName(category);
            int listIndex = category.getAllProducts().indexOf(product);
            document.addField(categorySortFieldName, (Object)listIndex);
        }
        HashSet<Category> fullCategoryHierarchy = new HashSet<Category>();
        for (Category category : product.getAllParentCategories()) {
            fullCategoryHierarchy.addAll(category.buildFullCategoryHierarchy(null));
        }
        for (Category category : fullCategoryHierarchy) {
            document.addField(this.getCategoryFieldName(), (Object)category.getId());
        }
    }

    protected Map<String, Object> getPropertyValues(Product product, Field field, FieldType fieldType, List<Locale> locales) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String propertyName = field.getPropertyName();
        if (propertyName.contains("productAttributes.")) {
            propertyName = this.convertToMappedProperty(propertyName, "productAttributes", "mappedProductAttributes");
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (fieldType.equals(FieldType.PRICE)) {
            Object propertyValue = PropertyUtils.getProperty((Object)product, (String)propertyName);
            values.put("", propertyValue);
            if (this.extensionManager != null) {
                this.extensionManager.addPriceFieldPropertyValues(product, field, values, propertyName);
            }
        } else {
            for (Locale locale : locales) {
                String localeCode = locale.getLocaleCode();
                if (!field.getTranslatable().booleanValue() && !locale.getDefaultFlag().booleanValue()) {
                    locale = this.getDefaultLocale();
                }
                if (field.getTranslatable().booleanValue()) {
                    BroadleafRequestContext tempContext = new BroadleafRequestContext();
                    tempContext.setLocale(locale);
                    BroadleafRequestContext.setBroadleafRequestContext((BroadleafRequestContext)tempContext);
                }
                Object propertyValue = PropertyUtils.getProperty((Object)product, (String)propertyName);
                values.put(localeCode, propertyValue);
            }
        }
        return values;
    }

    @Override
    public ProductSearchResult findExplicitProductsByCategory(Category category, ProductSearchCriteria searchCriteria) throws ServiceException {
        List<SearchFacetDTO> facets = this.getCategoryFacets(category);
        String query = this.getExplicitCategoryFieldName() + ":" + category.getId();
        return this.findProducts(query, facets, searchCriteria, this.getCategorySortFieldName(category) + " asc");
    }

    @Override
    public ProductSearchResult findProductsByCategory(Category category, ProductSearchCriteria searchCriteria) throws ServiceException {
        List<SearchFacetDTO> facets = this.getCategoryFacets(category);
        String query = this.getCategoryFieldName() + ":" + category.getId();
        return this.findProducts(query, facets, searchCriteria, this.getCategorySortFieldName(category) + " asc");
    }

    @Override
    public ProductSearchResult findProductsByQuery(String query, ProductSearchCriteria searchCriteria) throws ServiceException {
        List<SearchFacetDTO> facets = this.getSearchFacets();
        query = this.sanitizeQuery(query);
        query = this.getSearchableFieldName() + ":(" + query + ")";
        return this.findProducts(query, facets, searchCriteria, null);
    }

    @Override
    public ProductSearchResult findProductsByCategoryAndQuery(Category category, String query, ProductSearchCriteria searchCriteria) throws ServiceException {
        List<SearchFacetDTO> facets = this.getSearchFacets();
        query = this.sanitizeQuery(query);
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCategoryFieldName()).append(":").append(category.getId()).append(" AND ").append(this.getSearchableFieldName()).append(":(").append(query).append(")");
        return this.findProducts(sb.toString(), facets, searchCriteria, null);
    }

    @Override
    public List<SearchFacetDTO> getSearchFacets() {
        return this.buildSearchFacetDTOs(this.searchFacetDao.readAllSearchFacets());
    }

    @Override
    public List<SearchFacetDTO> getCategoryFacets(Category category) {
        List<CategorySearchFacet> categorySearchFacets = category.getCumulativeSearchFacets();
        ArrayList<SearchFacet> searchFacets = new ArrayList<SearchFacet>();
        for (CategorySearchFacet categorySearchFacet : categorySearchFacets) {
            searchFacets.add(categorySearchFacet.getSearchFacet());
        }
        return this.buildSearchFacetDTOs(searchFacets);
    }

    protected ProductSearchResult findProducts(String qualifiedSolrQuery, List<SearchFacetDTO> facets, ProductSearchCriteria searchCriteria, String defaultSort) throws ServiceException {
        QueryResponse response;
        Map<String, SearchFacetDTO> namedFacetMap = this.getNamedFacetMap(facets, searchCriteria);
        SolrQuery solrQuery = new SolrQuery().setQuery(qualifiedSolrQuery).setFields(new String[]{this.getIdFieldName()}).setRows(searchCriteria.getPageSize()).setFilterQueries(new String[]{this.getNamespaceFieldName() + ":" + this.getCurrentNamespace()}).setStart(Integer.valueOf((searchCriteria.getPage() - 1) * searchCriteria.getPageSize()));
        this.attachSortClause(solrQuery, searchCriteria, defaultSort);
        this.attachActiveFacetFilters(solrQuery, namedFacetMap, searchCriteria);
        this.attachFacets(solrQuery, namedFacetMap);
        if (LOG.isTraceEnabled()) {
            try {
                LOG.trace((Object)URLDecoder.decode(solrQuery.toString(), "UTF-8"));
            }
            catch (Exception e) {
                LOG.trace((Object)("Couldn't UTF-8 URL Decode: " + solrQuery.toString()));
            }
        }
        try {
            response = this.server.query((SolrParams)solrQuery);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)response.toString());
                for (SolrDocument doc : response.getResults()) {
                    LOG.trace((Object)doc);
                }
            }
        }
        catch (SolrServerException e) {
            throw new ServiceException("Could not perform search", (Throwable)e);
        }
        this.setFacetResults(namedFacetMap, response);
        this.sortFacetResults(namedFacetMap);
        List<Product> products = this.getProducts(response);
        ProductSearchResult result = new ProductSearchResult();
        result.setFacets(facets);
        result.setProducts(products);
        this.setPagingAttributes(result, response, searchCriteria);
        return result;
    }

    protected void attachSortClause(SolrQuery query, ProductSearchCriteria searchCriteria, String defaultSort) {
        Map<String, String> solrFieldKeyMap = this.getSolrFieldKeyMap(searchCriteria);
        String sortQuery = searchCriteria.getSortQuery();
        if (StringUtils.isBlank((String)sortQuery)) {
            sortQuery = defaultSort;
        }
        if (StringUtils.isNotBlank((String)sortQuery)) {
            String[] sortFields;
            for (String sortField : sortFields = sortQuery.split(",")) {
                SolrQuery.ORDER order;
                String field = sortField.split(" ")[0];
                if (solrFieldKeyMap.containsKey(field)) {
                    field = solrFieldKeyMap.get(field);
                }
                SolrQuery.ORDER oRDER = order = "desc".equals(sortField.split(" ")[1]) ? SolrQuery.ORDER.desc : SolrQuery.ORDER.asc;
                if (field == null) continue;
                query.addSortField(field, order);
            }
        }
    }

    protected void attachActiveFacetFilters(SolrQuery query, Map<String, SearchFacetDTO> namedFacetMap, ProductSearchCriteria searchCriteria) {
        for (Map.Entry<String, String[]> entry : searchCriteria.getFilterCriteria().entrySet()) {
            String solrKey = null;
            for (Map.Entry<String, SearchFacetDTO> dtoEntry : namedFacetMap.entrySet()) {
                if (!dtoEntry.getValue().getFacet().getField().getAbbreviation().equals(entry.getKey())) continue;
                solrKey = dtoEntry.getKey();
                dtoEntry.getValue().setActive(true);
            }
            if (solrKey == null) continue;
            String solrTag = this.getSolrFieldTag(GLOBAL_FACET_TAG_FIELD, "tag");
            Object[] selectedValues = (String[])entry.getValue().clone();
            for (int i = 0; i < selectedValues.length; ++i) {
                if (selectedValues[i].contains("range[")) {
                    String rangeValue = ((String)selectedValues[i]).substring(((String)selectedValues[i]).indexOf(91) + 1, ((String)selectedValues[i]).indexOf(93));
                    String[] rangeValues = StringUtils.split((String)rangeValue, (char)':');
                    if (rangeValues[1].equals("null")) {
                        rangeValues[1] = "*";
                    }
                    selectedValues[i] = solrKey + ":[" + rangeValues[0] + " TO " + rangeValues[1] + "]";
                    continue;
                }
                selectedValues[i] = solrKey + ":\"" + (String)selectedValues[i] + "\"";
            }
            String valueString = StringUtils.join((Object[])selectedValues, (String)" OR ");
            StringBuilder sb = new StringBuilder();
            sb.append(solrTag).append("(").append(valueString).append(")");
            query.addFilterQuery(new String[]{sb.toString()});
        }
    }

    protected void attachFacets(SolrQuery query, Map<String, SearchFacetDTO> namedFacetMap) {
        query.setFacet(true);
        for (Map.Entry<String, SearchFacetDTO> entry : namedFacetMap.entrySet()) {
            SearchFacetDTO dto = entry.getValue();
            String facetTagField = entry.getValue().isActive() ? GLOBAL_FACET_TAG_FIELD : entry.getKey();
            List<SearchFacetRange> searchFacetRanges = dto.getFacet().getSearchFacetRanges();
            if (this.extensionManager != null) {
                this.extensionManager.filterSearchFacetRanges(dto, searchFacetRanges);
            }
            if (searchFacetRanges != null && searchFacetRanges.size() > 0) {
                for (SearchFacetRange range : searchFacetRanges) {
                    query.addFacetQuery(this.getSolrTaggedFieldString(entry.getKey(), facetTagField, "ex", range));
                }
                continue;
            }
            query.addFacetField(new String[]{this.getSolrTaggedFieldString(entry.getKey(), facetTagField, "ex", null)});
        }
    }

    protected void setFacetResults(Map<String, SearchFacetDTO> namedFacetMap, QueryResponse response) {
        if (response.getFacetFields() != null) {
            for (FacetField facetField : response.getFacetFields()) {
                String facetFieldName = facetField.getName();
                SearchFacetDTO facetDTO = namedFacetMap.get(facetFieldName);
                for (FacetField.Count value : facetField.getValues()) {
                    SearchFacetResultDTO resultDTO = new SearchFacetResultDTO();
                    resultDTO.setFacet(facetDTO.getFacet());
                    resultDTO.setQuantity(new Long(value.getCount()).intValue());
                    resultDTO.setValue(value.getName());
                    facetDTO.getFacetValues().add(resultDTO);
                }
            }
        }
        if (response.getFacetQuery() != null) {
            for (Map.Entry entry : response.getFacetQuery().entrySet()) {
                String key = (String)entry.getKey();
                String facetFieldName = key.substring(key.indexOf("}") + 1, key.indexOf(58));
                SearchFacetDTO facetDTO = namedFacetMap.get(facetFieldName);
                String minValue = key.substring(key.indexOf("[") + 1, key.indexOf(" TO"));
                String maxValue = key.substring(key.indexOf(" TO ") + 4, key.indexOf("]"));
                if (maxValue.equals("*")) {
                    maxValue = null;
                }
                SearchFacetResultDTO resultDTO = new SearchFacetResultDTO();
                resultDTO.setFacet(facetDTO.getFacet());
                resultDTO.setQuantity((Integer)entry.getValue());
                resultDTO.setMinValue(new BigDecimal(minValue));
                resultDTO.setMaxValue(maxValue == null ? null : new BigDecimal(maxValue));
                facetDTO.getFacetValues().add(resultDTO);
            }
        }
    }

    protected void sortFacetResults(Map<String, SearchFacetDTO> namedFacetMap) {
        for (Map.Entry<String, SearchFacetDTO> entry : namedFacetMap.entrySet()) {
            Collections.sort(entry.getValue().getFacetValues(), new Comparator<SearchFacetResultDTO>(){

                @Override
                public int compare(SearchFacetResultDTO o1, SearchFacetResultDTO o2) {
                    if (o1.getValue() != null && o2.getValue() != null) {
                        return o1.getValue().compareTo(o2.getValue());
                    }
                    if (o1.getMinValue() != null && o2.getMinValue() != null) {
                        return o1.getMinValue().compareTo(o2.getMinValue());
                    }
                    return 0;
                }
            });
        }
    }

    public void setPagingAttributes(ProductSearchResult result, QueryResponse response, ProductSearchCriteria searchCriteria) {
        result.setTotalResults(new Long(response.getResults().getNumFound()).intValue());
        result.setPage(searchCriteria.getPage());
        result.setPageSize(searchCriteria.getPageSize());
    }

    protected List<Product> getProducts(QueryResponse response) {
        final ArrayList<Long> productIds = new ArrayList<Long>();
        SolrDocumentList docs = response.getResults();
        for (SolrDocument doc : docs) {
            productIds.add((Long)doc.getFieldValue(this.getIdFieldName()));
        }
        List<Product> products = this.productDao.readProductsByIds(productIds);
        if (products != null) {
            Collections.sort(products, new Comparator<Product>(){

                @Override
                public int compare(Product o1, Product o2) {
                    return new Integer(productIds.indexOf(o1.getId())).compareTo(productIds.indexOf(o2.getId()));
                }
            });
        }
        return products;
    }

    protected String getSolrTaggedFieldString(String indexField, String tagField, String tag, SearchFacetRange range) {
        return this.getSolrFieldTag(tagField, tag) + this.getSolrFieldString(indexField, range);
    }

    protected String getSolrFieldTag(String tagField, String tag) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)tag)) {
            sb.append("{!").append(tag).append("=").append(tagField).append("}");
        }
        return sb.toString();
    }

    protected String getSolrFieldString(String indexField, SearchFacetRange range) {
        StringBuilder sb = new StringBuilder();
        sb.append(indexField);
        if (range != null) {
            String minValue = range.getMinValue().toPlainString();
            String maxValue = range.getMaxValue() == null ? "*" : range.getMaxValue().toPlainString();
            sb.append(":[").append(minValue).append(" TO ").append(maxValue).append("]");
        }
        return sb.toString();
    }

    protected List<SearchFacetDTO> buildSearchFacetDTOs(List<SearchFacet> searchFacets) {
        ArrayList<SearchFacetDTO> facets = new ArrayList<SearchFacetDTO>();
        HttpServletRequest request = BroadleafRequestContext.getBroadleafRequestContext().getRequest();
        for (SearchFacet facet : searchFacets) {
            if (!this.facetIsAvailable(facet, request)) continue;
            SearchFacetDTO dto = new SearchFacetDTO();
            dto.setFacet(facet);
            dto.setShowQuantity(true);
            facets.add(dto);
        }
        return facets;
    }

    protected boolean facetIsAvailable(SearchFacet facet, HttpServletRequest request) {
        if (CollectionUtils.isEmpty(facet.getRequiredFacets())) {
            return true;
        }
        Map params = request.getParameterMap();
        if (CollectionUtils.isEmpty((Map)params)) {
            return false;
        }
        int requiredMatches = facet.getRequiresAllDependentFacets() != false ? facet.getRequiredFacets().size() : 1;
        int matchesSoFar = 0;
        block0: for (RequiredFacet requiredFacet : facet.getRequiredFacets()) {
            if (requiredMatches == matchesSoFar) {
                return true;
            }
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.equals(requiredFacet.getRequiredFacet().getField().getAbbreviation())) continue;
                ++matchesSoFar;
                continue block0;
            }
        }
        return requiredMatches == matchesSoFar;
    }

    protected String convertToMappedProperty(String propertyName, String listPropertyName, String mapPropertyName) {
        String[] splitName = StringUtils.split((String)propertyName, (String)".");
        StringBuilder convertedProperty = new StringBuilder();
        for (int i = 0; i < splitName.length; ++i) {
            if (convertedProperty.length() > 0) {
                convertedProperty.append(".");
            }
            if (splitName[i].equals(listPropertyName)) {
                convertedProperty.append(mapPropertyName).append("(");
                convertedProperty.append(splitName[i + 1]).append(").value");
                ++i;
                continue;
            }
            convertedProperty.append(splitName[i]);
        }
        return convertedProperty.toString();
    }

    protected String getSolrFieldKey(Field field, ProductSearchCriteria searchCriteria) {
        return this.getPropertyNameForFieldFacet(field);
    }

    protected Map<String, String> getSolrFieldKeyMap(ProductSearchCriteria searchCriteria) {
        List<Field> fields = this.fieldDao.readAllProductFields();
        HashMap<String, String> solrFieldKeyMap = new HashMap<String, String>();
        for (Field field : fields) {
            solrFieldKeyMap.put(field.getAbbreviation(), this.getSolrFieldKey(field, searchCriteria));
        }
        return solrFieldKeyMap;
    }

    protected Map<String, SearchFacetDTO> getNamedFacetMap(List<SearchFacetDTO> facets, final ProductSearchCriteria searchCriteria) {
        return BLCMapUtils.keyedMap(facets, (TypedClosure)new TypedClosure<String, SearchFacetDTO>(){

            public String getKey(SearchFacetDTO facet) {
                return SolrSearchServiceImpl.this.getSolrFieldKey(facet.getFacet().getField(), searchCriteria);
            }
        });
    }

    protected String sanitizeQuery(String query) {
        return query.replace("(", "").replace("%28", "").replace(")", "").replace("%29", "").replace(":", "").replace("%3A", "").replace("%3a", "").replace("&quot;", "\"");
    }

    protected String getCurrentNamespace() {
        return DEFAULT_NAMESPACE;
    }

    protected String getLocalePrefix() {
        Locale locale;
        if (BroadleafRequestContext.getBroadleafRequestContext() != null && (locale = BroadleafRequestContext.getBroadleafRequestContext().getLocale()) != null) {
            return locale.getLocaleCode() + "_";
        }
        return this.getDefaultLocalePrefix();
    }

    protected Locale getDefaultLocale() {
        if (defaultLocale == null) {
            defaultLocale = this.localeService.findDefaultLocale();
        }
        return defaultLocale;
    }

    protected String getDefaultLocalePrefix() {
        return this.getDefaultLocale().getLocaleCode() + "_";
    }

    protected String getPropertyNameForFieldSearchable(Field field, FieldType searchableFieldType, String prefix) {
        return prefix + field.getPropertyName() + "_" + searchableFieldType.getType();
    }

    protected String getPropertyNameForFieldFacet(Field field, String prefix) {
        if (field.getFacetFieldType() == null) {
            return null;
        }
        return prefix + field.getPropertyName() + "_" + field.getFacetFieldType().getType();
    }

    protected String getPropertyNameForFieldSearchable(Field field, FieldType searchableFieldType) {
        String prefix = "";
        if (searchableFieldType.equals(FieldType.PRICE)) {
            if (this.extensionManager != null) {
                prefix = this.extensionManager.getPrefixForPriceField();
            }
        } else {
            prefix = field.getTranslatable() != false ? this.getLocalePrefix() : this.getDefaultLocalePrefix();
        }
        return this.getPropertyNameForFieldSearchable(field, searchableFieldType, prefix);
    }

    protected String getPropertyNameForFieldFacet(Field field) {
        FieldType fieldType = field.getFacetFieldType();
        if (fieldType == null) {
            return null;
        }
        String prefix = "";
        if (fieldType.equals(FieldType.PRICE)) {
            if (this.extensionManager != null) {
                prefix = this.extensionManager.getPrefixForPriceField();
            }
        } else {
            prefix = field.getTranslatable() != false ? this.getLocalePrefix() : this.getDefaultLocalePrefix();
        }
        return this.getPropertyNameForFieldFacet(field, prefix);
    }

    protected String getNamespaceFieldName() {
        return "namespace";
    }

    protected String getIdFieldName() {
        return "id";
    }

    protected String getCategoryFieldName() {
        return "category";
    }

    protected String getExplicitCategoryFieldName() {
        return "explicitCategory";
    }

    protected String getSearchableFieldName(String prefix) {
        return prefix + "searchable";
    }

    protected String getSearchableFieldName() {
        return this.getSearchableFieldName(this.getLocalePrefix());
    }

    protected String getCategorySortFieldName(Category category) {
        return this.getCategoryFieldName() + "_" + category.getId() + "_" + "sort_i";
    }
}

