/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service.module;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.CreditCardValidator;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.payment.domain.CreditCardPaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItemImpl;
import org.broadleafcommerce.core.payment.service.PaymentContext;
import org.broadleafcommerce.core.payment.service.exception.PaymentException;
import org.broadleafcommerce.core.payment.service.module.AbstractModule;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoAdditionalFieldType;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.joda.time.DateTime;

public class NullCreditCardPaymentModule
extends AbstractModule {
    @Override
    public PaymentResponseItem authorize(PaymentContext paymentContext) throws PaymentException {
        throw new PaymentException("authorize not implemented.");
    }

    @Override
    public PaymentResponseItem reverseAuthorize(PaymentContext paymentContext) throws PaymentException {
        throw new PaymentException("reverse authorize not implemented.");
    }

    @Override
    public PaymentResponseItem authorizeAndDebit(PaymentContext paymentContext) throws PaymentException {
        PaymentInfo paymentInfo = null;
        for (PaymentInfo pi : paymentContext.getPaymentInfo().getOrder().getPaymentInfos()) {
            if (!PaymentInfoType.CREDIT_CARD.equals(pi.getType())) continue;
            paymentInfo = pi;
        }
        if (paymentInfo == null) {
            throw new PaymentException("PaymentInfo of type CREDIT_CARD must be on the order");
        }
        CreditCardPaymentInfo ccInfo = (CreditCardPaymentInfo)paymentContext.getReferencedPaymentInfo();
        String nameOnCard = ccInfo.getNameOnCard();
        String ccNumber = ccInfo.getPan().replaceAll("[\\s-]+", "");
        Integer expMonth = ccInfo.getExpirationMonth();
        Integer expYear = ccInfo.getExpirationYear();
        String cvv = ccInfo.getCvvCode();
        CreditCardValidator visaValidator = new CreditCardValidator(2);
        CreditCardValidator amexValidator = new CreditCardValidator(1);
        CreditCardValidator mcValidator = new CreditCardValidator(4);
        CreditCardValidator discoverValidator = new CreditCardValidator(8);
        boolean validCard = false;
        String cardType = "UNKNOWN";
        if (visaValidator.isValid(ccNumber)) {
            validCard = true;
            cardType = "VISA";
        } else if (amexValidator.isValid(ccNumber)) {
            validCard = true;
            cardType = "AMEX";
        } else if (mcValidator.isValid(ccNumber)) {
            validCard = true;
            cardType = "MASTERCARD";
        } else if (discoverValidator.isValid(ccNumber)) {
            validCard = true;
            cardType = "DISCOVER";
        }
        DateTime expirationDate = new DateTime(expYear.intValue(), expMonth.intValue(), 1, 0, 0);
        boolean validDate = expirationDate.isAfterNow();
        boolean validCVV = !cvv.equals("000");
        PaymentResponseItemImpl responseItem = new PaymentResponseItemImpl();
        responseItem.setTransactionTimestamp(SystemTime.asDate());
        responseItem.setTransactionSuccess(validDate && validCard && validCVV);
        responseItem.setAmountPaid(paymentInfo.getAmount());
        responseItem.setCurrency(paymentInfo.getOrder().getCurrency());
        if (responseItem.getTransactionSuccess().booleanValue()) {
            HashMap<String, String> additionalFields = new HashMap<String, String>();
            additionalFields.put(PaymentInfoAdditionalFieldType.NAME_ON_CARD.getType(), nameOnCard);
            additionalFields.put(PaymentInfoAdditionalFieldType.CARD_TYPE.getType(), cardType);
            additionalFields.put(PaymentInfoAdditionalFieldType.EXP_MONTH.getType(), expMonth + "");
            additionalFields.put(PaymentInfoAdditionalFieldType.EXP_YEAR.getType(), expYear + "");
            additionalFields.put(PaymentInfoAdditionalFieldType.LAST_FOUR.getType(), StringUtils.right((String)ccNumber, (int)4));
            paymentInfo.setAdditionalFields(additionalFields);
        }
        return responseItem;
    }

    @Override
    public PaymentResponseItem debit(PaymentContext paymentContext) throws PaymentException {
        throw new PaymentException("debit not implemented.");
    }

    @Override
    public PaymentResponseItem credit(PaymentContext paymentContext) throws PaymentException {
        throw new PaymentException("credit not implemented.");
    }

    @Override
    public PaymentResponseItem voidPayment(PaymentContext paymentContext) throws PaymentException {
        throw new PaymentException("voidPayment not implemented.");
    }

    @Override
    public PaymentResponseItem balance(PaymentContext paymentContext) throws PaymentException {
        throw new PaymentException("balance not implemented.");
    }

    @Override
    public Boolean isValidCandidate(PaymentInfoType paymentType) {
        return PaymentInfoType.CREDIT_CARD.equals(paymentType);
    }
}

