/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.workflow.remove;

import javax.annotation.Resource;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderMultishipOptionService;
import org.broadleafcommerce.core.order.service.workflow.CartOperationContext;
import org.broadleafcommerce.core.order.service.workflow.CartOperationRequest;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class RemoveOrderMultishipOptionActivity
extends BaseActivity {
    @Resource(name="blOrderMultishipOptionService")
    protected OrderMultishipOptionService orderMultishipOptionService;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;

    @Override
    public ProcessContext execute(ProcessContext context) throws Exception {
        CartOperationRequest request = ((CartOperationContext)context).getSeedData();
        Long orderItemId = request.getItemRequest().getOrderItemId();
        OrderItem orderItem = this.orderItemService.readOrderItemById(orderItemId);
        if (orderItem instanceof BundleOrderItem) {
            for (DiscreteOrderItem discrete : ((BundleOrderItem)orderItem).getDiscreteOrderItems()) {
                this.orderMultishipOptionService.deleteOrderItemOrderMultishipOptions(discrete.getId());
            }
        } else {
            this.orderMultishipOptionService.deleteOrderItemOrderMultishipOptions(orderItemId);
        }
        return context;
    }
}

