/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOfferImpl;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustmentImpl;
import org.broadleafcommerce.core.order.domain.BundleOrderItemImpl;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupFee;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupFeeImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItemImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentOption;
import org.broadleafcommerce.core.order.domain.FulfillmentOptionImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.PersonalMessage;
import org.broadleafcommerce.core.order.domain.PersonalMessageImpl;
import org.broadleafcommerce.core.order.domain.TaxDetail;
import org.broadleafcommerce.core.order.domain.TaxDetailImpl;
import org.broadleafcommerce.core.order.service.type.FulfillmentGroupStatusType;
import org.broadleafcommerce.core.order.service.type.FulfillmentType;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.core.domain.PhoneImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_FULFILLMENT_GROUP")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="FulfillmentGroupImpl_baseFulfillmentGroup")
public class FulfillmentGroupImpl
implements FulfillmentGroup {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="FulfillmentGroupId", strategy=GenerationType.TABLE)
    @TableGenerator(name="FulfillmentGroupId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="FulfillmentGroupImpl", allocationSize=50)
    @Column(name="FULFILLMENT_GROUP_ID")
    protected Long id;
    @Column(name="REFERENCE_NUMBER")
    @Index(name="FG_REFERENCE_INDEX", columnNames={"REFERENCE_NUMBER"})
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Reference_Number", order=1, group="FulfillmentGroupImpl_Description", prominent=true)
    protected String referenceNumber;
    @Column(name="METHOD")
    @Index(name="FG_METHOD_INDEX", columnNames={"METHOD"})
    @AdminPresentation(excluded=true, friendlyName="FulfillmentGroupImpl_Shipping_Method", order=2, group="FulfillmentGroupImpl_Description", prominent=true)
    @Deprecated
    protected String method;
    @Column(name="SERVICE")
    @Index(name="FG_SERVICE_INDEX", columnNames={"SERVICE"})
    @AdminPresentation(excluded=true, friendlyName="FulfillmentGroupImpl_Shipping_Service", order=3, group="FulfillmentGroupImpl_Description", prominent=true)
    @Deprecated
    protected String service;
    @Column(name="RETAIL_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_Retail_Shipping_Price", order=1, group="FulfillmentGroupImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal retailShippingPrice;
    @Column(name="SALE_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_Sale_Shipping_Price", order=2, group="FulfillmentGroupImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal saleShippingPrice;
    @Column(name="PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_Shipping_Price", order=3, group="FulfillmentGroupImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal shippingPrice;
    @Column(name="TYPE")
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Type", order=4, group="FulfillmentGroupImpl_Description", fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.order.service.type.FulfillmentType")
    protected String type;
    @Column(name="TOTAL_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Total_Tax", order=9, group="FulfillmentGroupImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal totalTax;
    @Column(name="TOTAL_ITEM_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Total_Item_Tax", order=9, group="FulfillmentGroupImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal totalItemTax;
    @Column(name="TOTAL_FEE_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Total_Fee_Tax", order=9, group="FulfillmentGroupImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal totalFeeTax;
    @Column(name="TOTAL_FG_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Total_FG_Tax", order=9, group="FulfillmentGroupImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal totalFulfillmentGroupTax;
    @Column(name="DELIVERY_INSTRUCTION")
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Delivery_Instruction", order=4, group="FulfillmentGroupImpl_Description")
    protected String deliveryInstruction;
    @Column(name="IS_PRIMARY")
    @Index(name="FG_PRIMARY_INDEX", columnNames={"IS_PRIMARY"})
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_Primary_FG", order=5, group="FulfillmentGroupImpl_Description")
    protected boolean primary = false;
    @Column(name="MERCHANDISE_TOTAL", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Merchandise_Total", order=10, group="FulfillmentGroupImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal merchandiseTotal;
    @Column(name="TOTAL", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Total", order=11, group="FulfillmentGroupImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal total;
    @Column(name="STATUS")
    @Index(name="FG_STATUS_INDEX", columnNames={"STATUS"})
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_FG_Status", order=6, group="FulfillmentGroupImpl_Description", fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.order.service.type.FulfillmentGroupStatusType")
    protected String status;
    @Column(name="SHIPPING_PRICE_TAXABLE")
    @AdminPresentation(friendlyName="FulfillmentGroupImpl_Shipping_Price_Taxable", order=7, group="FulfillmentGroupImpl_Pricing")
    protected Boolean isShippingPriceTaxable = Boolean.FALSE;
    @ManyToOne(targetEntity=FulfillmentOptionImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="FULFILLMENT_OPTION_ID")
    protected FulfillmentOption fulfillmentOption;
    @ManyToOne(targetEntity=OrderImpl.class, optional=false)
    @JoinColumn(name="ORDER_ID")
    @Index(name="FG_ORDER_INDEX", columnNames={"ORDER_ID"})
    @AdminPresentation(excluded=true, visibility=VisibilityEnum.HIDDEN_ALL)
    protected Order order;
    @ManyToOne(targetEntity=AddressImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="ADDRESS_ID")
    @Index(name="FG_ADDRESS_INDEX", columnNames={"ADDRESS_ID"})
    protected Address address;
    @ManyToOne(targetEntity=PhoneImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="PHONE_ID")
    @Index(name="FG_PHONE_INDEX", columnNames={"PHONE_ID"})
    protected Phone phone;
    @ManyToOne(targetEntity=PersonalMessageImpl.class, cascade={CascadeType.ALL})
    @JoinColumn(name="PERSONAL_MESSAGE_ID")
    @Index(name="FG_MESSAGE_INDEX", columnNames={"PERSONAL_MESSAGE_ID"})
    protected PersonalMessage personalMessage;
    @OneToMany(mappedBy="fulfillmentGroup", targetEntity=FulfillmentGroupItemImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<FulfillmentGroupItem> fulfillmentGroupItems = new ArrayList<FulfillmentGroupItem>();
    @OneToMany(mappedBy="fulfillmentGroup", targetEntity=FulfillmentGroupFeeImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<FulfillmentGroupFee> fulfillmentGroupFees = new ArrayList<FulfillmentGroupFee>();
    @OneToMany(mappedBy="fulfillmentGroup", targetEntity=CandidateFulfillmentGroupOfferImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<CandidateFulfillmentGroupOffer> candidateOffers = new ArrayList<CandidateFulfillmentGroupOffer>();
    @OneToMany(mappedBy="fulfillmentGroup", targetEntity=FulfillmentGroupAdjustmentImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<FulfillmentGroupAdjustment> fulfillmentGroupAdjustments = new ArrayList<FulfillmentGroupAdjustment>();
    @OneToMany(fetch=FetchType.LAZY, targetEntity=TaxDetailImpl.class, cascade={CascadeType.ALL})
    @JoinTable(name="BLC_FG_FG_TAX_XREF", joinColumns={@JoinColumn(name="FULFILLMENT_GROUP_ID")}, inverseJoinColumns={@JoinColumn(name="TAX_DETAIL_ID")})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<TaxDetail> taxes = new ArrayList<TaxDetail>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Order order) {
        this.order = order;
    }

    @Override
    public FulfillmentOption getFulfillmentOption() {
        return this.fulfillmentOption;
    }

    @Override
    public void setFulfillmentOption(FulfillmentOption fulfillmentOption) {
        this.fulfillmentOption = fulfillmentOption;
    }

    @Override
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    @Override
    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    @Override
    public List<FulfillmentGroupItem> getFulfillmentGroupItems() {
        return this.fulfillmentGroupItems;
    }

    @Override
    public List<DiscreteOrderItem> getDiscreteOrderItems() {
        ArrayList<DiscreteOrderItem> discreteOrderItems = new ArrayList<DiscreteOrderItem>();
        for (FulfillmentGroupItem fgItem : this.fulfillmentGroupItems) {
            OrderItem orderItem = fgItem.getOrderItem();
            if (orderItem instanceof BundleOrderItemImpl) {
                BundleOrderItemImpl bundleOrderItem = (BundleOrderItemImpl)orderItem;
                for (DiscreteOrderItem discreteOrderItem : bundleOrderItem.getDiscreteOrderItems()) {
                    discreteOrderItems.add(discreteOrderItem);
                }
                continue;
            }
            DiscreteOrderItem discreteOrderItem = (DiscreteOrderItem)orderItem;
            discreteOrderItems.add(discreteOrderItem);
        }
        return discreteOrderItems;
    }

    @Override
    public void setFulfillmentGroupItems(List<FulfillmentGroupItem> fulfillmentGroupItems) {
        this.fulfillmentGroupItems = fulfillmentGroupItems;
    }

    @Override
    public void addFulfillmentGroupItem(FulfillmentGroupItem fulfillmentGroupItem) {
        if (this.fulfillmentGroupItems == null) {
            this.fulfillmentGroupItems = new Vector<FulfillmentGroupItem>();
        }
        this.fulfillmentGroupItems.add(fulfillmentGroupItem);
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(Address address) {
        this.address = address;
    }

    @Override
    public Phone getPhone() {
        return this.phone;
    }

    @Override
    public void setPhone(Phone phone) {
        this.phone = phone;
    }

    @Override
    @Deprecated
    public String getMethod() {
        return this.method;
    }

    @Override
    @Deprecated
    public void setMethod(String fulfillmentMethod) {
        this.method = fulfillmentMethod;
    }

    @Override
    public Money getRetailShippingPrice() {
        return this.retailShippingPrice == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.retailShippingPrice, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setRetailShippingPrice(Money retailShippingPrice) {
        this.retailShippingPrice = Money.toAmount((Money)retailShippingPrice);
    }

    @Override
    public FulfillmentType getType() {
        return FulfillmentType.getInstance(this.type);
    }

    @Override
    public void setType(FulfillmentType type) {
        this.type = type == null ? null : type.getType();
    }

    @Override
    public void addCandidateFulfillmentGroupOffer(CandidateFulfillmentGroupOffer candidateOffer) {
        this.candidateOffers.add(candidateOffer);
    }

    @Override
    public List<CandidateFulfillmentGroupOffer> getCandidateFulfillmentGroupOffers() {
        return this.candidateOffers;
    }

    @Override
    public void setCandidateFulfillmentGroupOffer(List<CandidateFulfillmentGroupOffer> candidateOffers) {
        this.candidateOffers = candidateOffers;
    }

    @Override
    public void removeAllCandidateOffers() {
        if (this.candidateOffers != null) {
            for (CandidateFulfillmentGroupOffer offer : this.candidateOffers) {
                offer.setFulfillmentGroup(null);
            }
            this.candidateOffers.clear();
        }
    }

    @Override
    public List<FulfillmentGroupAdjustment> getFulfillmentGroupAdjustments() {
        return this.fulfillmentGroupAdjustments;
    }

    @Override
    public Money getFulfillmentGroupAdjustmentsValue() {
        Money adjustmentsValue = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)this.getOrder().getCurrency());
        for (FulfillmentGroupAdjustment adjustment : this.fulfillmentGroupAdjustments) {
            adjustmentsValue = adjustmentsValue.add(adjustment.getValue());
        }
        return adjustmentsValue;
    }

    @Override
    public void removeAllAdjustments() {
        if (this.fulfillmentGroupAdjustments != null) {
            for (FulfillmentGroupAdjustment adjustment : this.fulfillmentGroupAdjustments) {
                adjustment.setFulfillmentGroup(null);
            }
            this.fulfillmentGroupAdjustments.clear();
        }
    }

    @Override
    public void setFulfillmentGroupAdjustments(List<FulfillmentGroupAdjustment> fulfillmentGroupAdjustments) {
        this.fulfillmentGroupAdjustments = fulfillmentGroupAdjustments;
    }

    @Override
    public Money getSaleShippingPrice() {
        return this.saleShippingPrice == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.saleShippingPrice, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setSaleShippingPrice(Money saleShippingPrice) {
        this.saleShippingPrice = Money.toAmount((Money)saleShippingPrice);
    }

    @Override
    public Money getShippingPrice() {
        return this.shippingPrice == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.shippingPrice, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setShippingPrice(Money shippingPrice) {
        this.shippingPrice = Money.toAmount((Money)shippingPrice);
    }

    @Override
    public List<TaxDetail> getTaxes() {
        return this.taxes;
    }

    @Override
    public void setTaxes(List<TaxDetail> taxes) {
        this.taxes = taxes;
    }

    @Override
    public Money getTotalTax() {
        return this.totalTax == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.totalTax, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setTotalTax(Money totalTax) {
        this.totalTax = Money.toAmount((Money)totalTax);
    }

    @Override
    public Money getTotalItemTax() {
        return this.totalItemTax == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.totalItemTax, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setTotalItemTax(Money totalItemTax) {
        this.totalItemTax = Money.toAmount((Money)totalItemTax);
    }

    @Override
    public Money getTotalFeeTax() {
        return this.totalFeeTax == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.totalFeeTax, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setTotalFeeTax(Money totalFeeTax) {
        this.totalFeeTax = Money.toAmount((Money)totalFeeTax);
    }

    @Override
    public Money getTotalFulfillmentGroupTax() {
        return this.totalFulfillmentGroupTax == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.totalFulfillmentGroupTax, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setTotalFulfillmentGroupTax(Money totalFulfillmentGroupTax) {
        this.totalFulfillmentGroupTax = Money.toAmount((Money)totalFulfillmentGroupTax);
    }

    @Override
    public String getDeliveryInstruction() {
        return this.deliveryInstruction;
    }

    @Override
    public void setDeliveryInstruction(String deliveryInstruction) {
        this.deliveryInstruction = deliveryInstruction;
    }

    @Override
    public PersonalMessage getPersonalMessage() {
        return this.personalMessage;
    }

    @Override
    public void setPersonalMessage(PersonalMessage personalMessage) {
        this.personalMessage = personalMessage;
    }

    @Override
    public boolean isPrimary() {
        return this.primary;
    }

    @Override
    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    @Override
    public Money getMerchandiseTotal() {
        return this.merchandiseTotal == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.merchandiseTotal, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setMerchandiseTotal(Money merchandiseTotal) {
        this.merchandiseTotal = Money.toAmount((Money)merchandiseTotal);
    }

    @Override
    public Money getTotal() {
        return this.total == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.total, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setTotal(Money orderTotal) {
        this.total = Money.toAmount((Money)orderTotal);
    }

    @Override
    public FulfillmentGroupStatusType getStatus() {
        return FulfillmentGroupStatusType.getInstance(this.status);
    }

    @Override
    public void setStatus(FulfillmentGroupStatusType status) {
        this.status = status.getType();
    }

    @Override
    public List<FulfillmentGroupFee> getFulfillmentGroupFees() {
        return this.fulfillmentGroupFees;
    }

    @Override
    public void setFulfillmentGroupFees(List<FulfillmentGroupFee> fulfillmentGroupFees) {
        this.fulfillmentGroupFees = fulfillmentGroupFees;
    }

    @Override
    public void addFulfillmentGroupFee(FulfillmentGroupFee fulfillmentGroupFee) {
        if (this.fulfillmentGroupFees == null) {
            this.fulfillmentGroupFees = new ArrayList<FulfillmentGroupFee>();
        }
        this.fulfillmentGroupFees.add(fulfillmentGroupFee);
    }

    @Override
    public void removeAllFulfillmentGroupFees() {
        if (this.fulfillmentGroupFees != null) {
            this.fulfillmentGroupFees.clear();
        }
    }

    @Override
    public Boolean isShippingPriceTaxable() {
        return this.isShippingPriceTaxable;
    }

    @Override
    public void setIsShippingPriceTaxable(Boolean isShippingPriceTaxable) {
        this.isShippingPriceTaxable = isShippingPriceTaxable;
    }

    @Override
    @Deprecated
    public String getService() {
        return this.service;
    }

    @Override
    @Deprecated
    public void setService(String service) {
        this.service = service;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.fulfillmentGroupItems == null ? 0 : ((Object)this.fulfillmentGroupItems).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FulfillmentGroupImpl other = (FulfillmentGroupImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        return !(this.fulfillmentGroupItems == null ? other.fulfillmentGroupItems != null : !((Object)this.fulfillmentGroupItems).equals(other.fulfillmentGroupItems));
    }
}

