/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.core.order.dao.OrderMultishipOptionDao;
import org.broadleafcommerce.core.order.domain.OrderMultishipOption;
import org.springframework.stereotype.Repository;

@Repository(value="blOrderMultishipOptionDao")
public class OrderMultishipOptionDaoImpl
implements OrderMultishipOptionDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public OrderMultishipOption save(OrderMultishipOption orderMultishipOption) {
        return (OrderMultishipOption)this.em.merge((Object)orderMultishipOption);
    }

    @Override
    public List<OrderMultishipOption> readOrderMultishipOptions(Long orderId) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_MULTISHIP_OPTIONS_BY_ORDER_ID", OrderMultishipOption.class);
        query.setParameter("orderId", (Object)orderId);
        return query.getResultList();
    }

    @Override
    public List<OrderMultishipOption> readOrderItemOrderMultishipOptions(Long orderItemId) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_MULTISHIP_OPTIONS_BY_ORDER_ITEM_ID", OrderMultishipOption.class);
        query.setParameter("orderItemId", (Object)orderItemId);
        return query.getResultList();
    }

    @Override
    public OrderMultishipOption create() {
        return (OrderMultishipOption)this.entityConfiguration.createEntityInstance(OrderMultishipOption.class.getName());
    }

    @Override
    public void deleteAll(List<OrderMultishipOption> options) {
        for (OrderMultishipOption option : options) {
            this.em.remove((Object)option);
        }
    }
}

