/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.CandidateOrderOffer;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferRule;
import org.broadleafcommerce.core.offer.domain.OrderAdjustment;
import org.broadleafcommerce.core.offer.service.OrderItemMergeService;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateOrderOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.processor.AbstractBaseProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessor;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.offer.service.type.OfferRuleType;
import org.springframework.stereotype.Service;

@Service(value="blOrderOfferProcessor")
public class OrderOfferProcessorImpl
extends AbstractBaseProcessor
implements OrderOfferProcessor {
    private static final Log LOG = LogFactory.getLog(OrderOfferProcessorImpl.class);
    @Resource(name="blOfferDao")
    protected OfferDao offerDao;
    @Resource(name="blPromotableItemFactory")
    protected PromotableItemFactory promotableItemFactory;
    @Resource(name="blOrderItemMergeService")
    protected OrderItemMergeService orderItemMergeService;

    @Override
    public void filterOrderLevelOffer(PromotableOrder order, List<PromotableCandidateOrderOffer> qualifiedOrderOffers, Offer offer) {
        CandidatePromotionItems candidates;
        boolean orderLevelQualification;
        block6: {
            if (offer.getDiscountType().getType().equals(OfferDiscountType.FIX_PRICE.getType())) {
                LOG.warn((Object)("Offers of type ORDER may not have a discount type of FIX_PRICE. Ignoring order offer (name=" + offer.getName() + ")"));
                return;
            }
            orderLevelQualification = false;
            if (this.couldOfferApplyToOrder(offer, order)) {
                orderLevelQualification = true;
            } else {
                for (PromotableOrderItem discreteOrderItem : order.getDiscountableDiscreteOrderItems(offer.getApplyDiscountToSalePrice())) {
                    if (!this.couldOfferApplyToOrder(offer, order, discreteOrderItem)) continue;
                    orderLevelQualification = true;
                    break block6;
                }
                for (PromotableFulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
                    if (!this.couldOfferApplyToOrder(offer, order, fulfillmentGroup)) continue;
                    orderLevelQualification = true;
                    break;
                }
            }
        }
        if (orderLevelQualification && (candidates = this.couldOfferApplyToOrderItems(offer, order.getDiscountableDiscreteOrderItems(offer.getApplyDiscountToSalePrice()))).isMatchedQualifier()) {
            PromotableCandidateOrderOffer candidateOffer = this.createCandidateOrderOffer(order, qualifiedOrderOffers, offer);
            candidateOffer.getCandidateQualifiersMap().putAll(candidates.getCandidateQualifiersMap());
        }
    }

    @Override
    public boolean couldOfferApplyToOrder(Offer offer, PromotableOrder order) {
        return this.couldOfferApplyToOrder(offer, order, null, null);
    }

    protected boolean couldOfferApplyToOrder(Offer offer, PromotableOrder order, PromotableOrderItem discreteOrderItem) {
        return this.couldOfferApplyToOrder(offer, order, discreteOrderItem, null);
    }

    protected boolean couldOfferApplyToOrder(Offer offer, PromotableOrder order, PromotableFulfillmentGroup fulfillmentGroup) {
        return this.couldOfferApplyToOrder(offer, order, null, fulfillmentGroup);
    }

    protected boolean couldOfferApplyToOrder(Offer offer, PromotableOrder order, PromotableOrderItem discreteOrderItem, PromotableFulfillmentGroup fulfillmentGroup) {
        boolean appliesToItem = false;
        String rule = null;
        if (offer.getAppliesToOrderRules() != null && offer.getAppliesToOrderRules().trim().length() != 0) {
            rule = offer.getAppliesToOrderRules();
        } else {
            OfferRule orderRule = offer.getOfferMatchRules().get(OfferRuleType.ORDER.getType());
            if (orderRule != null) {
                rule = orderRule.getMatchRule();
            }
        }
        if (rule != null) {
            Boolean expressionOutcome;
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("order", order.getDelegate());
            vars.put("offer", offer);
            if (fulfillmentGroup != null) {
                vars.put("fulfillmentGroup", fulfillmentGroup.getDelegate());
            }
            if (discreteOrderItem != null) {
                vars.put("discreteOrderItem", discreteOrderItem.getDelegate());
            }
            if ((expressionOutcome = this.executeExpression(rule, vars)) != null && expressionOutcome.booleanValue()) {
                appliesToItem = true;
            }
        } else {
            appliesToItem = true;
        }
        return appliesToItem;
    }

    protected PromotableCandidateOrderOffer createCandidateOrderOffer(PromotableOrder order, List<PromotableCandidateOrderOffer> qualifiedOrderOffers, Offer offer) {
        CandidateOrderOffer candidateOffer = this.offerDao.createCandidateOrderOffer();
        candidateOffer.setOrder(order.getDelegate());
        candidateOffer.setOffer(offer);
        PromotableCandidateOrderOffer promotableCandidateOrderOffer = this.promotableItemFactory.createPromotableCandidateOrderOffer(candidateOffer, order);
        qualifiedOrderOffers.add(promotableCandidateOrderOffer);
        return promotableCandidateOrderOffer;
    }

    @Override
    public List<PromotableCandidateOrderOffer> removeTrailingNotCombinableOrderOffers(List<PromotableCandidateOrderOffer> candidateOffers) {
        ArrayList<PromotableCandidateOrderOffer> remainingCandidateOffers = new ArrayList<PromotableCandidateOrderOffer>();
        int offerCount = 0;
        for (PromotableCandidateOrderOffer candidateOffer : candidateOffers) {
            if (offerCount == 0) {
                remainingCandidateOffers.add(candidateOffer);
            } else {
                boolean treatAsNewFormat = false;
                if (candidateOffer.getOffer().getTreatAsNewFormat() != null && candidateOffer.getOffer().getTreatAsNewFormat().booleanValue()) {
                    treatAsNewFormat = true;
                }
                if (!treatAsNewFormat && candidateOffer.getOffer().isCombinableWithOtherOffers() || treatAsNewFormat && (candidateOffer.getOffer().isTotalitarianOffer() == null || !candidateOffer.getOffer().isTotalitarianOffer().booleanValue())) {
                    remainingCandidateOffers.add(candidateOffer);
                }
            }
            ++offerCount;
        }
        return remainingCandidateOffers;
    }

    @Override
    public boolean applyAllOrderOffers(List<PromotableCandidateOrderOffer> orderOffers, PromotableOrder order) {
        boolean orderOffersApplied = false;
        Iterator<PromotableCandidateOrderOffer> orderOfferIterator = orderOffers.iterator();
        while (orderOfferIterator.hasNext()) {
            PromotableCandidateOrderOffer orderOffer = orderOfferIterator.next();
            if (orderOffer.getOffer().getTreatAsNewFormat() == null || !orderOffer.getOffer().getTreatAsNewFormat().booleanValue()) {
                if (!orderOffer.getOffer().isStackable() && order.isHasOrderAdjustments()) continue;
                boolean alreadyContainsNotCombinableOfferAtAnyLevel = order.isNotCombinableOfferAppliedAtAnyLevel();
                this.applyOrderOffer(order, orderOffer);
                orderOffersApplied = true;
                if (orderOffer.getOffer().isCombinableWithOtherOffers() && !alreadyContainsNotCombinableOfferAtAnyLevel) continue;
                if (orderOffersApplied = this.compareAndAdjustOrderAndItemOffers(order, orderOffersApplied)) break;
                orderOfferIterator.remove();
                continue;
            }
            if (order.containsNotStackableOrderOffer() && order.isHasOrderAdjustments()) continue;
            boolean alreadyContainsTotalitarianOffer = order.isTotalitarianOfferApplied();
            this.applyOrderOffer(order, orderOffer);
            orderOffersApplied = true;
            if (orderOffer.getOffer().isTotalitarianOffer() != null && orderOffer.getOffer().isTotalitarianOffer().booleanValue() || alreadyContainsTotalitarianOffer) {
                if (orderOffersApplied = this.compareAndAdjustOrderAndItemOffers(order, orderOffersApplied)) break;
                orderOfferIterator.remove();
                continue;
            }
            if (orderOffer.getOffer().isCombinableWithOtherOffers()) continue;
            break;
        }
        return orderOffersApplied;
    }

    protected boolean compareAndAdjustOrderAndItemOffers(PromotableOrder order, boolean orderOffersApplied) {
        if (order.getAdjustmentPrice().greaterThanOrEqual(order.calculateOrderItemsCurrentPrice())) {
            order.removeAllOrderAdjustments();
            orderOffersApplied = false;
        } else {
            order.removeAllItemAdjustments();
            this.orderItemMergeService.gatherCart(order);
            this.orderItemMergeService.initializeSplitItems(order);
        }
        return orderOffersApplied;
    }

    protected void applyOrderOffer(PromotableOrder order, PromotableCandidateOrderOffer orderOffer) {
        OrderAdjustment orderAdjustment = this.offerDao.createOrderAdjustment();
        orderAdjustment.init(order.getDelegate(), orderOffer.getOffer(), orderOffer.getOffer().getName());
        PromotableOrderAdjustment promotableOrderAdjustment = this.promotableItemFactory.createPromotableOrderAdjustment(orderAdjustment, order);
        order.addOrderAdjustments(promotableOrderAdjustment);
    }

    @Override
    public void compileOrderTotal(PromotableOrder order) {
        order.assignOrderItemsFinalPrice();
        order.setSubTotal(order.calculateOrderItemsFinalPrice(true));
    }

    @Override
    public OfferDao getOfferDao() {
        return this.offerDao;
    }

    @Override
    public void setOfferDao(OfferDao offerDao) {
        this.offerDao = offerDao;
    }

    @Override
    public PromotableItemFactory getPromotableItemFactory() {
        return this.promotableItemFactory;
    }

    @Override
    public void setPromotableItemFactory(PromotableItemFactory promotableItemFactory) {
        this.promotableItemFactory = promotableItemFactory;
    }

    @Override
    public OrderItemMergeService getOrderItemMergeService() {
        return this.orderItemMergeService;
    }

    @Override
    public void setOrderItemMergeService(OrderItemMergeService orderItemMergeService) {
        this.orderItemMergeService = orderItemMergeService;
    }
}

