/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.OrderAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderAdjustment;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;

public class PromotableOrderAdjustmentImpl
implements PromotableOrderAdjustment {
    private static final long serialVersionUID = 1L;
    protected OrderAdjustment delegate;
    protected PromotableOrder order;
    protected boolean roundOfferValues = true;
    protected int roundingScale = 2;
    protected RoundingMode roundingMode = RoundingMode.HALF_EVEN;

    public PromotableOrderAdjustmentImpl(OrderAdjustment orderAdjustment, PromotableOrder order) {
        this.delegate = orderAdjustment;
        this.order = order;
    }

    @Override
    public void reset() {
        this.delegate = null;
    }

    @Override
    public OrderAdjustment getDelegate() {
        return this.delegate;
    }

    public boolean isRoundOfferValues() {
        return this.roundOfferValues;
    }

    public void setRoundingScale(int roundingScale) {
        this.roundingScale = roundingScale;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    @Override
    public void computeAdjustmentValue() {
        if (this.delegate.getOffer() != null && this.order != null) {
            BigDecimal offerValue;
            Money adjustmentPrice = this.order.getAdjustmentPrice();
            if (adjustmentPrice == null) {
                adjustmentPrice = this.order.getSubTotal();
            }
            if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.AMOUNT_OFF)) {
                this.delegate.setValue(new Money(this.delegate.getOffer().getValue(), adjustmentPrice.getCurrency(), 5));
            }
            if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.FIX_PRICE)) {
                offerValue = adjustmentPrice.getAmount().subtract(this.delegate.getOffer().getValue());
                this.delegate.setValue(new Money(offerValue, adjustmentPrice.getCurrency(), 5));
            }
            if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.PERCENT_OFF)) {
                offerValue = adjustmentPrice.getAmount().multiply(this.delegate.getOffer().getValue().divide(new BigDecimal("100"), 5, RoundingMode.HALF_EVEN));
                if (this.isRoundOfferValues()) {
                    offerValue = offerValue.setScale(this.roundingScale, this.roundingMode);
                }
                this.delegate.setValue(new Money(offerValue, adjustmentPrice.getCurrency(), 5));
            }
            if (adjustmentPrice.lessThan(this.delegate.getValue())) {
                this.delegate.setValue(adjustmentPrice);
            }
        }
    }

    @Override
    public Money getValue() {
        if (this.delegate.getValue() == null || this.delegate.getValue().isZero()) {
            this.computeAdjustmentValue();
        }
        return this.delegate.getValue();
    }
}

