/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationMap;
import org.broadleafcommerce.common.presentation.AdminPresentationMapKey;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.common.util.DateUtil;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Dimension;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValue;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValueImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuAttribute;
import org.broadleafcommerce.core.catalog.domain.SkuAttributeImpl;
import org.broadleafcommerce.core.catalog.domain.SkuFee;
import org.broadleafcommerce.core.catalog.domain.SkuFeeImpl;
import org.broadleafcommerce.core.catalog.domain.Weight;
import org.broadleafcommerce.core.catalog.service.dynamic.DefaultDynamicSkuPricingInvocationHandler;
import org.broadleafcommerce.core.catalog.service.dynamic.DynamicSkuPrices;
import org.broadleafcommerce.core.catalog.service.dynamic.SkuPricingConsiderationContext;
import org.broadleafcommerce.core.inventory.service.type.InventoryType;
import org.broadleafcommerce.core.media.domain.Media;
import org.broadleafcommerce.core.media.domain.MediaImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentOption;
import org.broadleafcommerce.core.order.domain.FulfillmentOptionImpl;
import org.broadleafcommerce.core.order.service.type.FulfillmentType;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_SKU")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
@AdminPresentationClass(friendlyName="baseSku")
public class SkuImpl
implements Sku {
    private static final Log LOG = LogFactory.getLog(SkuImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="SkuId")
    @GenericGenerator(name="SkuId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="table_name", value="SEQUENCE_GENERATOR"), @Parameter(name="segment_column_name", value="ID_NAME"), @Parameter(name="value_column_name", value="ID_VAL"), @Parameter(name="segment_value", value="SkuImpl"), @Parameter(name="increment_size", value="50"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.SkuImpl")})
    @Column(name="SKU_ID")
    @AdminPresentation(friendlyName="SkuImpl_Sku_ID", group="SkuImpl_Primary_Key", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @Column(name="SALE_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="SkuImpl_Sku_Sale_Price", order=2, group="SkuImpl_Price", prominent=true, fieldType=SupportedFieldType.MONEY, groupOrder=3)
    protected BigDecimal salePrice;
    @Column(name="RETAIL_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="SkuImpl_Sku_Retail_Price", order=1, group="SkuImpl_Price", prominent=true, fieldType=SupportedFieldType.MONEY, groupOrder=3)
    protected BigDecimal retailPrice;
    @Column(name="NAME")
    @Index(name="SKU_NAME_INDEX", columnNames={"NAME"})
    @AdminPresentation(friendlyName="SkuImpl_Sku_Name", order=1, group="ProductImpl_Product_Description", prominent=true, columnWidth="200", groupOrder=1)
    protected String name;
    @Column(name="DESCRIPTION")
    @AdminPresentation(friendlyName="SkuImpl_Sku_Description", order=2, group="ProductImpl_Product_Description", largeEntry=true, groupOrder=1)
    protected String description;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="LONG_DESCRIPTION", length=0x7FFFFFFE)
    @AdminPresentation(friendlyName="SkuImpl_Sku_Large_Description", order=3, group="ProductImpl_Product_Description", largeEntry=true, groupOrder=1, fieldType=SupportedFieldType.HTML_BASIC)
    protected String longDescription;
    @Column(name="TAXABLE_FLAG")
    @Index(name="SKU_TAXABLE_INDEX", columnNames={"TAXABLE_FLAG"})
    @AdminPresentation(friendlyName="SkuImpl_Sku_Taxable", order=3, group="SkuImpl_Price", groupOrder=4)
    protected Character taxable;
    @Column(name="DISCOUNTABLE_FLAG")
    @Index(name="SKU_DISCOUNTABLE_INDEX", columnNames={"DISCOUNTABLE_FLAG"})
    @AdminPresentation(friendlyName="SkuImpl_Sku_Discountable", order=4, group="SkuImpl_Price", groupOrder=4)
    protected Character discountable;
    @Column(name="AVAILABLE_FLAG")
    @Index(name="SKU_AVAILABLE_INDEX", columnNames={"AVAILABLE_FLAG"})
    @AdminPresentation(friendlyName="SkuImpl_Sku_Available", group="SkuImpl_Sku_Inventory", groupOrder=5, order=2)
    protected Character available;
    @Column(name="ACTIVE_START_DATE")
    @AdminPresentation(friendlyName="SkuImpl_Sku_Start_Date", order=7, group="ProductImpl_Product_Active_Date_Range", tooltip="skuStartDateTooltip", groupOrder=3)
    protected Date activeStartDate;
    @Column(name="ACTIVE_END_DATE")
    @Index(name="SKU_ACTIVE_INDEX", columnNames={"ACTIVE_START_DATE", "ACTIVE_END_DATE"})
    @AdminPresentation(friendlyName="SkuImpl_Sku_End_Date", order=8, group="ProductImpl_Product_Active_Date_Range", tooltip="skuEndDateTooltip", groupOrder=3)
    protected Date activeEndDate;
    @Embedded
    protected Dimension dimension = new Dimension();
    @Embedded
    protected Weight weight = new Weight();
    @Transient
    protected DynamicSkuPrices dynamicPrices = null;
    @Column(name="IS_MACHINE_SORTABLE")
    @AdminPresentation(friendlyName="ProductImpl_Is_Product_Machine_Sortable", order=19, group="ProductWeight_Shipping", prominent=false)
    protected Boolean isMachineSortable = true;
    @ManyToMany(targetEntity=MediaImpl.class)
    @JoinTable(name="BLC_SKU_MEDIA_MAP", inverseJoinColumns={@JoinColumn(name="MEDIA_ID", referencedColumnName="MEDIA_ID")})
    @MapKey(columns={@Column(name="MAP_KEY", nullable=false)})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @AdminPresentationMap(friendlyName="SkuImpl_Sku_Media", targetUIElementId="productSkuMediaLayout", dataSourceName="productMediaMapDS", keyPropertyFriendlyName="SkuImpl_Sku_Media_Key", deleteEntityUponRemove=true, mediaField="url", keys={@AdminPresentationMapKey(keyName="primary", friendlyKeyName="mediaPrimary"), @AdminPresentationMapKey(keyName="alt1", friendlyKeyName="mediaAlternate1"), @AdminPresentationMapKey(keyName="alt2", friendlyKeyName="mediaAlternate2"), @AdminPresentationMapKey(keyName="alt3", friendlyKeyName="mediaAlternate3"), @AdminPresentationMapKey(keyName="alt4", friendlyKeyName="mediaAlternate4"), @AdminPresentationMapKey(keyName="alt5", friendlyKeyName="mediaAlternate5"), @AdminPresentationMapKey(keyName="alt6", friendlyKeyName="mediaAlternate6")})
    protected Map<String, Media> skuMedia = new HashMap<String, Media>();
    @OneToOne(optional=true, targetEntity=ProductImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="DEFAULT_PRODUCT_ID")
    protected Product defaultProduct;
    @ManyToOne(optional=true, targetEntity=ProductImpl.class)
    @JoinTable(name="BLC_PRODUCT_SKU_XREF", joinColumns={@JoinColumn(name="SKU_ID", referencedColumnName="SKU_ID")}, inverseJoinColumns={@JoinColumn(name="PRODUCT_ID", referencedColumnName="PRODUCT_ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    protected Product product;
    @OneToMany(mappedBy="sku", targetEntity=SkuAttributeImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected List<SkuAttribute> skuAttributes = new ArrayList<SkuAttribute>();
    @ManyToMany(targetEntity=ProductOptionValueImpl.class)
    @JoinTable(name="BLC_SKU_OPTION_VALUE_XREF", joinColumns={@JoinColumn(name="SKU_ID", referencedColumnName="SKU_ID")}, inverseJoinColumns={@JoinColumn(name="PRODUCT_OPTION_VALUE_ID", referencedColumnName="PRODUCT_OPTION_VALUE_ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected List<ProductOptionValue> productOptionValues = new ArrayList<ProductOptionValue>();
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=SkuFeeImpl.class)
    @JoinTable(name="BLC_SKU_FEE_XREF", joinColumns={@JoinColumn(name="SKU_ID", referencedColumnName="SKU_ID", nullable=true)}, inverseJoinColumns={@JoinColumn(name="SKU_FEE_ID", referencedColumnName="SKU_FEE_ID", nullable=true)})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    protected List<SkuFee> fees = new ArrayList<SkuFee>();
    @ElementCollection
    @CollectionTable(name="BLC_SKU_FULFILLMENT_FLAT_RATES", joinColumns={@JoinColumn(name="SKU_ID", referencedColumnName="SKU_ID", nullable=true)})
    @MapKeyJoinColumn(name="FULFILLMENT_OPTION_ID", referencedColumnName="FULFILLMENT_OPTION_ID")
    @MapKeyClass(value=FulfillmentOptionImpl.class)
    @Column(name="RATE", precision=19, scale=5)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    protected Map<FulfillmentOption, BigDecimal> fulfillmentFlatRates = new HashMap<FulfillmentOption, BigDecimal>();
    @ManyToMany(targetEntity=FulfillmentOptionImpl.class)
    @JoinTable(name="BLC_SKU_FULFILLMENT_EXCLUDED", joinColumns={@JoinColumn(name="SKU_ID", referencedColumnName="SKU_ID")}, inverseJoinColumns={@JoinColumn(name="FULFILLMENT_OPTION_ID", referencedColumnName="FULFILLMENT_OPTION_ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected List<FulfillmentOption> excludedFulfillmentOptions = new ArrayList<FulfillmentOption>();
    @Column(name="INVENTORY_TYPE")
    @AdminPresentation(friendlyName="SkuImpl_Sku_InventoryType", group="SkuImpl_Sku_Inventory", order=10, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.inventory.service.type.InventoryType")
    protected String inventoryType;
    @Column(name="FULFILLMENT_TYPE")
    @AdminPresentation(friendlyName="SkuImpl_Sku_FulfillmentType", group="SkuImpl_Sku_Inventory", order=11, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.order.service.type.FulfillmentType")
    protected String fulfillmentType;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public boolean isOnSale() {
        Money retailPrice = this.getRetailPrice();
        Money salePrice = this.getSalePrice();
        return salePrice != null && !salePrice.isZero() && salePrice.lessThan(retailPrice);
    }

    protected boolean hasDefaultSku() {
        return this.product != null && this.product.getDefaultSku() != null && !this.getId().equals(this.product.getDefaultSku().getId());
    }

    protected Sku lookupDefaultSku() {
        if (this.product != null && this.product.getDefaultSku() != null) {
            return this.product.getDefaultSku();
        }
        return null;
    }

    @Override
    public Money getProductOptionValueAdjustments() {
        Money optionValuePriceAdjustments = null;
        if (this.getProductOptionValues() != null) {
            for (ProductOptionValue value : this.getProductOptionValues()) {
                if (value.getPriceAdjustment() == null) continue;
                if (optionValuePriceAdjustments == null) {
                    optionValuePriceAdjustments = value.getPriceAdjustment();
                    continue;
                }
                optionValuePriceAdjustments = optionValuePriceAdjustments.add(value.getPriceAdjustment());
            }
        }
        return optionValuePriceAdjustments;
    }

    @Override
    public Money getSalePrice() {
        Money returnPrice = null;
        if (SkuPricingConsiderationContext.hasDynamicPricing()) {
            if (this.dynamicPrices != null) {
                returnPrice = this.dynamicPrices.getSalePrice();
            } else {
                DefaultDynamicSkuPricingInvocationHandler handler = new DefaultDynamicSkuPricingInvocationHandler(this);
                Sku proxy = (Sku)Proxy.newProxyInstance(this.getClass().getClassLoader(), this.getClass().getInterfaces(), (InvocationHandler)handler);
                this.dynamicPrices = SkuPricingConsiderationContext.getSkuPricingService().getSkuPrices(proxy, SkuPricingConsiderationContext.getSkuPricingConsiderationContext());
                returnPrice = this.dynamicPrices.getSalePrice();
            }
        } else if (this.salePrice != null) {
            returnPrice = new Money(this.salePrice, Money.defaultCurrency());
        }
        if (returnPrice == null && this.hasDefaultSku()) {
            returnPrice = this.lookupDefaultSku().getSalePrice();
        }
        Money optionValueAdjustments = null;
        optionValueAdjustments = this.dynamicPrices != null ? this.dynamicPrices.getPriceAdjustment() : this.getProductOptionValueAdjustments();
        if (optionValueAdjustments != null) {
            returnPrice = returnPrice == null ? optionValueAdjustments : optionValueAdjustments.add(returnPrice);
        }
        return returnPrice;
    }

    @Override
    public void setSalePrice(Money salePrice) {
        this.salePrice = Money.toAmount((Money)salePrice);
    }

    @Override
    public Money getRetailPrice() {
        Money returnPrice = null;
        if (SkuPricingConsiderationContext.hasDynamicPricing()) {
            if (this.dynamicPrices != null) {
                returnPrice = this.dynamicPrices.getRetailPrice();
            } else {
                DefaultDynamicSkuPricingInvocationHandler handler = new DefaultDynamicSkuPricingInvocationHandler(this);
                Sku proxy = (Sku)Proxy.newProxyInstance(this.getClass().getClassLoader(), this.getClass().getInterfaces(), (InvocationHandler)handler);
                this.dynamicPrices = SkuPricingConsiderationContext.getSkuPricingService().getSkuPrices(proxy, SkuPricingConsiderationContext.getSkuPricingConsiderationContext());
                returnPrice = this.dynamicPrices.getRetailPrice();
            }
        } else if (this.retailPrice != null) {
            returnPrice = new Money(this.retailPrice, Money.defaultCurrency());
        }
        if (returnPrice == null && this.hasDefaultSku()) {
            returnPrice = this.lookupDefaultSku().getRetailPrice();
        }
        Money optionValueAdjustments = null;
        optionValueAdjustments = this.dynamicPrices != null ? this.dynamicPrices.getPriceAdjustment() : this.getProductOptionValueAdjustments();
        if (optionValueAdjustments != null) {
            returnPrice = returnPrice == null ? optionValueAdjustments : optionValueAdjustments.add(returnPrice);
        }
        return returnPrice;
    }

    @Override
    public void setRetailPrice(Money retailPrice) {
        this.retailPrice = Money.toAmount((Money)retailPrice);
    }

    @Override
    public Money getListPrice() {
        return this.getRetailPrice();
    }

    @Override
    public void setListPrice(Money listPrice) {
        this.retailPrice = Money.toAmount((Money)listPrice);
    }

    @Override
    public String getName() {
        if (this.name == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().getName();
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        if (this.description == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().getDescription();
        }
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getLongDescription() {
        if (this.longDescription == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().getLongDescription();
        }
        return this.longDescription;
    }

    @Override
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Override
    public Boolean isTaxable() {
        if (this.taxable == null) {
            if (this.hasDefaultSku()) {
                return this.lookupDefaultSku().isTaxable();
            }
            return null;
        }
        return this.taxable.charValue() == 'Y' ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Boolean getTaxable() {
        return this.isTaxable();
    }

    @Override
    public void setTaxable(Boolean taxable) {
        this.taxable = taxable == null ? null : Character.valueOf(taxable != false ? (char)'Y' : 'N');
    }

    @Override
    public Boolean isDiscountable() {
        if (this.discountable == null) {
            if (this.hasDefaultSku()) {
                return this.lookupDefaultSku().isDiscountable();
            }
            return null;
        }
        return this.discountable.charValue() == 'Y' ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getDiscountable() {
        return this.isDiscountable();
    }

    @Override
    public void setDiscountable(Boolean discountable) {
        this.discountable = discountable == null ? null : Character.valueOf(discountable != false ? (char)'Y' : 'N');
    }

    @Override
    public Boolean isAvailable() {
        if (this.available == null) {
            if (this.hasDefaultSku()) {
                return this.lookupDefaultSku().isAvailable();
            }
            return null;
        }
        return this.available.charValue() == 'Y' ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Boolean getAvailable() {
        return this.isAvailable();
    }

    @Override
    public void setAvailable(Boolean available) {
        this.available = available == null ? null : Character.valueOf(available != false ? (char)'Y' : 'N');
    }

    @Override
    public Date getActiveStartDate() {
        if (this.activeStartDate == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().getActiveStartDate();
        }
        return this.activeStartDate;
    }

    @Override
    public void setActiveStartDate(Date activeStartDate) {
        this.activeStartDate = activeStartDate;
    }

    @Override
    public Date getActiveEndDate() {
        if (this.activeEndDate == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().getActiveEndDate();
        }
        return this.activeEndDate;
    }

    @Override
    public void setActiveEndDate(Date activeEndDate) {
        this.activeEndDate = activeEndDate;
    }

    @Override
    public Dimension getDimension() {
        if (this.dimension == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().getDimension();
        }
        return this.dimension;
    }

    @Override
    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    @Override
    public Weight getWeight() {
        if (this.weight == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().getWeight();
        }
        return this.weight;
    }

    @Override
    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    @Override
    public boolean isActive() {
        if (this.activeStartDate == null && this.activeEndDate == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().isActive();
        }
        if (LOG.isDebugEnabled() && !DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)true)) {
            LOG.debug((Object)("sku, " + this.id + ", inactive due to date"));
        }
        return DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)true);
    }

    @Override
    public boolean isActive(Product product, Category category) {
        if (LOG.isDebugEnabled()) {
            if (!DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)true)) {
                LOG.debug((Object)("sku, " + this.id + ", inactive due to date"));
            } else if (!product.isActive()) {
                LOG.debug((Object)("sku, " + this.id + ", inactive due to product being inactive"));
            } else if (!category.isActive()) {
                LOG.debug((Object)("sku, " + this.id + ", inactive due to category being inactive"));
            }
        }
        return this.isActive() && product.isActive() && category.isActive();
    }

    @Override
    public Map<String, Media> getSkuMedia() {
        if ((this.skuMedia == null || this.skuMedia.isEmpty()) && this.hasDefaultSku()) {
            return this.lookupDefaultSku().getSkuMedia();
        }
        return this.skuMedia;
    }

    @Override
    public void setSkuMedia(Map<String, Media> skuMedia) {
        this.skuMedia = skuMedia;
    }

    @Override
    public Product getDefaultProduct() {
        return this.defaultProduct;
    }

    @Override
    public void setDefaultProduct(Product defaultProduct) {
        this.defaultProduct = defaultProduct;
    }

    @Override
    public Product getProduct() {
        return this.getDefaultProduct() != null ? this.getDefaultProduct() : this.product;
    }

    @Override
    public void setProduct(Product product) {
        this.product = product;
    }

    @Override
    public List<SkuAttribute> getSkuAttributes() {
        return this.skuAttributes;
    }

    @Override
    public SkuAttribute getSkuAttributeByName(String name) {
        for (SkuAttribute attribute : this.getSkuAttributes()) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public Map<String, SkuAttribute> getMappedSkuAttributes() {
        HashMap<String, SkuAttribute> map = new HashMap<String, SkuAttribute>();
        for (SkuAttribute attr : this.getSkuAttributes()) {
            map.put(attr.getName(), attr);
        }
        return map;
    }

    @Override
    public List<ProductOptionValue> getProductOptionValues() {
        return this.productOptionValues;
    }

    @Override
    public void setProductOptionValues(List<ProductOptionValue> productOptionValues) {
        this.productOptionValues = productOptionValues;
    }

    @Override
    public void setSkuAttributes(List<SkuAttribute> skuAttributes) {
        this.skuAttributes = skuAttributes;
    }

    @Override
    public Boolean isMachineSortable() {
        if (this.isMachineSortable == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().isMachineSortable();
        }
        return this.isMachineSortable;
    }

    @Override
    public void setMachineSortable(Boolean isMachineSortable) {
        this.isMachineSortable = isMachineSortable;
    }

    @Override
    public List<SkuFee> getFees() {
        return this.fees;
    }

    @Override
    public void setFees(List<SkuFee> fees) {
        this.fees = fees;
    }

    @Override
    public Map<FulfillmentOption, BigDecimal> getFulfillmentFlatRates() {
        return this.fulfillmentFlatRates;
    }

    @Override
    public void setFulfillmentFlatRates(Map<FulfillmentOption, BigDecimal> fulfillmentFlatRates) {
        this.fulfillmentFlatRates = fulfillmentFlatRates;
    }

    @Override
    public List<FulfillmentOption> getExcludedFulfillmentOptions() {
        return this.excludedFulfillmentOptions;
    }

    @Override
    public void setExcludedFulfillmentOptions(List<FulfillmentOption> excludedFulfillmentOptions) {
        this.excludedFulfillmentOptions = excludedFulfillmentOptions;
    }

    @Override
    public InventoryType getInventoryType() {
        return InventoryType.getInstance(this.inventoryType);
    }

    @Override
    public void setInventoryType(InventoryType inventoryType) {
        this.inventoryType = inventoryType.getType();
    }

    @Override
    public FulfillmentType getFulfillmentType() {
        return FulfillmentType.getInstance(this.fulfillmentType);
    }

    @Override
    public void setFulfillmentType(FulfillmentType fulfillmentType) {
        this.fulfillmentType = fulfillmentType.getType();
    }

    @Override
    public void clearDynamicPrices() {
        this.dynamicPrices = null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SkuImpl other = (SkuImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }
}

