/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.common.persistence.Status;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.catalog.dao.CategoryDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.springframework.stereotype.Repository;

@Repository(value="blCategoryDao")
public class CategoryDaoImpl
implements CategoryDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    protected Long currentDateResolution = 10000L;
    private Date currentDate = SystemTime.asDate();

    @Override
    public Category save(Category category) {
        return (Category)this.em.merge((Object)category);
    }

    @Override
    public Category readCategoryById(Long categoryId) {
        return (Category)this.em.find(CategoryImpl.class, (Object)categoryId);
    }

    @Override
    @Deprecated
    public Category readCategoryByName(String categoryName) {
        Query query = this.em.createNamedQuery("BC_READ_CATEGORY_BY_NAME");
        query.setParameter("categoryName", (Object)categoryName);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return (Category)query.getSingleResult();
    }

    @Override
    public List<Category> readCategoriesByName(String categoryName) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_CATEGORY_BY_NAME", Category.class);
        query.setParameter("categoryName", (Object)categoryName);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Category> readCategoriesByName(String categoryName, int limit, int offset) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_CATEGORY_BY_NAME", Category.class);
        query.setParameter("categoryName", (Object)categoryName);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    @Override
    public List<Category> readAllCategories() {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ALL_CATEGORIES", Category.class);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Category> readAllCategories(int limit, int offset) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ALL_CATEGORIES", Category.class);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    @Override
    public List<Product> readAllProducts() {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ALL_PRODUCTS", Product.class);
        return query.getResultList();
    }

    @Override
    public List<Product> readAllProducts(int limit, int offset) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ALL_PRODUCTS", Product.class);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    @Override
    public List<Category> readAllSubCategories(Category category) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ALL_SUBCATEGORIES", Category.class);
        query.setParameter("defaultParentCategory", (Object)category);
        return query.getResultList();
    }

    @Override
    public List<Category> readAllSubCategories(Category category, int limit, int offset) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ALL_SUBCATEGORIES", Category.class);
        query.setParameter("defaultParentCategory", (Object)category);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Category> readActiveSubCategoriesByCategory(Category category) {
        Date myDate;
        Long myCurrentDateResolution = this.currentDateResolution;
        CategoryDaoImpl categoryDaoImpl = this;
        synchronized (categoryDaoImpl) {
            Date now = SystemTime.asDate();
            myDate = now.getTime() - this.currentDate.getTime() > myCurrentDateResolution ? (this.currentDate = new Date(now.getTime())) : this.currentDate;
        }
        TypedQuery query = this.em.createNamedQuery("BC_READ_ACTIVE_SUBCATEGORIES_BY_CATEGORY", Category.class);
        query.setParameter("defaultParentCategory", (Object)category);
        query.setParameter("currentDate", (Object)myDate);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Category> readActiveSubCategoriesByCategory(Category category, int limit, int offset) {
        Date myDate;
        Long myCurrentDateResolution = this.currentDateResolution;
        CategoryDaoImpl categoryDaoImpl = this;
        synchronized (categoryDaoImpl) {
            Date now = SystemTime.asDate();
            myDate = now.getTime() - this.currentDate.getTime() > myCurrentDateResolution ? (this.currentDate = new Date(now.getTime())) : this.currentDate;
        }
        TypedQuery query = this.em.createNamedQuery("BC_READ_ACTIVE_SUBCATEGORIES_BY_CATEGORY", Category.class);
        query.setParameter("defaultParentCategory", (Object)category);
        query.setParameter("currentDate", (Object)myDate);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    @Override
    public void delete(Category category) {
        ((Status)category).setArchived(Character.valueOf('Y'));
        this.em.merge((Object)category);
    }

    @Override
    public Category create() {
        return (Category)this.entityConfiguration.createEntityInstance(Category.class.getName());
    }

    @Override
    public Long getCurrentDateResolution() {
        return this.currentDateResolution;
    }

    @Override
    public void setCurrentDateResolution(Long currentDateResolution) {
        this.currentDateResolution = currentDateResolution;
    }

    @Override
    public Category findCategoryByURI(String uri) {
        Query query = this.em.createNamedQuery("BC_READ_CATEGORY_OUTGOING_URL");
        query.setParameter("url", (Object)uri);
        List results = query.getResultList();
        if (results != null && !results.isEmpty()) {
            return (Category)results.get(0);
        }
        return null;
    }
}

