/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.fulfillment;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.TestCase;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItemImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemImpl;
import org.broadleafcommerce.core.order.fulfillment.domain.BandedPriceFulfillmentOption;
import org.broadleafcommerce.core.order.fulfillment.domain.BandedPriceFulfillmentOptionImpl;
import org.broadleafcommerce.core.order.fulfillment.domain.FulfillmentPriceBandImpl;
import org.broadleafcommerce.core.order.service.type.FulfillmentBandResultAmountType;
import org.broadleafcommerce.core.pricing.service.fulfillment.provider.BandedFulfillmentPricingProvider;

public class BandedPriceFulfillmentTest
extends TestCase {
    public void testPriceBandRate() throws Exception {
        BandedPriceFulfillmentOption option = this.createBands(new String[]{"10", "20", "30"}, new String[]{"10", "20", "30"}, new FulfillmentBandResultAmountType[]{FulfillmentBandResultAmountType.RATE, FulfillmentBandResultAmountType.RATE, FulfillmentBandResultAmountType.RATE});
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("20.00"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("20.00"), 2)));
        BandedPriceFulfillmentTest.assertEquals((Object)Money.ZERO, (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("9.00"), 3)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("30.00"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("30.00"), 3)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("20.00"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("25.00"), 5)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("30.00"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("100.00"), 5)));
    }

    public void testMinimumAmountsWithZero() throws Exception {
        BandedPriceFulfillmentOption option = this.createBands(new String[]{"0", "20", "30"}, new String[]{"10", "20", "30"}, new FulfillmentBandResultAmountType[]{FulfillmentBandResultAmountType.RATE, FulfillmentBandResultAmountType.RATE, FulfillmentBandResultAmountType.RATE});
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("20.00"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("20.00"), 2)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("10.00"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("9.00"), 3)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("30.00"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("30.00"), 3)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("20.00"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("25.00"), 5)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("30.00"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("100.00"), 5)));
    }

    public void testPriceBandPercentage() throws Exception {
        BandedPriceFulfillmentOption option = this.createBands(new String[]{"10", "30", "20"}, new String[]{".10", ".20", ".30"}, new FulfillmentBandResultAmountType[]{FulfillmentBandResultAmountType.PERCENTAGE, FulfillmentBandResultAmountType.PERCENTAGE, FulfillmentBandResultAmountType.PERCENTAGE});
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("1.50"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("15.00"), 3)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("6.00"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("30.00"), 3)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("7.50"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("25.00"), 5)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("20.00"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("100.00"), 5)));
    }

    public void testPriceBandRatesWithPercentages() throws Exception {
        BandedPriceFulfillmentOption option = this.createBands(new String[]{"150", "30", "20", "150", "10", "9", "80"}, new String[]{"50", "20", ".30", "20", ".10", "5", ".5"}, new FulfillmentBandResultAmountType[]{FulfillmentBandResultAmountType.RATE, FulfillmentBandResultAmountType.RATE, FulfillmentBandResultAmountType.PERCENTAGE, FulfillmentBandResultAmountType.RATE, FulfillmentBandResultAmountType.PERCENTAGE, FulfillmentBandResultAmountType.RATE, FulfillmentBandResultAmountType.PERCENTAGE});
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("20"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("35.00"), 5)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("20"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("9999.00"), 9)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("7.50"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("25.00"), 5)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("1.80"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("18.00"), 6)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("50"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("100.00"), 5)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("5"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("9.00"), 3)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("20"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("66"), 6)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("20"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("150"), 5)));
    }

    public void testLowestPriceSelection() throws Exception {
        BandedPriceFulfillmentOption option = this.createBands(new String[]{"10", "10", "10"}, new String[]{"30", "20", "10"}, new FulfillmentBandResultAmountType[]{FulfillmentBandResultAmountType.RATE, FulfillmentBandResultAmountType.RATE, FulfillmentBandResultAmountType.RATE});
        BandedPriceFulfillmentTest.assertEquals((Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("10.00"), 2)), (Object)new Money("10.00"));
    }

    public void testFlatRatesExclusive() throws Exception {
        BandedPriceFulfillmentOption option = this.createBands(new String[]{"100"}, new String[]{"30"}, new FulfillmentBandResultAmountType[]{FulfillmentBandResultAmountType.RATE});
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("45"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("18.00"), 3, new String[]{"10", "15", "20"}, option)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("5"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("80.00"), 1, new String[]{"5"}, option)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("10"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("18.00"), 2, new String[]{"8", "2"}, option)));
    }

    public void testFlatRatesWithBands() throws Exception {
        BandedPriceFulfillmentOption option = this.createBands(new String[]{"30", "20", "10"}, new String[]{"30", "20", "10"}, new FulfillmentBandResultAmountType[]{FulfillmentBandResultAmountType.RATE, FulfillmentBandResultAmountType.RATE, FulfillmentBandResultAmountType.RATE});
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("35"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("18.00"), 6, new String[]{"10", "15"}, option)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("125"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("18.00"), 6, new String[]{"5", "100", "20"}, option)));
        BandedPriceFulfillmentTest.assertEquals((Object)new Money("41"), (Object)this.calculationResponse(option, this.createCandidateOrder(new BigDecimal("60.00"), 6, new String[]{"8", "2", "1"}, option)));
    }

    protected Order createCandidateOrder(BigDecimal retailTotal, int orderItemsToCreate) {
        return this.createCandidateOrder(retailTotal, orderItemsToCreate, null, null);
    }

    protected Order createCandidateOrder(BigDecimal retailTotal, int orderItemsToCreate, String[] flatRates, BandedPriceFulfillmentOption option) {
        if (flatRates != null && flatRates.length > orderItemsToCreate) {
            throw new IllegalStateException("Flat rates for Skus should be less than or equal to the number of order items being created");
        }
        OrderImpl result = new OrderImpl();
        ArrayList<FulfillmentGroupItemImpl> fulfillmentItems = new ArrayList<FulfillmentGroupItemImpl>();
        for (int i = 0; i < orderItemsToCreate; ++i) {
            OrderItemImpl orderItem;
            Object object = orderItem = flatRates != null && i < flatRates.length ? new DiscreteOrderItemImpl() : new OrderItemImpl();
            if (orderItem instanceof DiscreteOrderItem && option != null) {
                SkuImpl sku = new SkuImpl();
                sku.getFulfillmentFlatRates().put(option, new BigDecimal(flatRates[i]));
                ((DiscreteOrderItem)orderItem).setSku((Sku)sku);
            }
            orderItem.setPrice(new Money(retailTotal.divide(new BigDecimal(orderItemsToCreate))));
            orderItem.setOrder((Order)result);
            FulfillmentGroupItemImpl fulfillmentItem = new FulfillmentGroupItemImpl();
            fulfillmentItem.setOrderItem((OrderItem)orderItem);
            fulfillmentItem.setQuantity(1);
            fulfillmentItems.add(fulfillmentItem);
        }
        FulfillmentGroupImpl group = new FulfillmentGroupImpl();
        group.setOrder((Order)result);
        group.setFulfillmentGroupItems(fulfillmentItems);
        ArrayList<FulfillmentGroupImpl> groups = new ArrayList<FulfillmentGroupImpl>();
        groups.add(group);
        result.setFulfillmentGroups(groups);
        return result;
    }

    protected Money calculationResponse(BandedPriceFulfillmentOption option, Order order) throws Exception {
        HashSet<BandedPriceFulfillmentOption> options = new HashSet<BandedPriceFulfillmentOption>();
        options.add(option);
        BandedFulfillmentPricingProvider provider = new BandedFulfillmentPricingProvider();
        return (Money)provider.estimateCostForFulfillmentGroup((FulfillmentGroup)order.getFulfillmentGroups().get(0), options).getFulfillmentOptionPrices().get(option);
    }

    protected BandedPriceFulfillmentOption createBands(String[] minimumAmounts, String[] resultAmounts, FulfillmentBandResultAmountType[] resultAmountTypes) {
        if (minimumAmounts.length != resultAmounts.length || resultAmounts.length != resultAmountTypes.length) {
            throw new IllegalStateException("All lists should be the same length");
        }
        ArrayList<FulfillmentPriceBandImpl> bands = new ArrayList<FulfillmentPriceBandImpl>();
        for (int i = 0; i < minimumAmounts.length; ++i) {
            FulfillmentPriceBandImpl band = new FulfillmentPriceBandImpl();
            band.setRetailPriceMinimumAmount(new BigDecimal(minimumAmounts[i]));
            band.setResultAmount(new BigDecimal(resultAmounts[i]));
            band.setResultAmountType(resultAmountTypes[i]);
            bands.add(band);
        }
        BandedPriceFulfillmentOptionImpl option = new BandedPriceFulfillmentOptionImpl();
        option.setBands(bands);
        return option;
    }
}

