/*
 * Copyright 2008-2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.broadleafcommerce.core.marketing.domain;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.TableGenerator;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_TARGET_CONTENT")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
/**
 *
 * @deprecated  No longer used as of Broadleaf 1.5
 */
@Deprecated
public class TargetContentImpl implements TargetContent {

    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(generator="targetContentId", strategy=GenerationType.TABLE)
    @TableGenerator(name="targetContentId", table="SEQUENCE_GENERATOR", pkColumnName = "ID_NAME", valueColumnName = "ID_VAL", pkColumnValue = "targetContentImpl", allocationSize = 50)
    @Column(name="TARGET_CONTENT_ID")
    protected Long id;

    @Column(name="PRIORITY", nullable=false)
    protected int priority;

    @Column(name="CONTENT_TYPE", nullable=false)
    @Index(name="TARGETCONTENT_TYPE_INDEX", columnNames={"CONTENT_TYPE"})
    protected String contentType;

    @Column(name="CONTENT_NAME", nullable=false)
    @Index(name="TARGETCONTENT_NAME_INDEX", columnNames={"CONTENT_NAME"})
    protected String contentName;

    @Column(name="URL")
    @Index(name="TARGETCONTENT_URL_INDEX", columnNames={"URL"})
    protected String url;

    @Column(name="CONTENT")
    protected String content;

    @Column(name="ONLINE_DATE")
    protected Date onlineDate;

    @Column(name="OFFLINE_DATE")
    protected Date offlineDate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getPriority() {
        return priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentName() {
        return contentName;
    }

    public void setContentName(String contentName) {
        this.contentName = contentName;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Date getOnlineDate() {
        return onlineDate;
    }

    public void setOnlineDate(Date onlineDate) {
        this.onlineDate = onlineDate;
    }

    public Date getOfflineDate() {
        return offlineDate;
    }

    public void setOfflineDate(Date offlineDate) {
        this.offlineDate = offlineDate;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((content == null) ? 0 : content.hashCode());
        result = prime * result + ((contentName == null) ? 0 : contentName.hashCode());
        result = prime * result + ((contentType == null) ? 0 : contentType.hashCode());
        result = prime * result + ((url == null) ? 0 : url.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TargetContentImpl other = (TargetContentImpl) obj;

        if (id != null && other.id != null) {
            return id.equals(other.id);
        }

        if (content == null) {
            if (other.content != null)
                return false;
        } else if (!content.equals(other.content))
            return false;
        if (contentName == null) {
            if (other.contentName != null)
                return false;
        } else if (!contentName.equals(other.contentName))
            return false;
        if (contentType == null) {
            if (other.contentType != null)
                return false;
        } else if (!contentType.equals(other.contentType))
            return false;
        if (url == null) {
            if (other.url != null)
                return false;
        } else if (!url.equals(other.url))
            return false;
        return true;
    }


}
