/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.lucene.analysis.TokenStream;
import org.broadleafcommerce.core.search.dao.SearchSynonymDao;
import org.broadleafcommerce.core.search.domain.SearchSynonym;
import org.broadleafcommerce.core.util.ApplicationContextHolder;
import org.compass.core.CompassException;
import org.compass.core.config.CompassSettings;
import org.compass.core.lucene.engine.analyzer.LuceneAnalyzerTokenFilterProvider;
import org.compass.core.lucene.engine.analyzer.synonym.SynonymFilter;
import org.compass.core.lucene.engine.analyzer.synonym.SynonymLookupProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="blSearchSynonymProvider")
public class SearchSynonymProvider
implements SynonymLookupProvider,
LuceneAnalyzerTokenFilterProvider {
    @Resource(name="blSearchSynonymDao")
    private SearchSynonymDao searchSynonymDao;
    private HashMap<String, String[]> synonymMap;

    public String[] lookupSynonyms(String value) {
        if (this.synonymMap == null) {
            this.configure(null);
        }
        if (this.synonymMap == null) {
            return null;
        }
        return this.synonymMap.get(value);
    }

    public void configure(CompassSettings settings) throws CompassException {
        if (this.searchSynonymDao == null) {
            ApplicationContext context = ApplicationContextHolder.getApplicationContext();
            if (context == null) {
                return;
            }
            this.searchSynonymDao = (SearchSynonymDao)context.getBean("blSearchSynonymDao");
        }
        this.synonymMap = new HashMap();
        List<SearchSynonym> synonyms = this.searchSynonymDao.getAllSynonyms();
        this.synonymMap.clear();
        for (SearchSynonym synonym : synonyms) {
            this.synonymMap.put(synonym.getTerm(), synonym.getSynonyms());
        }
    }

    public TokenStream createTokenFilter(TokenStream tokenStream) {
        return new SynonymFilter(tokenStream, (SynonymLookupProvider)this);
    }
}

