/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.module;

import java.math.BigDecimal;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.pricing.domain.ShippingRate;
import org.broadleafcommerce.core.pricing.service.ShippingRateService;
import org.broadleafcommerce.core.pricing.service.module.ShippingModule;
import org.broadleafcommerce.core.pricing.service.workflow.type.ShippingServiceType;
import org.broadleafcommerce.profile.core.domain.Address;

public class BandedShippingModule
implements ShippingModule {
    private static final Log LOG = LogFactory.getLog(BandedShippingModule.class);
    public static final String MODULENAME = "bandedShippingModule";
    protected String name = "bandedShippingModule";
    protected Boolean isDefaultModule = false;
    @Resource(name="blShippingRateService")
    private ShippingRateService shippingRateService;
    private Map<String, String> feeTypeMapping;
    private Map<String, String> feeSubTypeMapping;

    @Override
    public FulfillmentGroup calculateShippingForFulfillmentGroup(FulfillmentGroup fulfillmentGroup) {
        this.calculateShipping(fulfillmentGroup);
        return fulfillmentGroup;
    }

    private void calculateShipping(FulfillmentGroup fulfillmentGroup) {
        if (!this.isValidModuleForService(fulfillmentGroup.getService()).booleanValue() && !this.isDefaultModule().booleanValue()) {
            LOG.info((Object)("fulfillment group (" + fulfillmentGroup.getId() + ") with a service type of (" + fulfillmentGroup.getService() + ") is not valid for this module service type (" + this.getServiceName() + ")"));
            return;
        }
        if (fulfillmentGroup.getFulfillmentGroupItems().size() == 0) {
            LOG.warn((Object)("fulfillment group (" + fulfillmentGroup.getId() + ") does not contain any fulfillment group items. Unable to price banded shipping"));
            fulfillmentGroup.setShippingPrice(new Money(0.0));
            fulfillmentGroup.setSaleShippingPrice(new Money(0.0));
            fulfillmentGroup.setRetailShippingPrice(new Money(0.0));
            return;
        }
        Address address = fulfillmentGroup.getAddress();
        String state = address != null && address.getState() != null ? address.getState().getAbbreviation() : null;
        BigDecimal retailTotal = new BigDecimal(0);
        String feeType = this.feeTypeMapping.get(fulfillmentGroup.getMethod());
        String feeSubType = this.feeSubTypeMapping.get(state) == null ? this.feeSubTypeMapping.get("ALL") : this.feeSubTypeMapping.get(state);
        for (FulfillmentGroupItem fulfillmentGroupItem : fulfillmentGroup.getFulfillmentGroupItems()) {
            BigDecimal price;
            BigDecimal bigDecimal = price = fulfillmentGroupItem.getRetailPrice() != null ? fulfillmentGroupItem.getRetailPrice().getAmount().multiply(BigDecimal.valueOf(fulfillmentGroupItem.getQuantity())) : null;
            if (price == null) {
                price = fulfillmentGroupItem.getOrderItem().getRetailPrice().getAmount().multiply(BigDecimal.valueOf(fulfillmentGroupItem.getQuantity()));
            }
            retailTotal = retailTotal.add(price);
        }
        ShippingRate sr = this.shippingRateService.readShippingRateByFeeTypesUnityQty(feeType, feeSubType, retailTotal);
        if (sr == null) {
            throw new NotImplementedException("Shipping rate " + fulfillmentGroup.getMethod() + " not supported");
        }
        BigDecimal shippingPrice = new BigDecimal(0);
        if (sr.getBandResultPercent().compareTo(0) > 0) {
            BigDecimal percent = new BigDecimal(sr.getBandResultPercent() / 100);
            shippingPrice = retailTotal.multiply(percent);
        } else {
            shippingPrice = sr.getBandResultQuantity();
        }
        fulfillmentGroup.setShippingPrice(new Money(shippingPrice));
        fulfillmentGroup.setSaleShippingPrice(fulfillmentGroup.getShippingPrice());
        fulfillmentGroup.setRetailShippingPrice(fulfillmentGroup.getSaleShippingPrice());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getFeeTypeMapping() {
        return this.feeTypeMapping;
    }

    public void setFeeTypeMapping(Map<String, String> feeTypeMapping) {
        this.feeTypeMapping = feeTypeMapping;
    }

    public Map<String, String> getFeeSubTypeMapping() {
        return this.feeSubTypeMapping;
    }

    public void setFeeSubTypeMapping(Map<String, String> feeSubTypeMapping) {
        this.feeSubTypeMapping = feeSubTypeMapping;
    }

    @Override
    public String getServiceName() {
        return ShippingServiceType.BANDED_SHIPPING.getType();
    }

    @Override
    public Boolean isValidModuleForService(String serviceName) {
        return this.getServiceName().equals(serviceName);
    }

    @Override
    public Boolean isDefaultModule() {
        return this.isDefaultModule;
    }

    @Override
    public void setDefaultModule(Boolean isDefaultModule) {
        this.isDefaultModule = isDefaultModule;
    }
}

