/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.catalog.dao.CategoryDao;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.dao.SkuDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupDao;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.core.order.dao.OrderDao;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.PersonalMessage;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.BundleOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.DiscreteOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupItemRequest;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupRequest;
import org.broadleafcommerce.core.order.service.call.GiftWrapOrderItemRequest;
import org.broadleafcommerce.core.order.service.exception.ItemNotFoundException;
import org.broadleafcommerce.core.order.service.exception.OrderServiceException;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.payment.dao.PaymentInfoDao;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.payment.service.SecurePaymentInfoService;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.core.pricing.service.advice.PricingExecutionManager;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.workflow.WorkflowException;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Customer;

public class OrderServiceImpl
implements OrderService {
    private static final Log LOG = LogFactory.getLog(OrderServiceImpl.class);
    @Resource(name="blOrderDao")
    protected OrderDao orderDao;
    @Resource(name="blPaymentInfoDao")
    protected PaymentInfoDao paymentInfoDao;
    @Resource(name="blFulfillmentGroupDao")
    protected FulfillmentGroupDao fulfillmentGroupDao;
    @Resource(name="blFulfillmentGroupItemDao")
    protected FulfillmentGroupItemDao fulfillmentGroupItemDao;
    @Resource(name="blOfferDao")
    protected OfferDao offerDao;
    @Resource(name="blPricingExecutionManager")
    protected PricingExecutionManager pricingExecutionManager;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;
    @Resource(name="blSkuDao")
    protected SkuDao skuDao;
    @Resource(name="blProductDao")
    protected ProductDao productDao;
    @Resource(name="blCategoryDao")
    protected CategoryDao categoryDao;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;
    @Resource(name="blSecurePaymentInfoService")
    protected SecurePaymentInfoService securePaymentInfoService;

    @Override
    public Order createNamedOrderForCustomer(String name, Customer customer) {
        Order namedOrder = this.orderDao.create();
        namedOrder.setCustomer(customer);
        namedOrder.setName(name);
        namedOrder.setStatus(OrderStatus.NAMED);
        return this.persistOrder(namedOrder);
    }

    @Override
    public Order save(Order order, Boolean priceOrder) throws PricingException {
        return this.updateOrder(order, priceOrder);
    }

    @Override
    public Order findOrderById(Long orderId) {
        return this.orderDao.readOrderById(orderId);
    }

    @Override
    public List<Order> findOrdersForCustomer(Customer customer) {
        return this.orderDao.readOrdersForCustomer(customer.getId());
    }

    @Override
    public List<Order> findOrdersForCustomer(Customer customer, OrderStatus status) {
        return this.orderDao.readOrdersForCustomer(customer, status);
    }

    @Override
    public Order findNamedOrderForCustomer(String name, Customer customer) {
        return this.orderDao.readNamedOrderForCustomer(customer, name);
    }

    @Override
    public FulfillmentGroup findDefaultFulfillmentGroupForOrder(Order order) {
        FulfillmentGroup fg = this.fulfillmentGroupDao.readDefaultFulfillmentGroupForOrder(order);
        return fg;
    }

    @Override
    public DiscreteOrderItemRequest createDiscreteOrderItemRequest(Long skuId, Long productId, Long categoryId, Integer quantity) {
        Sku sku = this.skuDao.readSkuById(skuId);
        Product product = productId != null ? this.productDao.readProductById(productId) : null;
        Category category = categoryId != null ? this.categoryDao.readCategoryById(categoryId) : null;
        DiscreteOrderItemRequest itemRequest = new DiscreteOrderItemRequest();
        itemRequest.setCategory(category);
        itemRequest.setProduct(product);
        itemRequest.setQuantity(quantity);
        itemRequest.setSku(sku);
        return itemRequest;
    }

    @Override
    public OrderItem addSkuToOrder(Long orderId, Long skuId, Long productId, Long categoryId, Integer quantity) throws PricingException {
        return this.addSkuToOrder(orderId, skuId, productId, categoryId, quantity, true);
    }

    @Override
    public OrderItem addSkuToOrder(Long orderId, Long skuId, Long productId, Long categoryId, Integer quantity, boolean priceOrder) throws PricingException {
        if (orderId == null || skuId == null || quantity == null) {
            return null;
        }
        Order order = this.findOrderById(orderId);
        DiscreteOrderItemRequest itemRequest = this.createDiscreteOrderItemRequest(skuId, productId, categoryId, quantity);
        return this.addDiscreteItemToOrder(order, itemRequest, priceOrder);
    }

    @Override
    public OrderItem addDiscreteItemToOrder(Order order, DiscreteOrderItemRequest itemRequest) throws PricingException {
        return this.addDiscreteItemToOrder(order, itemRequest, true);
    }

    @Override
    public OrderItem addDiscreteItemToOrder(Order order, DiscreteOrderItemRequest itemRequest, boolean priceOrder) throws PricingException {
        DiscreteOrderItem item = this.orderItemService.createDiscreteOrderItem(itemRequest);
        return this.addOrderItemToOrder(order, item, priceOrder);
    }

    @Override
    public OrderItem addDynamicPriceDiscreteItemToOrder(Order order, DiscreteOrderItemRequest itemRequest, HashMap skuPricingConsiderations) throws PricingException {
        return this.addDynamicPriceDiscreteItemToOrder(order, itemRequest, skuPricingConsiderations, true);
    }

    @Override
    public OrderItem addDynamicPriceDiscreteItemToOrder(Order order, DiscreteOrderItemRequest itemRequest, HashMap skuPricingConsiderations, boolean priceOrder) throws PricingException {
        DiscreteOrderItem item = this.orderItemService.createDynamicPriceDiscreteOrderItem(itemRequest, skuPricingConsiderations);
        return this.addOrderItemToOrder(order, item, priceOrder);
    }

    @Override
    public OrderItem addGiftWrapItemToOrder(Order order, GiftWrapOrderItemRequest itemRequest) throws PricingException {
        return this.addGiftWrapItemToOrder(order, itemRequest, true);
    }

    @Override
    public OrderItem addGiftWrapItemToOrder(Order order, GiftWrapOrderItemRequest itemRequest, boolean priceOrder) throws PricingException {
        GiftWrapOrderItem item = this.orderItemService.createGiftWrapOrderItem(itemRequest);
        return this.addOrderItemToOrder(order, item, priceOrder);
    }

    @Override
    public OrderItem addBundleItemToOrder(Order order, BundleOrderItemRequest itemRequest) throws PricingException {
        return this.addBundleItemToOrder(order, itemRequest, true);
    }

    @Override
    public OrderItem addBundleItemToOrder(Order order, BundleOrderItemRequest itemRequest, boolean priceOrder) throws PricingException {
        BundleOrderItem item = this.orderItemService.createBundleOrderItem(itemRequest);
        return this.addOrderItemToOrder(order, item, priceOrder);
    }

    @Override
    public Order removeItemFromOrder(Long orderId, Long itemId) throws PricingException {
        return this.removeItemFromOrder(orderId, itemId, true);
    }

    @Override
    public Order removeItemFromOrder(Long orderId, Long itemId, boolean priceOrder) throws PricingException {
        Order order = this.findOrderById(orderId);
        OrderItem orderItem = this.orderItemService.readOrderItemById(itemId);
        return this.removeItemFromOrder(order, orderItem, priceOrder);
    }

    @Override
    public Order removeItemFromOrder(Order order, OrderItem item) throws PricingException {
        return this.removeItemFromOrder(order, item, true);
    }

    @Override
    public Order removeItemFromOrder(Order order, OrderItem item, boolean priceOrder) throws PricingException {
        this.removeOrderItemFromFullfillmentGroup(order, item);
        OrderItem itemFromOrder = order.getOrderItems().remove(order.getOrderItems().indexOf(item));
        this.orderItemService.delete(itemFromOrder);
        itemFromOrder.setOrder(null);
        order = this.updateOrder(order, priceOrder);
        return order;
    }

    public Order moveItemToOrder(Order originalOrder, Order destinationOrder, OrderItem item) throws PricingException {
        return this.moveItemToOrder(originalOrder, destinationOrder, item, true);
    }

    public Order moveItemToOrder(Order originalOrder, Order destinationOrder, OrderItem item, boolean priceOrder) throws PricingException {
        this.removeOrderItemFromFullfillmentGroup(originalOrder, item);
        OrderItem itemFromOrder = originalOrder.getOrderItems().remove(originalOrder.getOrderItems().indexOf(item));
        itemFromOrder.setOrder(null);
        originalOrder = this.updateOrder(originalOrder, priceOrder);
        this.addOrderItemToOrder(destinationOrder, item, priceOrder);
        return destinationOrder;
    }

    @Override
    public PaymentInfo addPaymentToOrder(Order order, PaymentInfo payment) {
        return this.addPaymentToOrder(order, payment, null);
    }

    @Override
    public PaymentInfo addPaymentToOrder(Order order, PaymentInfo payment, Referenced securePaymentInfo) {
        payment.setOrder(order);
        order.getPaymentInfos().add(payment);
        order = this.persistOrder(order);
        int paymentIndex = order.getPaymentInfos().size() - 1;
        if (securePaymentInfo != null) {
            this.securePaymentInfoService.save(securePaymentInfo);
        }
        return order.getPaymentInfos().get(paymentIndex);
    }

    @Override
    public void removeAllPaymentsFromOrder(Order order) {
        this.removePaymentsFromOrder(order, null);
    }

    @Override
    public void removePaymentsFromOrder(Order order, PaymentInfoType paymentInfoType) {
        ArrayList<PaymentInfo> infos = new ArrayList<PaymentInfo>();
        for (PaymentInfo paymentInfo : order.getPaymentInfos()) {
            if (paymentInfoType != null && !paymentInfoType.equals(paymentInfo.getType())) continue;
            infos.add(paymentInfo);
        }
        order.getPaymentInfos().removeAll(infos);
        for (PaymentInfo paymentInfo : infos) {
            try {
                this.securePaymentInfoService.findAndRemoveSecurePaymentInfo(paymentInfo.getReferenceNumber(), paymentInfo.getType());
            }
            catch (WorkflowException e) {
                LOG.debug((Object)"No secure payment is associated with the PaymentInfo", (Throwable)e);
            }
            order.getPaymentInfos().remove(paymentInfo);
            paymentInfo = this.paymentInfoDao.readPaymentInfoById(paymentInfo.getId());
            this.paymentInfoDao.delete(paymentInfo);
        }
    }

    @Override
    public FulfillmentGroup addFulfillmentGroupToOrder(FulfillmentGroupRequest fulfillmentGroupRequest) throws PricingException {
        return this.addFulfillmentGroupToOrder(fulfillmentGroupRequest, true);
    }

    @Override
    public FulfillmentGroup addFulfillmentGroupToOrder(FulfillmentGroupRequest fulfillmentGroupRequest, boolean priceOrder) throws PricingException {
        FulfillmentGroup fg = this.fulfillmentGroupDao.create();
        fg.setAddress(fulfillmentGroupRequest.getAddress());
        fg.setOrder(fulfillmentGroupRequest.getOrder());
        fg.setPhone(fulfillmentGroupRequest.getPhone());
        fg.setMethod(fulfillmentGroupRequest.getMethod());
        fg.setService(fulfillmentGroupRequest.getService());
        for (FulfillmentGroupItemRequest request : fulfillmentGroupRequest.getFulfillmentGroupItemRequests()) {
            fg = this.addItemToFulfillmentGroup(request.getOrderItem(), fg, request.getQuantity(), priceOrder);
        }
        return fg;
    }

    @Override
    public FulfillmentGroup addFulfillmentGroupToOrder(Order order, FulfillmentGroup fulfillmentGroup) throws PricingException {
        return this.addFulfillmentGroupToOrder(order, fulfillmentGroup, true);
    }

    @Override
    public FulfillmentGroup addFulfillmentGroupToOrder(Order order, FulfillmentGroup fulfillmentGroup, boolean priceOrder) throws PricingException {
        FulfillmentGroup dfg = this.findDefaultFulfillmentGroupForOrder(order);
        if (dfg == null) {
            fulfillmentGroup.setPrimary(true);
        } else if (dfg.equals(fulfillmentGroup)) {
            fulfillmentGroup.setPrimary(true);
            order.getFulfillmentGroups().remove(dfg);
        }
        fulfillmentGroup.setOrder(order);
        for (FulfillmentGroupItem fgItem : fulfillmentGroup.getFulfillmentGroupItems()) {
            for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
                if (fg.equals(fulfillmentGroup)) continue;
                fg.getFulfillmentGroupItems().remove(fgItem);
            }
        }
        fulfillmentGroup = this.fulfillmentGroupDao.save(fulfillmentGroup);
        order.getFulfillmentGroups().add(fulfillmentGroup);
        int fulfillmentGroupIndex = order.getFulfillmentGroups().size() - 1;
        order = this.updateOrder(order, priceOrder);
        return order.getFulfillmentGroups().get(fulfillmentGroupIndex);
    }

    @Override
    public FulfillmentGroup addItemToFulfillmentGroup(OrderItem item, FulfillmentGroup fulfillmentGroup, int quantity) throws PricingException {
        return this.addItemToFulfillmentGroup(item, fulfillmentGroup, quantity, true);
    }

    @Override
    public FulfillmentGroup addItemToFulfillmentGroup(OrderItem item, FulfillmentGroup fulfillmentGroup, int quantity, boolean priceOrder) throws PricingException {
        Order order = item.getOrder();
        if (order == null) {
            throw new OrderServiceException("The order item does not have an order associated with it. Check to make sure you're not adding an order item that belongs to a BundleOrderItem. BundleOrderItems cannot be split among fulfillment groups");
        }
        for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
            Iterator<FulfillmentGroupItem> itr = fg.getFulfillmentGroupItems().iterator();
            while (itr.hasNext()) {
                FulfillmentGroupItem fgItem = itr.next();
                if (!fgItem.getOrderItem().equals(item)) continue;
                itr.remove();
                this.fulfillmentGroupItemDao.delete(fgItem);
            }
        }
        if (fulfillmentGroup.getId() == null) {
            fulfillmentGroup = this.addFulfillmentGroupToOrder(order, fulfillmentGroup, priceOrder);
        }
        FulfillmentGroupItem fgi = this.createFulfillmentGroupItemFromOrderItem(item, fulfillmentGroup, quantity);
        fgi = this.fulfillmentGroupItemDao.save(fgi);
        fulfillmentGroup.addFulfillmentGroupItem(fgi);
        order = this.updateOrder(order, priceOrder);
        return fulfillmentGroup;
    }

    @Override
    public FulfillmentGroup addItemToFulfillmentGroup(OrderItem item, FulfillmentGroup fulfillmentGroup) throws PricingException {
        return this.addItemToFulfillmentGroup(item, fulfillmentGroup, true);
    }

    @Override
    public FulfillmentGroup addItemToFulfillmentGroup(OrderItem item, FulfillmentGroup fulfillmentGroup, boolean priceOrder) throws PricingException {
        return this.addItemToFulfillmentGroup(item, fulfillmentGroup, item.getQuantity(), priceOrder);
    }

    @Override
    public Order addOfferToOrder(Order order, String offerCode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateItemQuantity(Order order, OrderItem item) throws ItemNotFoundException, PricingException {
        this.updateItemQuantity(order, item, true);
    }

    @Override
    public void updateItemQuantity(Order order, OrderItem item, boolean priceOrder) throws ItemNotFoundException, PricingException {
        if (!order.getOrderItems().contains(item)) {
            throw new ItemNotFoundException("Order Item (" + item.getId() + ") not found in Order (" + order.getId() + ")");
        }
        OrderItem itemFromOrder = order.getOrderItems().get(order.getOrderItems().indexOf(item));
        itemFromOrder.setQuantity(item.getQuantity());
        order = this.updateOrder(order, priceOrder);
    }

    @Override
    public void removeAllFulfillmentGroupsFromOrder(Order order) throws PricingException {
        this.removeAllFulfillmentGroupsFromOrder(order, false);
    }

    @Override
    public void removeAllFulfillmentGroupsFromOrder(Order order, boolean priceOrder) throws PricingException {
        if (order.getFulfillmentGroups() != null) {
            Iterator<FulfillmentGroup> iterator = order.getFulfillmentGroups().iterator();
            while (iterator.hasNext()) {
                FulfillmentGroup fulfillmentGroup = iterator.next();
                iterator.remove();
                this.fulfillmentGroupDao.delete(fulfillmentGroup);
            }
            this.updateOrder(order, priceOrder);
        }
    }

    @Override
    public void removeFulfillmentGroupFromOrder(Order order, FulfillmentGroup fulfillmentGroup) throws PricingException {
        this.removeFulfillmentGroupFromOrder(order, fulfillmentGroup, true);
    }

    @Override
    public void removeFulfillmentGroupFromOrder(Order order, FulfillmentGroup fulfillmentGroup, boolean priceOrder) throws PricingException {
        order.getFulfillmentGroups().remove(fulfillmentGroup);
        this.fulfillmentGroupDao.delete(fulfillmentGroup);
        this.updateOrder(order, priceOrder);
    }

    @Override
    public Order removeOfferFromOrder(Order order, Offer offer) throws PricingException {
        return this.removeAllOffersFromOrder(order, true);
    }

    @Override
    public Order removeOfferFromOrder(Order order, Offer offer, boolean priceOrder) throws PricingException {
        order.getCandidateOrderOffers().remove(offer);
        this.offerDao.delete(offer);
        order = this.updateOrder(order, priceOrder);
        return order;
    }

    @Override
    public Order removeAllOffersFromOrder(Order order) throws PricingException {
        return this.removeAllOffersFromOrder(order, true);
    }

    @Override
    public Order removeAllOffersFromOrder(Order order, boolean priceOrder) throws PricingException {
        order.getCandidateOrderOffers().clear();
        order = this.updateOrder(order, priceOrder);
        return order;
    }

    @Override
    public void removeNamedOrderForCustomer(String name, Customer customer) {
        Order namedOrder = this.findNamedOrderForCustomer(name, customer);
        this.cancelOrder(namedOrder);
    }

    @Override
    public Order confirmOrder(Order order) {
        return this.orderDao.submitOrder(order);
    }

    @Override
    public void cancelOrder(Order order) {
        this.orderDao.delete(order);
    }

    @Override
    public List<PaymentInfo> readPaymentInfosForOrder(Order order) {
        return this.paymentInfoDao.readPaymentInfosForOrder(order);
    }

    @Override
    public OrderItem addOrderItemToOrder(Order order, OrderItem newOrderItem) throws PricingException {
        return this.addOrderItemToOrder(order, newOrderItem, true);
    }

    @Override
    public OrderItem addOrderItemToOrder(Order order, OrderItem newOrderItem, boolean priceOrder) throws PricingException {
        List<OrderItem> orderItems = order.getOrderItems();
        orderItems.add(newOrderItem);
        newOrderItem.setOrder(order);
        int orderItemIndex = orderItems.size() - 1;
        order = this.updateOrder(order, priceOrder);
        return order.getOrderItems().get(orderItemIndex);
    }

    @Override
    public OrderItem addOrderItemToBundle(Order order, BundleOrderItem bundle, DiscreteOrderItem newOrderItem, boolean priceOrder) throws PricingException {
        int bundleIndex = order.getOrderItems().indexOf(bundle);
        List<DiscreteOrderItem> orderItems = bundle.getDiscreteOrderItems();
        orderItems.add(newOrderItem);
        int orderItemIndex = orderItems.size() - 1;
        newOrderItem.setBundleOrderItem(bundle);
        order = this.updateOrder(order, priceOrder);
        return ((BundleOrderItem)order.getOrderItems().get(bundleIndex)).getDiscreteOrderItems().get(orderItemIndex);
    }

    @Override
    public Order removeItemFromBundle(Order order, BundleOrderItem bundle, OrderItem item, boolean priceOrder) throws PricingException {
        DiscreteOrderItem itemFromBundle = bundle.getDiscreteOrderItems().remove(bundle.getDiscreteOrderItems().indexOf(item));
        this.orderItemService.delete(itemFromBundle);
        itemFromBundle.setBundleOrderItem(null);
        order = this.updateOrder(order, priceOrder);
        return order;
    }

    @Override
    public FulfillmentGroup createDefaultFulfillmentGroup(Order order, Address address) {
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            if (!fulfillmentGroup.isPrimary()) continue;
            return fulfillmentGroup;
        }
        FulfillmentGroup newFg = this.fulfillmentGroupService.createEmptyFulfillmentGroup();
        newFg.setOrder(order);
        newFg.setPrimary(true);
        newFg.setAddress(address);
        for (OrderItem orderItem : order.getOrderItems()) {
            newFg.addFulfillmentGroupItem(this.createFulfillmentGroupItemFromOrderItem(orderItem, newFg, orderItem.getQuantity()));
        }
        return newFg;
    }

    public OrderDao getOrderDao() {
        return this.orderDao;
    }

    public void setOrderDao(OrderDao orderDao) {
        this.orderDao = orderDao;
    }

    public PaymentInfoDao getPaymentInfoDao() {
        return this.paymentInfoDao;
    }

    public void setPaymentInfoDao(PaymentInfoDao paymentInfoDao) {
        this.paymentInfoDao = paymentInfoDao;
    }

    public FulfillmentGroupDao getFulfillmentGroupDao() {
        return this.fulfillmentGroupDao;
    }

    public void setFulfillmentGroupDao(FulfillmentGroupDao fulfillmentGroupDao) {
        this.fulfillmentGroupDao = fulfillmentGroupDao;
    }

    public FulfillmentGroupItemDao getFulfillmentGroupItemDao() {
        return this.fulfillmentGroupItemDao;
    }

    public void setFulfillmentGroupItemDao(FulfillmentGroupItemDao fulfillmentGroupItemDao) {
        this.fulfillmentGroupItemDao = fulfillmentGroupItemDao;
    }

    public PricingExecutionManager getPricingExecutionManager() {
        return this.pricingExecutionManager;
    }

    public void setPricingExecutionManager(PricingExecutionManager pricingExecutionManager) {
        this.pricingExecutionManager = pricingExecutionManager;
    }

    public OrderItemService getOrderItemService() {
        return this.orderItemService;
    }

    public void setOrderItemService(OrderItemService orderItemService) {
        this.orderItemService = orderItemService;
    }

    @Override
    public Order findOrderByOrderNumber(String orderNumber) {
        return this.orderDao.readOrderByOrderNumber(orderNumber);
    }

    protected Order updateOrder(Order order, Boolean priceOrder) throws PricingException {
        order = this.persistOrder(order);
        if (priceOrder.booleanValue()) {
            this.pricingExecutionManager.executePricing(order);
        }
        return order;
    }

    protected Order persistOrder(Order order) {
        return this.orderDao.save(order);
    }

    protected FulfillmentGroupItem createFulfillmentGroupItemFromOrderItem(OrderItem orderItem, FulfillmentGroup fulfillmentGroup, int quantity) {
        FulfillmentGroupItem fgi = this.fulfillmentGroupItemDao.create();
        fgi.setFulfillmentGroup(fulfillmentGroup);
        fgi.setOrderItem(orderItem);
        fgi.setQuantity(quantity);
        return fgi;
    }

    protected void removeOrderItemFromFullfillmentGroup(Order order, OrderItem orderItem) {
        List<FulfillmentGroup> fulfillmentGroups = order.getFulfillmentGroups();
        for (FulfillmentGroup fulfillmentGroup : fulfillmentGroups) {
            Iterator<FulfillmentGroupItem> itr = fulfillmentGroup.getFulfillmentGroupItems().iterator();
            while (itr.hasNext()) {
                FulfillmentGroupItem fulfillmentGroupItem = itr.next();
                if (!fulfillmentGroupItem.getOrderItem().equals(orderItem)) continue;
                itr.remove();
                this.fulfillmentGroupItemDao.delete(fulfillmentGroupItem);
            }
        }
    }

    protected DiscreteOrderItemRequest createDiscreteOrderItemRequest(DiscreteOrderItem discreteOrderItem) {
        DiscreteOrderItemRequest itemRequest = new DiscreteOrderItemRequest();
        itemRequest.setCategory(discreteOrderItem.getCategory());
        itemRequest.setProduct(discreteOrderItem.getProduct());
        itemRequest.setQuantity(discreteOrderItem.getQuantity());
        itemRequest.setSku(discreteOrderItem.getSku());
        if (discreteOrderItem.getPersonalMessage() != null) {
            PersonalMessage personalMessage = this.orderItemService.createPersonalMessage();
            try {
                BeanUtils.copyProperties((Object)personalMessage, (Object)discreteOrderItem.getPersonalMessage());
                personalMessage.setId(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            itemRequest.setPersonalMessage(personalMessage);
        }
        return itemRequest;
    }

    protected BundleOrderItemRequest createBundleOrderItemRequest(BundleOrderItem bundleOrderItem, List<DiscreteOrderItemRequest> discreteOrderItemRequests) {
        BundleOrderItemRequest bundleOrderItemRequest = new BundleOrderItemRequest();
        bundleOrderItemRequest.setCategory(bundleOrderItem.getCategory());
        bundleOrderItemRequest.setName(bundleOrderItem.getName());
        bundleOrderItemRequest.setQuantity(bundleOrderItem.getQuantity());
        bundleOrderItemRequest.setDiscreteOrderItems(discreteOrderItemRequests);
        return bundleOrderItemRequest;
    }
}

