/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.util.HashMap;
import java.util.List;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.call.BundleOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.DiscreteOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupRequest;
import org.broadleafcommerce.core.order.service.call.GiftWrapOrderItemRequest;
import org.broadleafcommerce.core.order.service.exception.ItemNotFoundException;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Customer;

public interface OrderService {
    public Order createNamedOrderForCustomer(String var1, Customer var2);

    public Order save(Order var1, Boolean var2) throws PricingException;

    public Order findOrderById(Long var1);

    public List<Order> findOrdersForCustomer(Customer var1);

    public List<Order> findOrdersForCustomer(Customer var1, OrderStatus var2);

    public Order findNamedOrderForCustomer(String var1, Customer var2);

    public FulfillmentGroup findDefaultFulfillmentGroupForOrder(Order var1);

    public OrderItem addDiscreteItemToOrder(Order var1, DiscreteOrderItemRequest var2) throws PricingException;

    public OrderItem addDiscreteItemToOrder(Order var1, DiscreteOrderItemRequest var2, boolean var3) throws PricingException;

    public OrderItem addGiftWrapItemToOrder(Order var1, GiftWrapOrderItemRequest var2) throws PricingException;

    public OrderItem addGiftWrapItemToOrder(Order var1, GiftWrapOrderItemRequest var2, boolean var3) throws PricingException;

    public OrderItem addBundleItemToOrder(Order var1, BundleOrderItemRequest var2) throws PricingException;

    public OrderItem addBundleItemToOrder(Order var1, BundleOrderItemRequest var2, boolean var3) throws PricingException;

    public PaymentInfo addPaymentToOrder(Order var1, PaymentInfo var2);

    public PaymentInfo addPaymentToOrder(Order var1, PaymentInfo var2, Referenced var3);

    public FulfillmentGroup addFulfillmentGroupToOrder(FulfillmentGroupRequest var1) throws PricingException;

    public FulfillmentGroup addFulfillmentGroupToOrder(FulfillmentGroupRequest var1, boolean var2) throws PricingException;

    public FulfillmentGroup addFulfillmentGroupToOrder(Order var1, FulfillmentGroup var2) throws PricingException;

    public FulfillmentGroup addFulfillmentGroupToOrder(Order var1, FulfillmentGroup var2, boolean var3) throws PricingException;

    public FulfillmentGroup addItemToFulfillmentGroup(OrderItem var1, FulfillmentGroup var2, int var3) throws PricingException;

    public FulfillmentGroup addItemToFulfillmentGroup(OrderItem var1, FulfillmentGroup var2, int var3, boolean var4) throws PricingException;

    public FulfillmentGroup addItemToFulfillmentGroup(OrderItem var1, FulfillmentGroup var2) throws PricingException;

    public FulfillmentGroup addItemToFulfillmentGroup(OrderItem var1, FulfillmentGroup var2, boolean var3) throws PricingException;

    public Order addOfferToOrder(Order var1, String var2);

    public void updateItemQuantity(Order var1, OrderItem var2) throws ItemNotFoundException, PricingException;

    public void updateItemQuantity(Order var1, OrderItem var2, boolean var3) throws ItemNotFoundException, PricingException;

    public void removeFulfillmentGroupFromOrder(Order var1, FulfillmentGroup var2) throws PricingException;

    public void removeFulfillmentGroupFromOrder(Order var1, FulfillmentGroup var2, boolean var3) throws PricingException;

    public Order removeItemFromOrder(Order var1, OrderItem var2) throws PricingException;

    public Order removeItemFromOrder(Order var1, OrderItem var2, boolean var3) throws PricingException;

    public Order removeOfferFromOrder(Order var1, Offer var2) throws PricingException;

    public Order removeOfferFromOrder(Order var1, Offer var2, boolean var3) throws PricingException;

    public Order removeAllOffersFromOrder(Order var1) throws PricingException;

    public Order removeAllOffersFromOrder(Order var1, boolean var2) throws PricingException;

    public void removeNamedOrderForCustomer(String var1, Customer var2);

    public Order confirmOrder(Order var1);

    public void cancelOrder(Order var1);

    public void removeAllFulfillmentGroupsFromOrder(Order var1) throws PricingException;

    public void removeAllFulfillmentGroupsFromOrder(Order var1, boolean var2) throws PricingException;

    public List<PaymentInfo> readPaymentInfosForOrder(Order var1);

    public OrderItem addSkuToOrder(Long var1, Long var2, Long var3, Long var4, Integer var5) throws PricingException;

    public OrderItem addSkuToOrder(Long var1, Long var2, Long var3, Long var4, Integer var5, boolean var6) throws PricingException;

    public Order removeItemFromOrder(Long var1, Long var2) throws PricingException;

    public Order removeItemFromOrder(Long var1, Long var2, boolean var3) throws PricingException;

    public void removeAllPaymentsFromOrder(Order var1);

    public FulfillmentGroup createDefaultFulfillmentGroup(Order var1, Address var2);

    public OrderItem addOrderItemToOrder(Order var1, OrderItem var2) throws PricingException;

    public OrderItem addOrderItemToOrder(Order var1, OrderItem var2, boolean var3) throws PricingException;

    public Order findOrderByOrderNumber(String var1);

    public void removePaymentsFromOrder(Order var1, PaymentInfoType var2);

    public DiscreteOrderItemRequest createDiscreteOrderItemRequest(Long var1, Long var2, Long var3, Integer var4);

    public OrderItem addDynamicPriceDiscreteItemToOrder(Order var1, DiscreteOrderItemRequest var2, HashMap var3) throws PricingException;

    public OrderItem addDynamicPriceDiscreteItemToOrder(Order var1, DiscreteOrderItemRequest var2, HashMap var3, boolean var4) throws PricingException;

    public OrderItem addOrderItemToBundle(Order var1, BundleOrderItem var2, DiscreteOrderItem var3, boolean var4) throws PricingException;

    public Order removeItemFromBundle(Order var1, BundleOrderItem var2, OrderItem var3, boolean var4) throws PricingException;
}

